/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.base.GreenMailOperations;
import com.icegreen.greenmail.configuration.ConfiguredGreenMail;
import com.icegreen.greenmail.configuration.GreenMailConfiguration;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.pop3.Pop3Server;
import com.icegreen.greenmail.server.AbstractServer;
import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.smtp.SmtpServer;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.InMemoryStore;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.Store;
import com.icegreen.greenmail.store.StoredMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.GreenMailUtil;
import com.icegreen.greenmail.util.ServerSetup;
import com.icegreen.greenmail.util.ServerSetupTest;
import com.icegreen.greenmail.util.Service;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenMail
extends ConfiguredGreenMail {
    protected final Logger log = LoggerFactory.getLogger(GreenMail.class);
    protected Managers managers;
    protected final Map<String, AbstractServer> services = new HashMap<String, AbstractServer>();
    protected ServerSetup[] config;

    public GreenMail() {
        this(ServerSetupTest.ALL);
    }

    public GreenMail(ServerSetup config) {
        this(new ServerSetup[]{config});
    }

    public GreenMail(ServerSetup[] config) {
        this.config = config;
        if (this.log.isDebugEnabled()) {
            this.log.debug("GreenMail version: {}", (Object)BuildInfo.INSTANCE.getProjectVersion());
            this.log.debug("{} {} {}", new Object[]{System.getProperty("java.vm.name", "java.vm.name"), System.getProperty("java.vm.vendor", "java.vm.vendor"), System.getProperty("java.runtime.version", "java.runtime.version")});
            this.log.debug("file.encoding : {}", (Object)System.getProperty("file.encoding", "file.encoding"));
        }
        this.init();
    }

    private void init() {
        if (this.managers == null) {
            this.managers = new Managers();
        }
        this.services.clear();
        this.services.putAll(this.createServices(this.config, this.managers));
    }

    @Override
    public synchronized void start() {
        this.init();
        Collection<AbstractServer> servers = this.services.values();
        for (AbstractServer service : servers) {
            service.startService();
        }
        for (AbstractServer service : servers) {
            try {
                service.waitTillRunning(service.getServerSetup().getServerStartupTimeout());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Could not start mail service " + service, ex);
            }
        }
        this.log.debug("Started services, performing check if all up");
        for (AbstractServer service : servers) {
            if (service.isRunning()) continue;
            throw new IllegalStateException("Could not start mail server " + service + ", try to set server startup timeout > " + service.getServerSetup().getServerStartupTimeout() + " via " + ServerSetup.class.getSimpleName() + ".setServerStartupTimeout(timeoutInMs) or -Dgreenmail.startup.timeout");
        }
        this.doConfigure();
    }

    @Override
    public synchronized void stop() {
        this.log.debug("Stopping GreenMail ...");
        for (Service service : this.services.values()) {
            this.log.debug("Stopping service {}", (Object)service);
            service.stopService();
        }
        this.services.clear();
        this.managers = new Managers();
    }

    @Override
    public void reset() {
        this.stop();
        this.start();
    }

    protected Map<String, AbstractServer> createServices(ServerSetup[] config, Managers mgr) {
        HashMap<String, AbstractServer> srvc = new HashMap<String, AbstractServer>();
        for (ServerSetup setup : config) {
            if (srvc.containsKey(setup.getProtocol())) {
                throw new IllegalArgumentException("Server '" + setup.getProtocol() + "' was found at least twice in setup config");
            }
            String protocol = setup.getProtocol();
            if (protocol.startsWith("smtp")) {
                srvc.put(protocol, new SmtpServer(setup, mgr));
                continue;
            }
            if (protocol.startsWith("pop3")) {
                srvc.put(protocol, new Pop3Server(setup, mgr));
                continue;
            }
            if (!protocol.startsWith("imap")) continue;
            srvc.put(protocol, new ImapServer(setup, mgr));
        }
        return srvc;
    }

    @Override
    public SmtpServer getSmtp() {
        return (SmtpServer)this.services.get("smtp");
    }

    @Override
    public ImapServer getImap() {
        return (ImapServer)this.services.get("imap");
    }

    @Override
    public Pop3Server getPop3() {
        return (Pop3Server)this.services.get("pop3");
    }

    @Override
    public SmtpServer getSmtps() {
        return (SmtpServer)this.services.get("smtps");
    }

    @Override
    public ImapServer getImaps() {
        return (ImapServer)this.services.get("imaps");
    }

    @Override
    public Pop3Server getPop3s() {
        return (Pop3Server)this.services.get("pop3s");
    }

    @Override
    public synchronized Managers getManagers() {
        return this.managers;
    }

    @Override
    public UserManager getUserManager() {
        return this.getManagers().getUserManager();
    }

    @Override
    public boolean waitForIncomingEmail(long timeout, int emailCount) {
        CountDownLatch waitObject = this.getManagers().getSmtpManager().createAndAddNewWaitObject(emailCount);
        long endTime = System.currentTimeMillis() + timeout;
        while (waitObject.getCount() > 0L) {
            long waitTime = endTime - System.currentTimeMillis();
            if (waitTime < 0L) {
                return waitObject.getCount() == 0L;
            }
            try {
                waitObject.await(waitTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        return waitObject.getCount() == 0L;
    }

    @Override
    public boolean waitForIncomingEmail(int emailCount) {
        return this.waitForIncomingEmail(5000L, emailCount);
    }

    @Override
    public MimeMessage[] getReceivedMessages() {
        List<StoredMessage> msgs = this.getManagers().getImapHostManager().getAllMessages();
        MimeMessage[] ret = new MimeMessage[msgs.size()];
        for (int i = 0; i < msgs.size(); ++i) {
            StoredMessage storedMessage = msgs.get(i);
            ret[i] = storedMessage.getMimeMessage();
        }
        return ret;
    }

    @Override
    public MimeMessage[] getReceivedMessagesForDomain(String domain) {
        List<StoredMessage> msgs = this.getManagers().getImapHostManager().getAllMessages();
        ArrayList<MimeMessage> ret = new ArrayList<MimeMessage>();
        try {
            for (StoredMessage msg : msgs) {
                String tos = GreenMailUtil.getAddressList(msg.getMimeMessage().getAllRecipients());
                if (null == tos || !tos.toLowerCase().contains(domain.toLowerCase())) continue;
                ret.add(msg.getMimeMessage());
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return ret.toArray(new MimeMessage[0]);
    }

    private List<StoredMessage> getMessagesForUser(ImapHostManager imapHostManager, GreenMailUser user) {
        try {
            return imapHostManager.getInbox(user).getMessages();
        }
        catch (FolderException e) {
            this.log.warn("Ignoring error fetching messages for user {}", (Object)user.getEmail(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Stream<MimeMessage> findReceivedMessages(Predicate<GreenMailUser> userPredicate, Predicate<MimeMessage> messagePredicate) {
        ImapHostManager imapHostManager = this.getManagers().getImapHostManager();
        return this.getUserManager().findUsers(userPredicate).flatMap(u -> this.getMessagesForUser(imapHostManager, (GreenMailUser)u).stream().map(StoredMessage::getMimeMessage).filter(messagePredicate));
    }

    @Override
    public GreenMailUser setUser(String login, String password) {
        return this.setUser(login, login, password);
    }

    @Override
    public GreenMailUser setUser(String email, String login, String password) {
        UserManager userManager = this.getUserManager();
        GreenMailUser user = userManager.getUser(login);
        if (null == user) {
            try {
                user = userManager.createUser(email, login, password);
            }
            catch (UserException e) {
                throw new IllegalStateException(e);
            }
        } else {
            user.setPassword(password);
        }
        return user;
    }

    @Override
    public void setQuotaSupported(boolean isEnabled) {
        this.getManagers().getImapHostManager().getStore().setQuotaSupported(isEnabled);
    }

    @Override
    public void setUsers(Properties users) {
        for (Object o : users.keySet()) {
            String email = (String)o;
            String password = users.getProperty(email);
            this.setUser(email, email, password);
        }
    }

    @Override
    public GreenMail withConfiguration(GreenMailConfiguration config) {
        super.withConfiguration(config);
        return this;
    }

    @Override
    public void purgeEmailFromAllMailboxes() throws FolderException {
        ImapHostManager imapHostManager = this.getManagers().getImapHostManager();
        InMemoryStore store = (InMemoryStore)imapHostManager.getStore();
        Collection<MailFolder> mailboxes = store.listMailboxes("*");
        for (MailFolder folder : mailboxes) {
            folder.deleteAllMessages();
        }
    }

    @Override
    public boolean isRunning() {
        for (AbstractServer service : this.services.values()) {
            if (service.isRunning()) continue;
            this.log.debug("Service {} is not running", (Object)service);
            return false;
        }
        return !this.services.isEmpty();
    }

    @Override
    public GreenMailOperations loadEmails(Path sourceDirectory) throws IOException, FolderException {
        SmtpServer smtpServer;
        if (!Files.isDirectory(sourceDirectory, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory: " + sourceDirectory.toAbsolutePath());
        }
        int sourceNameCount = sourceDirectory.toAbsolutePath().getNameCount();
        SmtpServer smtpServer2 = smtpServer = null != this.getSmtp() ? this.getSmtp() : this.getSmtps();
        if (null == smtpServer) {
            throw new IllegalStateException("Requires enabled SMTP(S)");
        }
        Session session = smtpServer.createSession();
        UserManager userManager = this.getUserManager();
        ImapHostManager imapHostManager = this.getManagers().getImapHostManager();
        Store store = imapHostManager.getStore();
        try (Stream<Path> pathStream = Files.walk(sourceDirectory, new FileVisitOption[0]);){
            for (Path emailPath : pathStream.filter(path -> !path.equals(sourceDirectory) && !this.isHiddenOrInHiddenDir(sourceDirectory, (Path)path)).map(Path::toAbsolutePath).collect(Collectors.toList())) {
                this.loadEmail(sourceDirectory, emailPath, sourceNameCount, userManager, store, imapHostManager, session);
            }
        }
        return this;
    }

    private void loadEmail(Path sourceDirectory, Path emailPath, int sourceNameCount, UserManager userManager, Store store, ImapHostManager imapHostManager, Session session) throws FolderException {
        int emailPathNameCount = emailPath.getNameCount();
        if (emailPathNameCount - sourceNameCount < 1) {
            throw new IllegalArgumentException("Expected <USER*> / <FOLDER*> (e.g. INBOX, Drafts, ...) / <*.eml> below " + sourceDirectory + " for " + emailPath);
        }
        String email = emailPath.getName(sourceNameCount).toString();
        GreenMailUser user = userManager.getUserByEmail(email);
        if (null == user) {
            try {
                user = userManager.createUser(email, email, email);
            }
            catch (UserException e) {
                throw new IllegalStateException("Can not create user for email " + email, e);
            }
        }
        MailFolder folder = store.getMailbox(this.getUserBaseMailboxName(imapHostManager, user));
        for (int i = sourceNameCount + 1; i < emailPathNameCount; ++i) {
            if (i >= emailPathNameCount - 1 && !Files.isDirectory(emailPath, new LinkOption[0])) continue;
            String namePart = emailPath.getName(i).toString();
            MailFolder child = store.getMailbox(folder, namePart);
            if (null == child) {
                child = store.createMailbox(folder, namePart, true);
            }
            folder = child;
        }
        if (Files.isRegularFile(emailPath, new LinkOption[0]) && emailPath.toString().endsWith(".eml")) {
            try (InputStream source = Files.newInputStream(emailPath, new OpenOption[0]);){
                MimeMessage loadedMsg = new MimeMessage(session, source);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Loading email for {} from {} ...", (Object)user.getEmail(), (Object)emailPath);
                }
                folder.store(loadedMsg);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not load email " + emailPath, e);
            }
        }
    }

    private String getUserBaseMailboxName(ImapHostManager imapHostManager, GreenMailUser user) throws FolderException {
        String inbox = imapHostManager.getInbox(user).getFullName();
        if (!inbox.toUpperCase().endsWith("INBOX")) {
            throw new IllegalStateException("Mail folder '" + inbox + "' is not expected " + "INBOX" + " folder");
        }
        return inbox.substring(0, inbox.length() - "INBOX".length());
    }

    public boolean isHiddenOrInHiddenDir(Path baseDirectory, Path path) {
        if (baseDirectory.equals(path)) {
            return false;
        }
        try {
            return Files.isHidden(path) || path.getParent() != null && this.isHiddenOrInHiddenDir(baseDirectory, path.getParent());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed during preloading '" + path + "'", e);
        }
    }
}

