/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.meta.common.utils;

import com.igormaznitsa.meta.annotation.Weight;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ThreadUtils {
    private ThreadUtils() {
    }

    @Weight(value=Weight.Unit.VARIABLE)
    public static boolean silentSleep(long milliseconds) {
        boolean result = true;
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            result = false;
        }
        return result;
    }

    @Nonnull
    @Weight(value=Weight.Unit.VARIABLE)
    public static StackTraceElement stackElement() {
        StackTraceElement[] allElements = Thread.currentThread().getStackTrace();
        return allElements[2];
    }

    @Weight(value=Weight.Unit.VARIABLE)
    public static int stackDepth() {
        return Thread.currentThread().getStackTrace().length - 1;
    }
}

