/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.mvngolang.cvs;

import com.igormaznitsa.mvngolang.cvs.AbstractRepo;
import com.igormaznitsa.mvngolang.cvs.CvsBZR;
import com.igormaznitsa.mvngolang.cvs.CvsGIT;
import com.igormaznitsa.mvngolang.cvs.CvsHG;
import com.igormaznitsa.mvngolang.cvs.CvsNone;
import com.igormaznitsa.mvngolang.cvs.CvsSVN;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum CVSType {
    UNKNOWN(new CvsNone()),
    GIT(new CvsGIT()),
    HG(new CvsHG()),
    SVN(new CvsSVN()),
    BAZAAR(new CvsBZR());

    private final AbstractRepo processor;

    private CVSType(AbstractRepo processor) {
        this.processor = processor;
    }

    @Nonnull
    public static CVSType investigateFolder(@Nullable File folder) {
        CVSType result = UNKNOWN;
        for (CVSType t : CVSType.values()) {
            if (!t.getProcessor().doesContainCVS(folder)) continue;
            result = t;
            break;
        }
        return result;
    }

    @Nonnull
    public AbstractRepo getProcessor() {
        return this.processor;
    }
}

