/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.BuilderConfig;
import com.influxdb.client.domain.QueryEditMode;
import java.io.IOException;

/**
 * DashboardQuery
 */

public class DashboardQuery {
  public static final String SERIALIZED_NAME_TEXT = "text";
  @SerializedName(SERIALIZED_NAME_TEXT)
  private String text;

  public static final String SERIALIZED_NAME_EDIT_MODE = "editMode";
  @SerializedName(SERIALIZED_NAME_EDIT_MODE)
  private QueryEditMode editMode = null;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_BUILDER_CONFIG = "builderConfig";
  @SerializedName(SERIALIZED_NAME_BUILDER_CONFIG)
  private BuilderConfig builderConfig = null;

  public DashboardQuery text(String text) {
    this.text = text;
    return this;
  }

   /**
   * The text of the Flux query.
   * @return text
  **/
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  public DashboardQuery editMode(QueryEditMode editMode) {
    this.editMode = editMode;
    return this;
  }

   /**
   * Get editMode
   * @return editMode
  **/
  public QueryEditMode getEditMode() {
    return editMode;
  }

  public void setEditMode(QueryEditMode editMode) {
    this.editMode = editMode;
  }

  public DashboardQuery name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DashboardQuery builderConfig(BuilderConfig builderConfig) {
    this.builderConfig = builderConfig;
    return this;
  }

   /**
   * Get builderConfig
   * @return builderConfig
  **/
  public BuilderConfig getBuilderConfig() {
    return builderConfig;
  }

  public void setBuilderConfig(BuilderConfig builderConfig) {
    this.builderConfig = builderConfig;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DashboardQuery dashboardQuery = (DashboardQuery) o;
    return Objects.equals(this.text, dashboardQuery.text) &&
        Objects.equals(this.editMode, dashboardQuery.editMode) &&
        Objects.equals(this.name, dashboardQuery.name) &&
        Objects.equals(this.builderConfig, dashboardQuery.builderConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, editMode, name, builderConfig);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DashboardQuery {\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    editMode: ").append(toIndentedString(editMode)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    builderConfig: ").append(toIndentedString(builderConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

