/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.RenamableField;
import java.io.IOException;

/**
 * TableViewPropertiesTableOptions
 */

public class TableViewPropertiesTableOptions {
  public static final String SERIALIZED_NAME_VERTICAL_TIME_AXIS = "verticalTimeAxis";
  @SerializedName(SERIALIZED_NAME_VERTICAL_TIME_AXIS)
  private Boolean verticalTimeAxis;

  public static final String SERIALIZED_NAME_SORT_BY = "sortBy";
  @SerializedName(SERIALIZED_NAME_SORT_BY)
  private RenamableField sortBy = null;

  /**
   * Wrapping describes the text wrapping style to be used in table views
   */
  @JsonAdapter(WrappingEnum.Adapter.class)
  public enum WrappingEnum {
    TRUNCATE("truncate"),
    
    WRAP("wrap"),
    
    SINGLE_LINE("single-line");

    private String value;

    WrappingEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static WrappingEnum fromValue(String text) {
      for (WrappingEnum b : WrappingEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<WrappingEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final WrappingEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public WrappingEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return WrappingEnum.fromValue(String.valueOf(value));
      }
    }
  }

  public static final String SERIALIZED_NAME_WRAPPING = "wrapping";
  @SerializedName(SERIALIZED_NAME_WRAPPING)
  private WrappingEnum wrapping;

  public static final String SERIALIZED_NAME_FIX_FIRST_COLUMN = "fixFirstColumn";
  @SerializedName(SERIALIZED_NAME_FIX_FIRST_COLUMN)
  private Boolean fixFirstColumn;

  public TableViewPropertiesTableOptions verticalTimeAxis(Boolean verticalTimeAxis) {
    this.verticalTimeAxis = verticalTimeAxis;
    return this;
  }

   /**
   * verticalTimeAxis describes the orientation of the table by indicating whether the time axis will be displayed vertically
   * @return verticalTimeAxis
  **/
  public Boolean getVerticalTimeAxis() {
    return verticalTimeAxis;
  }

  public void setVerticalTimeAxis(Boolean verticalTimeAxis) {
    this.verticalTimeAxis = verticalTimeAxis;
  }

  public TableViewPropertiesTableOptions sortBy(RenamableField sortBy) {
    this.sortBy = sortBy;
    return this;
  }

   /**
   * Get sortBy
   * @return sortBy
  **/
  public RenamableField getSortBy() {
    return sortBy;
  }

  public void setSortBy(RenamableField sortBy) {
    this.sortBy = sortBy;
  }

  public TableViewPropertiesTableOptions wrapping(WrappingEnum wrapping) {
    this.wrapping = wrapping;
    return this;
  }

   /**
   * Wrapping describes the text wrapping style to be used in table views
   * @return wrapping
  **/
  public WrappingEnum getWrapping() {
    return wrapping;
  }

  public void setWrapping(WrappingEnum wrapping) {
    this.wrapping = wrapping;
  }

  public TableViewPropertiesTableOptions fixFirstColumn(Boolean fixFirstColumn) {
    this.fixFirstColumn = fixFirstColumn;
    return this;
  }

   /**
   * fixFirstColumn indicates whether the first column of the table should be locked
   * @return fixFirstColumn
  **/
  public Boolean getFixFirstColumn() {
    return fixFirstColumn;
  }

  public void setFixFirstColumn(Boolean fixFirstColumn) {
    this.fixFirstColumn = fixFirstColumn;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TableViewPropertiesTableOptions tableViewPropertiesTableOptions = (TableViewPropertiesTableOptions) o;
    return Objects.equals(this.verticalTimeAxis, tableViewPropertiesTableOptions.verticalTimeAxis) &&
        Objects.equals(this.sortBy, tableViewPropertiesTableOptions.sortBy) &&
        Objects.equals(this.wrapping, tableViewPropertiesTableOptions.wrapping) &&
        Objects.equals(this.fixFirstColumn, tableViewPropertiesTableOptions.fixFirstColumn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(verticalTimeAxis, sortBy, wrapping, fixFirstColumn);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TableViewPropertiesTableOptions {\n");
    sb.append("    verticalTimeAxis: ").append(toIndentedString(verticalTimeAxis)).append("\n");
    sb.append("    sortBy: ").append(toIndentedString(sortBy)).append("\n");
    sb.append("    wrapping: ").append(toIndentedString(wrapping)).append("\n");
    sb.append("    fixFirstColumn: ").append(toIndentedString(fixFirstColumn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

