/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import com.ing.data.cassandra.jdbc.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class TinyintToIntCodec
extends AbstractCodec<Integer>
implements TypeCodec<Integer> {
    @Nonnull
    public GenericType<Integer> getJavaType() {
        return GenericType.INTEGER;
    }

    @Nonnull
    public DataType getCqlType() {
        return DataTypes.TINYINT;
    }

    public ByteBuffer encode(Integer value, @Nonnull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value);
    }

    public Integer decode(ByteBuffer bytes, @Nonnull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        byte value = bytes.duplicate().get();
        return value;
    }

    @Override
    Integer parseNonNull(@Nonnull String value) {
        return Integer.valueOf(value);
    }

    @Override
    String formatNonNull(@Nonnull Integer value) {
        return String.valueOf(value);
    }
}

