/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.MarshalException;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.time.format.DateTimeFormatter;

public class JdbcDate
extends AbstractJdbcType<Date> {
    public static final JdbcDate INSTANCE = new JdbcDate();
    private static final int DEFAULT_DATE_PRECISION = 10;

    JdbcDate() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Date obj) {
        return 0;
    }

    @Override
    public int getPrecision(Date obj) {
        return 10;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public String toString(Date obj) {
        if (obj != null) {
            return obj.toLocalDate().format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        return null;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A date is exactly 8 bytes (stored as a long), but found: " + bytes.remaining());
        }
        return this.toString(new Date(bytes.getLong(bytes.position())));
    }

    @Override
    public Class<Date> getType() {
        return Date.class;
    }

    @Override
    public int getJdbcType() {
        return 91;
    }

    @Override
    public Date compose(Object value) {
        return (Date)value;
    }

    @Override
    public Object decompose(Date value) {
        return value;
    }
}

