/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.AssertionResult;
import com.intuit.karate.AssignType;
import com.intuit.karate.CallResult;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.MatchType;
import com.intuit.karate.ScriptBridge;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.cucumber.CucumberUtils;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.validator.ArrayValidator;
import com.intuit.karate.validator.BooleanValidator;
import com.intuit.karate.validator.IgnoreValidator;
import com.intuit.karate.validator.NotNullValidator;
import com.intuit.karate.validator.NullValidator;
import com.intuit.karate.validator.NumberValidator;
import com.intuit.karate.validator.ObjectValidator;
import com.intuit.karate.validator.RegexValidator;
import com.intuit.karate.validator.StringValidator;
import com.intuit.karate.validator.UuidValidator;
import com.intuit.karate.validator.ValidationResult;
import com.intuit.karate.validator.Validator;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Script {
    public static final String VAR_SELF = "_";
    public static final String VAR_DOLLAR = "$";
    private static final Pattern VAR_AND_PATH_PATTERN = Pattern.compile("\\w+");
    private static final String VARIABLE_PATTERN_STRING = "[a-zA-Z][\\w]*";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("[a-zA-Z][\\w]*");
    private static final String TOKEN = "token";

    private Script() {
    }

    public static final boolean isCallSyntax(String text) {
        return text.startsWith("call ");
    }

    public static final boolean isCallOnceSyntax(String text) {
        return text.startsWith("callonce ");
    }

    public static final boolean isGetSyntax(String text) {
        return text.startsWith("get ");
    }

    public static final boolean isJson(String text) {
        return text.startsWith("{") || text.startsWith("[");
    }

    public static final boolean isXml(String text) {
        return text.startsWith("<");
    }

    public static final boolean isXmlPath(String text) {
        return text.startsWith("/");
    }

    public static final boolean isXmlPathFunction(String text) {
        return text.matches("^[a-z-]+\\(.+");
    }

    public static final boolean isEmbeddedExpression(String text) {
        return (text.startsWith("#(") || text.startsWith("##(")) && text.endsWith(")");
    }

    public static final boolean isWithinParantheses(String text) {
        return text.startsWith("(") && text.endsWith(")");
    }

    public static final boolean isContainsMacro(String text) {
        return text.startsWith("^");
    }

    public static final boolean isNotContainsMacro(String text) {
        return text.startsWith("!^");
    }

    public static final boolean isJsonPath(String text) {
        return text.startsWith("$.") || text.startsWith("$[") || text.equals(VAR_DOLLAR);
    }

    public static final boolean isVariable(String text) {
        return VARIABLE_PATTERN.matcher(text).matches();
    }

    public static final boolean isVariableAndSpaceAndPath(String text) {
        return text.matches("^[a-zA-Z][\\w]*\\s+.+");
    }

    public static final boolean isVariableAndJsonPath(String text) {
        return !text.endsWith(")") && text.matches("^[a-zA-Z][\\w]*\\..+");
    }

    public static final boolean isVariableAndXmlPath(String text) {
        return text.matches("^[a-zA-Z][\\w]*/.*");
    }

    public static final boolean isStringExpression(String text) {
        return text.startsWith("'") || text.startsWith("\"") || text.endsWith("'") || text.endsWith("\"");
    }

    public static boolean isJavaScriptFunction(String text) {
        return text.matches("^function\\s*[(].+");
    }

    public static Pair<String, String> parseVariableAndPath(String text) {
        Matcher matcher = VAR_AND_PATH_PATTERN.matcher(text);
        matcher.find();
        String name = text.substring(0, matcher.end());
        String path = matcher.end() == text.length() ? "" : text.substring(matcher.end());
        if (!Script.isXmlPath(path) && !Script.isXmlPathFunction(path)) {
            path = VAR_DOLLAR + path;
        }
        return Pair.of((Object)name, (Object)path);
    }

    public static ScriptValue eval(String text, ScriptContext context) {
        return Script.eval(text, context, false);
    }

    private static ScriptValue callWithCache(String text, String arg, ScriptContext context, boolean reuseParentConfig) {
        CallResult result = context.env.callCache.get(text);
        if (result != null) {
            context.logger.debug("callonce cache hit for: {}", (Object)text);
            if (reuseParentConfig) {
                context.configure(result.config);
            }
            return result.value;
        }
        ScriptValue resultValue = Script.call(text, arg, context, reuseParentConfig);
        context.env.callCache.put(text, resultValue, context.config);
        context.logger.debug("cached callonce: {}", (Object)text);
        return resultValue;
    }

    private static ScriptValue eval(String text, ScriptContext context, boolean reuseParentConfig) {
        if ((text = StringUtils.trimToEmpty((String)text)).isEmpty()) {
            return ScriptValue.NULL;
        }
        boolean callOnce = Script.isCallOnceSyntax(text);
        if (callOnce || Script.isCallSyntax(text)) {
            String arg;
            text = callOnce ? text.substring(9) : text.substring(5);
            int pos = text.indexOf(32);
            if (pos != -1) {
                arg = text.substring(pos);
                text = text.substring(0, pos);
            } else {
                arg = null;
            }
            if (callOnce) {
                return Script.callWithCache(text, arg, context, reuseParentConfig);
            }
            return Script.call(text, arg, context, reuseParentConfig);
        }
        if (Script.isGetSyntax(text)) {
            String left;
            String right;
            if (Script.isVariableAndSpaceAndPath(text = text.substring(4))) {
                int pos = text.indexOf(32);
                right = text.substring(pos + 1);
                left = text.substring(0, pos);
            } else {
                Pair<String, String> pair = Script.parseVariableAndPath(text);
                left = (String)pair.getLeft();
                right = (String)pair.getRight();
            }
            if (Script.isXmlPath(right) || Script.isXmlPathFunction(right)) {
                return Script.evalXmlPathOnVarByName(left, right, context);
            }
            return Script.evalJsonPathOnVarByName(left, right, context);
        }
        if (Script.isJsonPath(text)) {
            return Script.evalJsonPathOnVarByName("response", text, context);
        }
        if (Script.isJson(text)) {
            DocumentContext doc = JsonUtils.toJsonDoc(text);
            Script.evalJsonEmbeddedExpressions(doc, context);
            return new ScriptValue(doc);
        }
        if (Script.isXml(text)) {
            Document doc = XmlUtils.toXmlDoc(text);
            Script.evalXmlEmbeddedExpressions(doc, context);
            return new ScriptValue(doc);
        }
        if (Script.isXmlPath(text)) {
            return Script.evalXmlPathOnVarByName("response", text, context);
        }
        if (Script.isStringExpression(text)) {
            return Script.evalInNashorn(text, context);
        }
        if (Script.isVariableAndJsonPath(text)) {
            Pair<String, String> pair = Script.parseVariableAndPath(text);
            return Script.evalJsonPathOnVarByName((String)pair.getLeft(), (String)pair.getRight(), context);
        }
        if (Script.isVariableAndXmlPath(text)) {
            Pair<String, String> pair = Script.parseVariableAndPath(text);
            return Script.evalXmlPathOnVarByName((String)pair.getLeft(), (String)pair.getRight(), context);
        }
        return Script.evalInNashorn(text, context);
    }

    public static ScriptValue evalXmlPathOnVarByName(String name, String path, ScriptContext context) {
        ScriptValue value = (ScriptValue)context.vars.get(name);
        if (value == null) {
            context.logger.warn("no var found with name: {}", (Object)name);
            return ScriptValue.NULL;
        }
        switch (value.getType()) {
            case XML: {
                Node doc = value.getValue(Node.class);
                return Script.evalXmlPathOnXmlNode(doc, path);
            }
        }
        Document node = XmlUtils.fromMap(value.getAsMap());
        return Script.evalXmlPathOnXmlNode(node, path);
    }

    public static ScriptValue evalXmlPathOnXmlNode(Node doc, String path) {
        NodeList nodeList;
        try {
            nodeList = XmlUtils.getNodeListByPath(doc, path);
        }
        catch (Exception e) {
            String strValue = XmlUtils.getTextValueByPath(doc, path);
            return new ScriptValue(strValue);
        }
        int count = nodeList.getLength();
        if (count == 0) {
            return ScriptValue.NULL;
        }
        if (count == 1) {
            return Script.nodeToValue(nodeList.item(0));
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < count; ++i) {
            ScriptValue sv = Script.nodeToValue(nodeList.item(i));
            list.add(sv.getValue());
        }
        return new ScriptValue(list);
    }

    private static ScriptValue nodeToValue(Node node) {
        int childElementCount = XmlUtils.getChildElementCount(node);
        if (childElementCount == 0) {
            return new ScriptValue(node.getTextContent());
        }
        if (node.getNodeType() == 9) {
            return new ScriptValue(node);
        }
        return new ScriptValue(XmlUtils.toNewDocument(node));
    }

    public static ScriptValue evalJsonPathOnVarByName(String name, String exp, ScriptContext context) {
        ScriptValue value = (ScriptValue)context.vars.get(name);
        if (value == null) {
            context.logger.warn("no var found with name: {}", (Object)name);
            return ScriptValue.NULL;
        }
        switch (value.getType()) {
            case JSON: {
                DocumentContext jsonDoc = value.getValue(DocumentContext.class);
                return new ScriptValue(jsonDoc.read(exp, new Predicate[0]));
            }
            case MAP: {
                Map map = value.getValue(Map.class);
                DocumentContext mapDoc = JsonPath.parse((Object)map);
                return new ScriptValue(mapDoc.read(exp, new Predicate[0]));
            }
            case LIST: {
                List list = value.getValue(List.class);
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return new ScriptValue(listDoc.read(exp, new Predicate[0]));
            }
            case XML: {
                Document xml = value.getValue(Document.class);
                DocumentContext xmlDoc = XmlUtils.toJsonDoc(xml);
                return new ScriptValue(xmlDoc.read(exp, new Predicate[0]));
            }
            case STRING: {
                String str = value.getValue(String.class);
                DocumentContext strDoc = JsonPath.parse((String)str);
                return new ScriptValue(strDoc.read(exp, new Predicate[0]));
            }
        }
        throw new RuntimeException("cannot run jsonpath on type: " + value);
    }

    public static ScriptValue evalInNashorn(String exp, ScriptContext context) {
        return Script.evalInNashorn(exp, context, null, null);
    }

    public static ScriptValue evalInNashorn(String exp, ScriptContext context, ScriptValue selfValue, ScriptValue parentValue) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine nashorn = manager.getEngineByName("nashorn");
        Bindings bindings = nashorn.getBindings(100);
        if (context != null) {
            Map<String, Object> map = context.getVariableBindings();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                bindings.put(entry.getKey(), entry.getValue());
            }
            bindings.put("karate", (Object)new ScriptBridge(context));
        }
        if (selfValue != null) {
            bindings.put(VAR_SELF, selfValue.getValue());
        }
        if (parentValue != null) {
            bindings.put(VAR_DOLLAR, parentValue.getAfterConvertingFromJsonOrXmlIfNeeded());
        }
        try {
            Object o = nashorn.eval(exp);
            ScriptValue result = new ScriptValue(o);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("javascript evaluation failed: " + exp, e);
        }
    }

    public static ScriptValueMap clone(ScriptValueMap vars) {
        ScriptValueMap temp = new ScriptValueMap();
        for (Map.Entry entry : vars.entrySet()) {
            String key = (String)entry.getKey();
            ScriptValue value = (ScriptValue)entry.getValue();
            temp.put(key, value);
        }
        return temp;
    }

    public static Map<String, Object> simplify(ScriptValueMap vars) {
        HashMap<String, Object> map = new HashMap<String, Object>(vars.size() + 1);
        for (Map.Entry entry : vars.entrySet()) {
            String key = (String)entry.getKey();
            ScriptValue sv = (ScriptValue)entry.getValue();
            if (sv == null) {
                sv = ScriptValue.NULL;
            }
            map.put(key, sv.getAfterConvertingFromJsonOrXmlIfNeeded());
        }
        return map;
    }

    public static boolean isValidVariableName(String name) {
        return VARIABLE_PATTERN.matcher(name).matches();
    }

    public static void evalJsonEmbeddedExpressions(DocumentContext doc, ScriptContext context) {
        Object o = doc.read(VAR_DOLLAR, new Predicate[0]);
        Script.evalJsonEmbeddedExpressions(VAR_DOLLAR, o, context, doc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void evalJsonEmbeddedExpressions(String path, Object o, ScriptContext context, DocumentContext root) {
        if (o == null) {
            return;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                String childPath = JsonUtils.buildPath(path, (String)entry.getKey());
                Script.evalJsonEmbeddedExpressions(childPath, entry.getValue(), context, root);
            }
            return;
        } else if (o instanceof List) {
            List list = (List)o;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object child = list.get(i);
                String childPath = path + "[" + i + "]";
                Script.evalJsonEmbeddedExpressions(childPath, child, context, root);
            }
            return;
        } else {
            if (!(o instanceof String)) return;
            String value = (String)o;
            if (!Script.isEmbeddedExpression(value = StringUtils.trim((String)value))) return;
            boolean optional = Script.isOptionalMacro(value);
            try {
                ScriptValue sv = Script.evalInNashorn(value.substring(optional ? 2 : 1), context);
                if (!optional) {
                    root.set(path, sv.getValue(), new Predicate[0]);
                    return;
                }
                if (!sv.isNull()) return;
                root.delete(path, new Predicate[0]);
                return;
            }
            catch (Exception e) {
                context.logger.warn("embedded json script eval failed at path {}: {}", (Object)path, (Object)e.getMessage());
            }
        }
    }

    public static void evalXmlEmbeddedExpressions(Node node, ScriptContext context) {
        if (node.getNodeType() == 9) {
            node = node.getFirstChild();
        }
        NamedNodeMap attribs = node.getAttributes();
        int attribCount = attribs.getLength();
        HashSet<Attr> attributesToRemove = new HashSet<Attr>(attribCount);
        for (int i = 0; i < attribCount; ++i) {
            Attr attrib = (Attr)attribs.item(i);
            String value = attrib.getValue();
            if (!Script.isEmbeddedExpression(value = StringUtils.trimToEmpty((String)value))) continue;
            boolean optional = Script.isOptionalMacro(value);
            try {
                ScriptValue sv = Script.evalInNashorn(value.substring(optional ? 2 : 1), context);
                if (!optional) {
                    attrib.setValue(sv.getAsString());
                    continue;
                }
                if (!sv.isNull()) continue;
                attributesToRemove.add(attrib);
                continue;
            }
            catch (Exception e) {
                context.logger.warn("embedded xml-attribute script eval failed: {}", (Object)e.getMessage());
            }
        }
        for (Attr toRemove : attributesToRemove) {
            attribs.removeNamedItem(toRemove.getName());
        }
        NodeList nodes = node.getChildNodes();
        int childCount = nodes.getLength();
        HashSet<Node> elementsToRemove = new HashSet<Node>(childCount);
        for (int i = 0; i < childCount; ++i) {
            Node child = nodes.item(i);
            if (child == null) continue;
            String value = child.getNodeValue();
            if (value != null) {
                if (!Script.isEmbeddedExpression(value = StringUtils.trimToEmpty((String)value))) continue;
                boolean optional = Script.isOptionalMacro(value);
                try {
                    ScriptValue sv = Script.evalInNashorn(value.substring(optional ? 2 : 1), context);
                    if (!optional) {
                        if (sv.isMapLike()) {
                            Node evalNode = sv.getType() == ScriptValue.Type.XML ? sv.getValue(Node.class) : XmlUtils.fromMap(sv.getAsMap());
                            if (evalNode.getNodeType() == 9) {
                                evalNode = evalNode.getFirstChild();
                            }
                            evalNode = node.getOwnerDocument().importNode(evalNode, true);
                            child.getParentNode().replaceChild(evalNode, child);
                            continue;
                        }
                        child.setNodeValue(sv.getAsString());
                        continue;
                    }
                    if (!sv.isNull()) continue;
                    elementsToRemove.add(child);
                }
                catch (Exception e) {
                    context.logger.warn("embedded xml-text script eval failed: {}", (Object)e.getMessage());
                }
                continue;
            }
            if (!child.hasChildNodes()) continue;
            Script.evalXmlEmbeddedExpressions(child, context);
        }
        for (Node toRemove : elementsToRemove) {
            Node element = toRemove.getParentNode();
            element.getParentNode().removeChild(element);
        }
    }

    public static void assign(String name, String exp, ScriptContext context) {
        Script.assign(AssignType.AUTO, name, exp, context);
    }

    public static void assignText(String name, String exp, ScriptContext context) {
        Script.assign(AssignType.TEXT, name, exp, context);
    }

    public static void assignYaml(String name, String exp, ScriptContext context) {
        Script.assign(AssignType.YAML, name, exp, context);
    }

    public static void assignString(String name, String exp, ScriptContext context) {
        Script.assign(AssignType.STRING, name, exp, context);
    }

    public static void assignJson(String name, String exp, ScriptContext context) {
        Script.assign(AssignType.JSON, name, exp, context);
    }

    public static void assignXml(String name, String exp, ScriptContext context) {
        Script.assign(AssignType.XML, name, exp, context);
    }

    public static void assignXmlString(String name, String exp, ScriptContext context) {
        Script.assign(AssignType.XML_STRING, name, exp, context);
    }

    private static void assign(AssignType assignType, String name, String exp, ScriptContext context) {
        ScriptValue sv;
        if (!Script.isValidVariableName(name = StringUtils.trim((String)name))) {
            throw new RuntimeException("invalid variable name: " + name);
        }
        if ("karate".equals(name)) {
            throw new RuntimeException("'karate' is a reserved name");
        }
        if ("request".equals(name) || "url".equals(name)) {
            throw new RuntimeException("'" + name + "' is not a variable, use the form '* " + name + " " + exp + "' instead");
        }
        switch (assignType) {
            case TEXT: {
                exp = exp.replace("\n", "\\n");
                if (!Script.isQuoted(exp)) {
                    exp = "'" + exp + "'";
                }
                sv = Script.evalInNashorn(exp, context);
                break;
            }
            case YAML: {
                DocumentContext doc = JsonUtils.fromYaml(exp);
                Script.evalJsonEmbeddedExpressions(doc, context);
                sv = new ScriptValue(doc);
                break;
            }
            case STRING: {
                ScriptValue tempString = Script.eval(exp, context);
                sv = new ScriptValue(tempString.getAsString());
                break;
            }
            case JSON: {
                DocumentContext jsonDoc = Script.toJsonDoc(Script.eval(exp, context), context);
                sv = new ScriptValue(jsonDoc);
                break;
            }
            case XML: {
                Document xmlDoc = Script.toXmlDoc(Script.eval(exp, context), context);
                sv = new ScriptValue(xmlDoc);
                break;
            }
            case XML_STRING: {
                Document xmlStringDoc = Script.toXmlDoc(Script.eval(exp, context), context);
                sv = new ScriptValue(XmlUtils.toString(xmlStringDoc));
                break;
            }
            default: {
                sv = Script.eval(exp, context);
            }
        }
        context.vars.put(name, sv);
    }

    public static DocumentContext toJsonDoc(ScriptValue sv, ScriptContext context) {
        if (sv.isListLike()) {
            return JsonPath.parse((Object)sv.getAsList());
        }
        if (sv.isMapLike()) {
            return JsonPath.parse(sv.getAsMap());
        }
        if (sv.isUnknownType()) {
            return JsonUtils.toJsonDoc(sv.getValue());
        }
        if (sv.isString() || sv.isStream()) {
            ScriptValue temp = Script.eval(sv.getAsString(), context);
            if (temp.getType() != ScriptValue.Type.JSON) {
                throw new RuntimeException("cannot convert, not a json string: " + sv);
            }
            return temp.getValue(DocumentContext.class);
        }
        throw new RuntimeException("cannot convert to json: " + sv);
    }

    private static Document toXmlDoc(ScriptValue sv, ScriptContext context) {
        if (sv.isMapLike()) {
            return XmlUtils.fromMap(sv.getAsMap());
        }
        if (sv.isUnknownType()) {
            return XmlUtils.toXmlDoc(sv.getValue());
        }
        if (sv.isString() || sv.isStream()) {
            ScriptValue temp = Script.eval(sv.getAsString(), context);
            if (temp.getType() != ScriptValue.Type.XML) {
                throw new RuntimeException("cannot convert, not an xml string: " + sv);
            }
            return temp.getValue(Document.class);
        }
        throw new RuntimeException("cannot convert to xml: " + sv);
    }

    public static boolean isQuoted(String exp) {
        return exp.startsWith("'") || exp.startsWith("\"");
    }

    public static AssertionResult matchNamed(String name, String path, String expected, ScriptContext context) {
        return Script.matchNamed(MatchType.EQUALS, name, path, expected, context);
    }

    public static AssertionResult matchNamed(MatchType matchType, String name, String path, String expected, ScriptContext context) {
        if (Script.isJsonPath(name = StringUtils.trim((String)name)) || Script.isXmlPath(name)) {
            path = name;
            name = "response";
        }
        if ((path = StringUtils.trimToNull((String)path)) == null) {
            Pair<String, String> pair = Script.parseVariableAndPath(name);
            name = (String)pair.getLeft();
            path = (String)pair.getRight();
        }
        expected = StringUtils.trim((String)expected);
        if ("header".equals(name)) {
            return Script.matchNamed(matchType, "responseHeaders", "$['" + path + "'][0]", expected, context);
        }
        ScriptValue actual = (ScriptValue)context.vars.get(name);
        if (actual == null) {
            throw new RuntimeException("variable not initialized: " + name);
        }
        switch (actual.getType()) {
            case STRING: 
            case INPUT_STREAM: {
                return Script.matchString(matchType, actual, expected, path, context);
            }
            case XML: {
                if (!VAR_DOLLAR.equals(path)) break;
                path = "/";
            }
        }
        if (Script.isJsonPath(path)) {
            return Script.matchJsonPath(matchType, actual, path, expected, context);
        }
        if (actual.getType() != ScriptValue.Type.XML) {
            Document node = XmlUtils.fromMap(actual.getAsMap());
            actual = new ScriptValue(node);
        }
        return Script.matchXmlPath(matchType, actual, path, expected, context);
    }

    public static AssertionResult matchString(MatchType matchType, ScriptValue actual, String expected, String path, ScriptContext context) {
        ScriptValue expectedValue = Script.eval(expected, context);
        expected = expectedValue.getAsString();
        return Script.matchStringOrPattern('*', path, matchType, null, actual, expected, context);
    }

    public static boolean isMacro(String text) {
        return text.startsWith("#");
    }

    public static boolean isOptionalMacro(String text) {
        return text.startsWith("##");
    }

    private static String stripParentheses(String s) {
        return StringUtils.trimToEmpty((String)s.substring(1, s.length() - 1));
    }

    public static AssertionResult matchStringOrPattern(char delimiter, String path, MatchType stringMatchType, Object actRoot, ScriptValue actValue, String expected, ScriptContext context) {
        if (expected == null) {
            if (!actValue.isNull()) {
                return Script.matchFailed(path, actValue.getValue(), expected, "actual value is not null");
            }
        } else if (Script.isMacro(expected)) {
            String macroExpression;
            if (Script.isOptionalMacro(expected)) {
                if (actValue.isNull()) {
                    return AssertionResult.PASS;
                }
                macroExpression = expected.substring(2);
            } else {
                macroExpression = expected.substring(1);
            }
            if (Script.isWithinParantheses(macroExpression)) {
                MatchType matchType = MatchType.EQUALS;
                if (Script.isContainsMacro(macroExpression = Script.stripParentheses(macroExpression))) {
                    matchType = MatchType.CONTAINS;
                    macroExpression = macroExpression.substring(1);
                } else if (Script.isNotContainsMacro(macroExpression)) {
                    matchType = MatchType.NOT_CONTAINS;
                    macroExpression = macroExpression.substring(2);
                }
                ScriptValue parentValue = Script.getValueOfParentNode(actRoot, path);
                ScriptValue expValue = Script.evalInNashorn(macroExpression, context, actValue, parentValue);
                return Script.matchNestedObject(delimiter, path, matchType, actRoot, actValue.getValue(), expValue.getValue(), context);
            }
            if (macroExpression.startsWith("regex")) {
                String regex = macroExpression.substring(5).trim();
                RegexValidator v = new RegexValidator(regex);
                ValidationResult vr = v.validate(actValue);
                if (!vr.isPass()) {
                    return Script.matchFailed(path, actValue.getValue(), expected, vr.getMessage());
                }
            } else if (macroExpression.startsWith("[") && macroExpression.indexOf(93) > 0) {
                ValidationResult vr = ArrayValidator.INSTANCE.validate(actValue);
                if (!vr.isPass()) {
                    return Script.matchFailed(path, actValue.getValue(), expected, vr.getMessage());
                }
                int endBracketPos = macroExpression.indexOf(93);
                List actValueList = actValue.getAsList();
                if (endBracketPos > 1) {
                    int arrayLength = actValueList.size();
                    String bracketContents = macroExpression.substring(1, endBracketPos);
                    ScriptValue parentValue = Script.getValueOfParentNode(actRoot, path);
                    String expression = bracketContents.indexOf(95) != -1 ? bracketContents : bracketContents + " == " + arrayLength;
                    ScriptValue result = Script.evalInNashorn(expression, context, new ScriptValue(arrayLength), parentValue);
                    if (!result.isBooleanTrue()) {
                        return Script.matchFailed(path, actValue.getValue(), expected, "array length expression did not evaluate to 'true'");
                    }
                }
                if (macroExpression.length() > endBracketPos + 1) {
                    String expression = macroExpression.substring(endBracketPos + 1);
                    expression = StringUtils.trimToNull((String)expression);
                    MatchType matchType = MatchType.EACH_EQUALS;
                    if (expression != null) {
                        if (expression.startsWith("?")) {
                            expression = "'#" + expression + "'";
                        } else if (expression.startsWith("#")) {
                            expression = "'" + expression + "'";
                        } else {
                            if (Script.isWithinParantheses(expression)) {
                                expression = Script.stripParentheses(expression);
                            }
                            if (Script.isContainsMacro(expression)) {
                                matchType = MatchType.EACH_CONTAINS;
                                expression = expression.substring(1);
                            } else if (Script.isNotContainsMacro(expression)) {
                                matchType = MatchType.EACH_NOT_CONTAINS;
                                expression = expression.substring(2);
                            }
                        }
                        return Script.matchJsonPath(matchType, new ScriptValue(actRoot), path, expression, context);
                    }
                }
            } else {
                ScriptValue parentValue;
                ScriptValue result;
                int questionPos = macroExpression.indexOf(63);
                String validatorName = null;
                validatorName = questionPos != -1 ? macroExpression.substring(0, questionPos) : macroExpression;
                if ((validatorName = StringUtils.trimToNull((String)validatorName)) != null) {
                    Validator v = context.validators.get(validatorName);
                    if (v == null) {
                        return Script.matchFailed(path, actValue.getValue(), expected, "unknown validator");
                    }
                    ValidationResult vr = v.validate(actValue);
                    if (!vr.isPass()) {
                        return Script.matchFailed(path, actValue.getValue(), expected, vr.getMessage());
                    }
                }
                if (questionPos != -1 && !(result = Script.evalInNashorn(macroExpression = macroExpression.substring(questionPos + 1), context, actValue, parentValue = Script.getValueOfParentNode(actRoot, path))).isBooleanTrue()) {
                    return Script.matchFailed(path, actValue.getValue(), expected, "did not evaluate to 'true'");
                }
            }
        } else {
            String actual = actValue.getAsString();
            switch (stringMatchType) {
                case CONTAINS: {
                    if (actual.contains(expected)) break;
                    return Script.matchFailed(path, actual, expected, "not a sub-string");
                }
                case EQUALS: {
                    if (expected.equals(actual)) break;
                    return Script.matchFailed(path, actual, expected, "not equal");
                }
                default: {
                    throw new RuntimeException("unsupported match type for string: " + (Object)((Object)stringMatchType));
                }
            }
        }
        return AssertionResult.PASS;
    }

    private static ScriptValue getValueOfParentNode(Object actRoot, String path) {
        if (actRoot instanceof DocumentContext) {
            Pair<String, String> parentAndLeaf = JsonUtils.getParentAndLeafPath(path);
            DocumentContext actDoc = (DocumentContext)actRoot;
            Object thisObject = "".equals(parentAndLeaf.getLeft()) ? actDoc : actDoc.read((String)parentAndLeaf.getLeft(), new Predicate[0]);
            return new ScriptValue(thisObject);
        }
        return null;
    }

    public static AssertionResult matchXmlPath(MatchType matchType, ScriptValue actual, String path, String expression, ScriptContext context) {
        Object actObject;
        Object expObject;
        Node node = actual.getValue(Node.class);
        actual = Script.evalXmlPathOnXmlNode(node, path);
        ScriptValue expected = Script.eval(expression, context);
        switch (expected.getType()) {
            case XML: {
                Node expNode = expected.getValue(Node.class);
                expObject = XmlUtils.toObject(expNode);
                actObject = XmlUtils.toObject(actual.getValue(Node.class));
                break;
            }
            case MAP: {
                expObject = expected.getValue(Map.class);
                actObject = XmlUtils.toObject(actual.getValue(Node.class));
                break;
            }
            case JSON: {
                expObject = expected.getValue(DocumentContext.class).read(VAR_DOLLAR, new Predicate[0]);
                actObject = actual.getValue(List.class);
                break;
            }
            case LIST: {
                expObject = expected.getValue(List.class);
                actObject = actual.getValue(List.class);
                break;
            }
            default: {
                actObject = actual.getAsString();
                expObject = expected.getAsString();
            }
        }
        if ("/".equals(path)) {
            path = "";
        }
        return Script.matchNestedObject('/', path, matchType, node, actObject, expObject, context);
    }

    private static MatchType getInnerMatchType(MatchType outerMatchType) {
        switch (outerMatchType) {
            case EACH_CONTAINS: {
                return MatchType.CONTAINS;
            }
            case EACH_NOT_CONTAINS: {
                return MatchType.NOT_CONTAINS;
            }
            case EACH_CONTAINS_ONLY: {
                return MatchType.CONTAINS_ONLY;
            }
            case EACH_EQUALS: {
                return MatchType.EQUALS;
            }
        }
        throw new RuntimeException("unexpected outer match type: " + (Object)((Object)outerMatchType));
    }

    public static AssertionResult matchJsonPath(MatchType matchType, ScriptValue actual, String path, String expression, ScriptContext context) {
        List<Object> expObject;
        DocumentContext actualDoc;
        switch (actual.getType()) {
            case JSON: {
                actualDoc = actual.getValue(DocumentContext.class);
                break;
            }
            case JS_ARRAY: {
                ScriptObjectMirror som = actual.getValue(ScriptObjectMirror.class);
                actualDoc = JsonPath.parse((Object)som.values());
                break;
            }
            case MAP: 
            case JS_OBJECT: {
                Map map = actual.getValue(Map.class);
                actualDoc = JsonPath.parse((Object)map);
                break;
            }
            case LIST: {
                List list = actual.getValue(List.class);
                actualDoc = JsonPath.parse((Object)list);
                break;
            }
            case XML: {
                actualDoc = XmlUtils.toJsonDoc(actual.getValue(Node.class));
                break;
            }
            case STRING: {
                String actualString = actual.getValue(String.class);
                ScriptValue expectedString = Script.eval(expression, context);
                if (!expectedString.isString()) {
                    return Script.matchFailed(path, actualString, expectedString.getValue(), "type of actual value is 'string' but that of expected is " + (Object)((Object)expectedString.getType()));
                }
                return Script.matchStringOrPattern('.', path, matchType, null, actual, expectedString.getValue(String.class), context);
            }
            case PRIMITIVE: {
                return Script.matchPrimitive(path, actual.getValue(), Script.eval(expression, context).getValue());
            }
            case NULL: {
                ScriptValue expectedNull = Script.eval(expression, context);
                if (expectedNull.isNull()) {
                    return AssertionResult.PASS;
                }
                if (!expectedNull.isString()) {
                    return Script.matchFailed(path, null, expectedNull.getValue(), "actual value is null but expected is " + expectedNull);
                }
                return Script.matchStringOrPattern('.', path, matchType, null, actual, expectedNull.getValue(String.class), context);
            }
            default: {
                throw new RuntimeException("not json, cannot do json path for value: " + actual + ", path: " + path);
            }
        }
        Object actObject = actualDoc.read(path, new Predicate[0]);
        ScriptValue expected = Script.eval(expression, context);
        switch (expected.getType()) {
            case JSON: {
                expObject = expected.getValue(DocumentContext.class).read(VAR_DOLLAR, new Predicate[0]);
                break;
            }
            case JS_ARRAY: {
                ScriptObjectMirror som = expected.getValue(ScriptObjectMirror.class);
                expObject = new ArrayList(som.values());
                break;
            }
            default: {
                expObject = expected.getValue();
            }
        }
        switch (matchType) {
            case CONTAINS: 
            case NOT_CONTAINS: 
            case CONTAINS_ONLY: {
                if (actObject instanceof List && !(expObject instanceof List)) {
                    expObject = Collections.singletonList(expObject);
                }
            }
            case EQUALS: {
                return Script.matchNestedObject('.', path, matchType, actualDoc, actObject, expObject, context);
            }
            case EACH_CONTAINS: 
            case EACH_NOT_CONTAINS: 
            case EACH_CONTAINS_ONLY: 
            case EACH_EQUALS: {
                if (actObject instanceof List) {
                    List actList = (List)actObject;
                    MatchType listMatchType = Script.getInnerMatchType(matchType);
                    int actSize = actList.size();
                    for (int i = 0; i < actSize; ++i) {
                        Object actListObject = actList.get(i);
                        String listPath = path + "[" + i + "]";
                        AssertionResult ar = Script.matchNestedObject('.', listPath, listMatchType, actualDoc, actListObject, expObject, context);
                        if (ar.pass) continue;
                        return ar;
                    }
                    return AssertionResult.PASS;
                }
                throw new RuntimeException("'match each' failed, not a json array: + " + actual + ", path: " + path);
            }
        }
        throw new RuntimeException("unexpected match type: " + (Object)((Object)matchType));
    }

    private static String getLeafNameFromXmlPath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos == -1) {
            return path;
        }
        if ((pos = (path = path.substring(pos + 1)).indexOf(91)) != -1) {
            return path.substring(0, pos);
        }
        return path;
    }

    private static Object toXmlString(String elementName, Object o) {
        if (o instanceof Map) {
            Document node = XmlUtils.fromObject(elementName, o);
            return XmlUtils.toString(node);
        }
        return o;
    }

    public static AssertionResult matchFailed(String path, Object actObject, Object expObject, String reason) {
        if (path.startsWith("/")) {
            String leafName = Script.getLeafNameFromXmlPath(path);
            actObject = Script.toXmlString(leafName, actObject);
            expObject = Script.toXmlString(leafName, expObject);
            path = path.replace("/@/", "/@");
        }
        String message = String.format("path: %s, actual: %s, expected: %s, reason: %s", path, actObject, expObject, reason);
        return AssertionResult.fail(message);
    }

    public static AssertionResult matchNestedObject(char delimiter, String path, MatchType matchType, Object actRoot, Object actObject, Object expObject, ScriptContext context) {
        if (expObject == null) {
            if (actObject != null) {
                return Script.matchFailed(path, actObject, expObject, "actual value is not null");
            }
            return AssertionResult.PASS;
        }
        if (expObject instanceof String) {
            ScriptValue actValue = new ScriptValue(actObject);
            return Script.matchStringOrPattern(delimiter, path, matchType, actRoot, actValue, expObject.toString(), context);
        }
        if (actObject == null) {
            return Script.matchFailed(path, actObject, expObject, "actual value is null");
        }
        if (expObject instanceof Map) {
            if (!(actObject instanceof Map)) {
                return Script.matchFailed(path, actObject, expObject, "actual value is not of type 'map'");
            }
            Map expMap = (Map)expObject;
            Map actMap = (Map)actObject;
            if ((matchType == MatchType.EQUALS || matchType == MatchType.CONTAINS_ONLY) && actMap.size() > expMap.size()) {
                int sizeDiff = actMap.size() - expMap.size();
                LinkedHashMap diffMap = new LinkedHashMap(actMap);
                for (String key : expMap.keySet()) {
                    diffMap.remove(key);
                }
                return Script.matchFailed(path, actObject, expObject, "actual value has " + sizeDiff + " more key(s) than expected: " + diffMap);
            }
            for (Map.Entry expEntry : expMap.entrySet()) {
                String key = (String)expEntry.getKey();
                String childPath = delimiter == '.' ? JsonUtils.buildPath(path, key) : path + delimiter + key;
                Object childAct = actMap.get(key);
                Object childExp = expEntry.getValue();
                AssertionResult ar = Script.matchNestedObject(delimiter, childPath, MatchType.EQUALS, actRoot, childAct, childExp, context);
                if (ar.pass && matchType == MatchType.NOT_CONTAINS) {
                    return Script.matchFailed(childPath, childAct, childExp, "actual value contains expected");
                }
                if (ar.pass || matchType == MatchType.NOT_CONTAINS) continue;
                return ar;
            }
            return AssertionResult.PASS;
        }
        if (expObject instanceof List) {
            List expList = (List)expObject;
            List actList = (List)actObject;
            int actCount = actList.size();
            int expCount = expList.size();
            if ((matchType == MatchType.EQUALS || matchType == MatchType.CONTAINS_ONLY) && actCount != expCount) {
                return Script.matchFailed(path, actObject, expObject, "actual and expected arrays are not the same size - " + actCount + ":" + expCount);
            }
            if (matchType == MatchType.CONTAINS || matchType == MatchType.CONTAINS_ONLY || matchType == MatchType.NOT_CONTAINS) {
                for (Object expListObject : expList) {
                    boolean found = false;
                    for (int i = 0; i < actCount; ++i) {
                        Object actListObject = actList.get(i);
                        String listPath = Script.buildListPath(delimiter, path, i);
                        AssertionResult ar = Script.matchNestedObject(delimiter, listPath, MatchType.EQUALS, actRoot, actListObject, expListObject, context);
                        if (!ar.pass) continue;
                        found = true;
                        break;
                    }
                    if (found && matchType == MatchType.NOT_CONTAINS) {
                        return Script.matchFailed(path + "[*]", actObject, expListObject, "actual value contains expected");
                    }
                    if (found || matchType == MatchType.NOT_CONTAINS) continue;
                    return Script.matchFailed(path + "[*]", actObject, expListObject, "actual value does not contain expected");
                }
                return AssertionResult.PASS;
            }
            for (int i = 0; i < expCount; ++i) {
                Object expListObject = expList.get(i);
                Object actListObject = actList.get(i);
                String listPath = Script.buildListPath(delimiter, path, i);
                AssertionResult ar = Script.matchNestedObject(delimiter, listPath, MatchType.EQUALS, actRoot, actListObject, expListObject, context);
                if (ar.pass) continue;
                return Script.matchFailed(listPath, actListObject, expListObject, "[" + ar.message + "]");
            }
            return AssertionResult.PASS;
        }
        if (ClassUtils.isPrimitiveOrWrapper(expObject.getClass())) {
            return Script.matchPrimitive(path, actObject, expObject);
        }
        if (expObject instanceof BigDecimal) {
            BigDecimal expNumber = (BigDecimal)expObject;
            if (actObject instanceof BigDecimal) {
                BigDecimal actNumber = (BigDecimal)actObject;
                if (actNumber.compareTo(expNumber) != 0) {
                    return Script.matchFailed(path, actObject, expObject, "not equal (big decimal)");
                }
            } else {
                BigDecimal actNumber = Script.convertToBigDecimal(actObject);
                if (actNumber == null || actNumber.compareTo(expNumber) != 0) {
                    return Script.matchFailed(path, actObject, expObject, "not equal (primitive : big decimal)");
                }
            }
            return AssertionResult.PASS;
        }
        throw new RuntimeException("unexpected type: " + expObject.getClass());
    }

    private static String buildListPath(char delimiter, String path, int index) {
        int listIndex = delimiter == '/' ? index + 1 : index;
        return path + "[" + listIndex + "]";
    }

    private static BigDecimal convertToBigDecimal(Object o) {
        DecimalFormat df = new DecimalFormat();
        df.setParseBigDecimal(true);
        try {
            return (BigDecimal)df.parse(o.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static AssertionResult matchPrimitive(String path, Object actObject, Object expObject) {
        if (actObject == null) {
            return Script.matchFailed(path, actObject, expObject, "actual value is null");
        }
        if (!expObject.getClass().equals(actObject.getClass())) {
            if (actObject instanceof BigDecimal) {
                BigDecimal actNumber = (BigDecimal)actObject;
                BigDecimal expNumber = Script.convertToBigDecimal(expObject);
                if (expNumber == null || expNumber.compareTo(actNumber) != 0) {
                    return Script.matchFailed(path, actObject, expObject, "not equal (big decimal : primitive)");
                }
                return AssertionResult.PASS;
            }
            String exp = actObject + " == " + expObject;
            ScriptValue sv = Script.evalInNashorn(exp, null);
            if (sv.isBooleanTrue()) {
                return AssertionResult.PASS;
            }
            return Script.matchFailed(path, actObject, expObject, "not equal");
        }
        if (!expObject.equals(actObject)) {
            return Script.matchFailed(path, actObject, expObject, "not equal");
        }
        return AssertionResult.PASS;
    }

    public static void removeValueByPath(String name, String path, ScriptContext context) {
        Script.setValueByPath(name, path, null, true, context);
    }

    public static void setValueByPath(String name, String path, String exp, ScriptContext context) {
        Script.setValueByPath(name, path, exp, false, context);
    }

    public static void setValueByPath(String name, String path, String exp, boolean delete, ScriptContext context) {
        ScriptValue value;
        name = StringUtils.trim((String)name);
        if ((path = StringUtils.trimToNull((String)path)) == null) {
            Pair<String, String> nameAndPath = Script.parseVariableAndPath(name);
            name = (String)nameAndPath.getLeft();
            path = (String)nameAndPath.getRight();
        }
        if ("request".equals(name) || "url".equals(name)) {
            throw new RuntimeException("'" + name + "' is not a variable, use the form '* " + name + " <expression>' to initialize the " + name + ", and <expression> can be a variable");
        }
        ScriptValue scriptValue = value = delete ? ScriptValue.NULL : Script.eval(exp, context);
        if (Script.isJsonPath(path)) {
            ScriptValue target = (ScriptValue)context.vars.get(name);
            switch (target.getType()) {
                case JSON: {
                    DocumentContext dc = target.getValue(DocumentContext.class);
                    JsonUtils.setValueByPath(dc, path, value.getAfterConvertingFromJsonOrXmlIfNeeded(), delete);
                    break;
                }
                case MAP: {
                    Map map = target.getValue(Map.class);
                    DocumentContext fromMap = JsonPath.parse((Object)map);
                    JsonUtils.setValueByPath(fromMap, path, value.getAfterConvertingFromJsonOrXmlIfNeeded(), delete);
                    context.vars.put(name, fromMap);
                    break;
                }
                default: {
                    throw new RuntimeException("cannot set json path on unexpected type: " + target);
                }
            }
        } else if (Script.isXmlPath(path)) {
            Document doc = context.vars.get(name, Document.class);
            if (delete) {
                XmlUtils.removeByPath(doc, path);
            } else if (value.getType() == ScriptValue.Type.XML) {
                Node node = value.getValue(Node.class);
                XmlUtils.setByPath(doc, path, node);
            } else if (value.isMapLike()) {
                Document node = XmlUtils.fromMap(value.getAsMap());
                XmlUtils.setByPath(doc, path, node);
            } else {
                XmlUtils.setByPath((Node)doc, path, value.getAsString());
            }
        } else {
            throw new RuntimeException("unexpected path: " + path);
        }
    }

    public static ScriptValue call(String name, String argString, ScriptContext context, boolean reuseParentConfig) {
        ScriptValue argValue = Script.eval(argString, context);
        ScriptValue sv = Script.eval(name, context);
        switch (sv.getType()) {
            case JS_FUNCTION: {
                switch (argValue.getType()) {
                    case JSON: {
                        argValue = new ScriptValue(argValue.getValue(DocumentContext.class).read(VAR_DOLLAR, new Predicate[0]));
                    }
                    case MAP: 
                    case LIST: 
                    case STRING: 
                    case JS_ARRAY: 
                    case JS_OBJECT: 
                    case PRIMITIVE: 
                    case NULL: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("only json or primitives allowed as (single) function call argument");
                    }
                }
                ScriptObjectMirror som = sv.getValue(ScriptObjectMirror.class);
                return Script.evalFunctionCall(som, argValue.getValue(), context);
            }
            case FEATURE_WRAPPER: {
                Object callArg = null;
                switch (argValue.getType()) {
                    case LIST: {
                        callArg = argValue.getValue(List.class);
                        break;
                    }
                    case JSON: {
                        callArg = argValue.getValue(DocumentContext.class).read(VAR_DOLLAR, new Predicate[0]);
                        break;
                    }
                    case MAP: {
                        callArg = argValue.getValue(Map.class);
                        break;
                    }
                    case JS_OBJECT: {
                        callArg = argValue.getValue(ScriptObjectMirror.class);
                        break;
                    }
                    case JS_ARRAY: {
                        ScriptObjectMirror temp = argValue.getValue(ScriptObjectMirror.class);
                        callArg = temp.values();
                        break;
                    }
                    case NULL: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("only json, list/array or map allowed as feature call argument");
                    }
                }
                FeatureWrapper feature = sv.getValue(FeatureWrapper.class);
                return Script.evalFeatureCall(feature, callArg, context, reuseParentConfig);
            }
        }
        context.logger.warn("not a js function or feature file: {} - {}", (Object)name, (Object)sv);
        return ScriptValue.NULL;
    }

    public static ScriptValue evalFunctionCall(ScriptObjectMirror som, Object callArg, ScriptContext context) {
        som.setMember("karate", (Object)new ScriptBridge(context));
        som.eval(String.format("var %s = this.%s", "karate", "karate"));
        try {
            Object result = callArg != null ? som.call((Object)som, new Object[]{callArg}) : som.call((Object)som, new Object[0]);
            return new ScriptValue(result);
        }
        catch (Exception e) {
            String message = "javascript function call failed, arg: " + callArg + "\n" + som;
            context.logger.error(message, (Throwable)e);
            throw new KarateException(message, e);
        }
    }

    public static ScriptValue evalFeatureCall(FeatureWrapper feature, Object callArg, ScriptContext context, boolean reuseParentConfig) {
        if (callArg instanceof Collection) {
            Collection items = (Collection)callArg;
            Object[] array = items.toArray();
            ArrayList<Object> result = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                Object rowArg = array[i];
                if (rowArg instanceof Map) {
                    try {
                        ScriptValue rowResult = Script.evalFeatureCall(feature, context, (Map)rowArg, reuseParentConfig);
                        result.add(rowResult.getValue());
                        continue;
                    }
                    catch (KarateException ke) {
                        String message = "loop feature call failed: " + feature.getPath() + ", caller: " + feature.getEnv().featureName + ", index: " + i + ", arg: " + rowArg + ", items: " + items;
                        throw new KarateException(message, ke);
                    }
                }
                throw new RuntimeException("argument not json or map for feature call loop array position: " + i + ", " + rowArg);
            }
            return new ScriptValue(result);
        }
        if (callArg == null || callArg instanceof Map) {
            try {
                return Script.evalFeatureCall(feature, context, (Map)callArg, reuseParentConfig);
            }
            catch (KarateException ke) {
                String message = "feature call failed: " + feature.getPath() + ", caller: " + feature.getEnv().featureName + ", arg: " + callArg;
                context.logger.error(message, (Throwable)ke);
                throw new KarateException(message, ke);
            }
        }
        throw new RuntimeException("unexpected feature call arg type: " + callArg.getClass());
    }

    private static ScriptValue evalFeatureCall(FeatureWrapper feature, ScriptContext context, Map<String, Object> callArg, boolean reuseParentConfig) {
        ScriptValueMap svm = CucumberUtils.call(feature, context, callArg, reuseParentConfig);
        Map<String, Object> map = Script.simplify(svm);
        return new ScriptValue(map);
    }

    public static void callAndUpdateConfigAndAlsoVarsIfMapReturned(boolean callOnce, String name, String arg, ScriptContext context) {
        Map result;
        ScriptValue sv = callOnce ? Script.callWithCache(name, arg, context, true) : Script.call(name, arg, context, true);
        switch (sv.getType()) {
            case MAP: 
            case JS_OBJECT: {
                result = sv.getValue(Map.class);
                break;
            }
            default: {
                context.logger.trace("no vars returned from function call result: {}", (Object)sv);
                return;
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            context.vars.put((String)entry.getKey(), entry.getValue());
        }
    }

    public static Map<String, Validator> getDefaultValidators() {
        HashMap<String, Validator> map = new HashMap<String, Validator>();
        map.put("ignore", IgnoreValidator.INSTANCE);
        map.put("null", NullValidator.INSTANCE);
        map.put("notnull", NotNullValidator.INSTANCE);
        map.put("uuid", UuidValidator.INSTANCE);
        map.put("string", StringValidator.INSTANCE);
        map.put("number", NumberValidator.INSTANCE);
        map.put("boolean", BooleanValidator.INSTANCE);
        map.put("array", ArrayValidator.INSTANCE);
        map.put("object", ObjectValidator.INSTANCE);
        return map;
    }

    public static AssertionResult assertBoolean(String expression, ScriptContext context) {
        ScriptValue result = Script.evalInNashorn(expression, context);
        if (!result.isBooleanTrue()) {
            return AssertionResult.fail("assert evaluated to false: " + expression);
        }
        return AssertionResult.PASS;
    }

    public static String replacePlaceholderText(String text, String token, String replaceWith, ScriptContext context) {
        if (text == null) {
            return null;
        }
        if ((replaceWith = StringUtils.trimToNull((String)replaceWith)) == null) {
            return text;
        }
        try {
            ScriptValue sv = Script.eval(replaceWith, context);
            replaceWith = sv.getAsString();
        }
        catch (Exception e) {
            throw new RuntimeException("expression error (replace string values need to be within quotes): " + e.getMessage());
        }
        token = StringUtils.trimToNull((String)token);
        if (token == null) {
            return text;
        }
        char firstChar = token.charAt(0);
        if (Character.isLetterOrDigit(firstChar)) {
            token = '<' + token + '>';
        }
        return text.replace(token, replaceWith);
    }

    public static String replacePlaceholders(String text, List<Map<String, String>> list, ScriptContext context) {
        if (text == null) {
            return null;
        }
        if (list == null) {
            return text;
        }
        for (Map<String, String> map : list) {
            String token = map.get(TOKEN);
            if (token == null) continue;
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            keys.remove(TOKEN);
            Iterator iterator = keys.iterator();
            if (!iterator.hasNext()) continue;
            String key = (String)keys.iterator().next();
            String value = map.get(key);
            text = Script.replacePlaceholderText(text, token, value, context);
        }
        return text;
    }

    public static List<Map<String, Object>> evaluateExpressions(List<Map<String, Object>> list, ScriptContext context) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(list.size());
        for (Map<String, Object> map : list) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(map);
            for (Map.Entry entry : row.entrySet()) {
                Object o = entry.getValue();
                if (!(o instanceof String)) continue;
                ScriptValue sv = Script.eval((String)o, context);
                entry.setValue(sv.getAsString());
            }
            result.add(row);
        }
        return result;
    }
}

