/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.AssertionResult;
import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.MatchType;
import com.intuit.karate.Script;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptEnv;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.MultiPartItem;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import cucumber.api.DataTable;
import cucumber.api.java.en.When;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class StepDefs {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepDefs.class);
    private final ScriptContext context;
    private HttpRequest request;
    private HttpResponse response;

    public StepDefs() {
        this(StepDefs.getFeatureEnv(), null, null, false);
    }

    private static ScriptEnv getFeatureEnv() {
        String cwd = new File("").getAbsoluteFile().getPath();
        String javaCommand = System.getProperty("sun.java.command");
        String featurePath = FileUtils.getFeaturePath(javaCommand, cwd);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (featurePath == null) {
            File file = new File("");
            LOGGER.warn("unable to derive feature file path, using: {}", (Object)file.getAbsolutePath());
            return ScriptEnv.init(file, null, classLoader);
        }
        File file = new File(featurePath);
        LOGGER.info("ide running: {}", (Object)file);
        return ScriptEnv.init(file.getParentFile(), file.getName(), classLoader);
    }

    public StepDefs(ScriptEnv env, ScriptContext parentContext, Map<String, Object> callArg, boolean reuseParentConfig) {
        if (reuseParentConfig) {
            this.context = parentContext;
            if (callArg != null) {
                for (Map.Entry<String, Object> entry : callArg.entrySet()) {
                    this.context.vars.put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            this.context = new ScriptContext(env, parentContext, callArg);
        }
        this.request = new HttpRequest();
    }

    public ScriptContext getContext() {
        return this.context;
    }

    @When(value="^configure ([^\\s]+) =$")
    public void configureDocString(String key, String exp) {
        this.configure(key, exp);
    }

    @When(value="^configure ([^\\s]+) = (.+)")
    public void configure(String key, String exp) {
        this.context.configure(key, exp);
    }

    @When(value="^url (.+)")
    public void url(String expression) {
        String temp = Script.eval(expression, this.context).getAsString();
        this.request.setUrl(temp);
    }

    @When(value="^path (.+)")
    public void path(List<String> paths) {
        for (String path : paths) {
            ScriptValue temp = Script.eval(path, this.context);
            if (temp.isListLike()) {
                List list = temp.getAsList();
                for (Object o : list) {
                    if (o == null) continue;
                    this.request.addPath(o.toString());
                }
                continue;
            }
            this.request.addPath(temp.getAsString());
        }
    }

    private List<String> evalList(List<String> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        try {
            for (String value : values) {
                ScriptValue temp = Script.eval(value, this.context);
                list.add(temp.getAsString());
            }
        }
        catch (Exception e) {
            String joined = StringUtils.join(values, (char)',');
            ScriptValue temp = Script.eval(joined, this.context);
            if (temp.isListLike()) {
                return temp.getAsList();
            }
            return Collections.singletonList(temp.getAsString());
        }
        return list;
    }

    @When(value="^param ([^\\s]+) = (.+)")
    public void param(String name, List<String> values) {
        List<String> list = this.evalList(values);
        this.request.setParam(name, list);
    }

    public Map<String, Object> evalMapExpr(String expr) {
        ScriptValue value = Script.eval(expr, this.context);
        if (!value.isMapLike()) {
            throw new KarateException("cannot convert to map: " + expr);
        }
        return value.getAsMap();
    }

    @When(value="^params (.+)")
    public void params(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeParam(key);
                continue;
            }
            if (temp instanceof List) {
                List list = (List)temp;
                String csv = StringUtils.join((Iterable)list, (char)',');
                this.request.setParam(key, csv);
                continue;
            }
            this.request.setParam(key, temp.toString());
        }
    }

    @When(value="^cookie ([^\\s]+) = (.+)")
    public void cookie(String name, String value) {
        String temp = Script.eval(value, this.context).getAsString();
        this.request.setCookie(new Cookie(name, temp));
    }

    @When(value="^cookies (.+)")
    public void cookies(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeCookie(key);
                continue;
            }
            this.request.setCookie(new Cookie(key, temp.toString()));
        }
    }

    @When(value="^header ([^\\s]+) = (.+)")
    public void header(String name, List<String> values) {
        List<String> list = this.evalList(values);
        this.request.setHeader(name, list);
    }

    @When(value="^headers (.+)")
    public void headers(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeHeader(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setHeader(key, (List)temp);
                continue;
            }
            this.request.setHeader(key, temp.toString());
        }
    }

    @When(value="^form field ([^\\s]+) = (.+)")
    public void formField(String name, List<String> values) {
        List<String> list = this.evalList(values);
        this.request.setFormField(name, list);
    }

    @When(value="^form fields (.+)")
    public void formFields(String expr) {
        Map<String, Object> map = this.evalMapExpr(expr);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object temp = entry.getValue();
            if (temp == null) {
                this.request.removeFormField(key);
                continue;
            }
            if (temp instanceof List) {
                this.request.setFormField(key, (List)temp);
                continue;
            }
            this.request.setFormField(key, temp.toString());
        }
    }

    @When(value="^request$")
    public void requestDocString(String requestBody) {
        this.request(requestBody);
    }

    @When(value="^request (.+)")
    public void request(String requestBody) {
        ScriptValue temp = Script.eval(requestBody, this.context);
        this.request.setBody(temp);
    }

    @When(value="^def (.+) =$")
    public void defDocString(String name, String expression) {
        this.def(name, expression);
    }

    @When(value="^def (.+) = (.+)")
    public void def(String name, String expression) {
        Script.assign(name, expression, this.context);
    }

    @When(value="^table (.+) =$")
    public void table(String name, DataTable table) {
        List<Map<String, Object>> list = table.asMaps(String.class, Object.class);
        list = Script.evaluateExpressions(list, this.context);
        DocumentContext doc = JsonPath.parse(list);
        this.context.vars.put(name.trim(), doc);
    }

    @When(value="^replace (\\w+)$")
    public void replace(String name, DataTable table) {
        name = name.trim();
        String text = ((ScriptValue)this.context.vars.get(name)).getAsString();
        List list = table.asMaps(String.class, String.class);
        String replaced = Script.replacePlaceholders(text, list, this.context);
        this.context.vars.put(name, replaced);
    }

    @When(value="^replace (\\w+).([^\\s]+) = (.+)")
    public void replace(String name, String token, String value) {
        name = name.trim();
        String text = ((ScriptValue)this.context.vars.get(name)).getAsString();
        String replaced = Script.replacePlaceholderText(text, token, value, this.context);
        this.context.vars.put(name, replaced);
    }

    @When(value="^text (.+) =$")
    public void textDocString(String name, String expression) {
        Script.assignText(name, expression, this.context);
    }

    @When(value="^yaml (.+) =$")
    public void yamlDocString(String name, String expression) {
        Script.assignYaml(name, expression, this.context);
    }

    @When(value="^json (.+) = (.+)")
    public void castToJson(String name, String expression) {
        Script.assignJson(name, expression, this.context);
    }

    @When(value="^string (.+) = (.+)")
    public void castToString(String name, String expression) {
        Script.assignString(name, expression, this.context);
    }

    @When(value="^xml (.+) = (.+)")
    public void castToXml(String name, String expression) {
        Script.assignXml(name, expression, this.context);
    }

    @When(value="^xmlstring (.+) = (.+)")
    public void castToXmlString(String name, String expression) {
        Script.assignXmlString(name, expression, this.context);
    }

    @When(value="^assert (.+)")
    public void asssertBoolean(String expression) {
        AssertionResult ar = Script.assertBoolean(expression, this.context);
        this.handleFailure(ar);
    }

    @When(value="^method (\\w+)")
    public void method(String method) {
        this.request.setMethod(method);
        this.response = this.context.client.invoke(this.request, this.context);
        this.context.vars.put("responseStatus", (Object)this.response.getStatus());
        this.context.vars.put("responseTime", (Object)this.response.getTime());
        this.context.vars.put("responseCookies", this.response.getCookies());
        this.context.vars.put("responseHeaders", this.response.getHeaders());
        Object responseBody = this.convertResponseBody(this.response.getBody());
        if (responseBody instanceof String) {
            String responseString = (String)responseBody;
            if (Script.isJson(responseString)) {
                DocumentContext doc = JsonUtils.toJsonDoc(responseString);
                responseBody = doc;
                if (this.context.isLogPrettyResponse() && this.context.logger.isDebugEnabled()) {
                    this.context.logger.debug("response:\n{}", (Object)JsonUtils.toPrettyJsonString(doc));
                }
            } else if (Script.isXml(responseString)) {
                try {
                    Document doc = XmlUtils.toXmlDoc(responseString);
                    responseBody = doc;
                    if (this.context.isLogPrettyResponse() && this.context.logger.isDebugEnabled()) {
                        this.context.logger.debug("response:\n{}", (Object)XmlUtils.toString(doc, true));
                    }
                }
                catch (Exception e) {
                    this.context.logger.warn("xml parsing failed, response data type set to string: {}", (Object)e.getMessage());
                }
            }
        }
        this.context.vars.put("response", responseBody);
        String prevUrl = this.request.getUrl();
        this.request = new HttpRequest();
        this.request.setUrl(prevUrl);
    }

    private Object convertResponseBody(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            String rawString = new String(bytes, "utf-8");
            if (Arrays.equals(bytes, rawString.getBytes())) {
                return rawString;
            }
        }
        catch (Exception e) {
            this.context.logger.warn("response bytes to string conversion failed: {}", (Object)e.getMessage());
        }
        return new ByteArrayInputStream(bytes);
    }

    @When(value="^soap action( .+)?")
    public void soapAction(String action) {
        if ((action = Script.eval(action, this.context).getAsString()) == null) {
            action = "";
        }
        this.request.setHeader("SOAPAction", action);
        this.request.setHeader("Content-Type", "text/xml");
        this.method("post");
    }

    @When(value="^multipart entity (.+)")
    public void multiPartEntity(String value) {
        this.multiPart(null, value);
    }

    @When(value="^multipart field (.+) = (.+)")
    public void multiPartFormField(String name, String value) {
        this.multiPart(name, value);
    }

    private static String asString(Map<String, Object> map, String key) {
        Object o = map.get(key);
        return o == null ? null : o.toString();
    }

    @When(value="^multipart file (.+) = (.+)")
    public void multiPartFile(String name, String value) {
        name = name.trim();
        ScriptValue sv = Script.eval(value, this.context);
        if (!sv.isMapLike()) {
            throw new RuntimeException("mutipart file value should be json");
        }
        Map<String, Object> map = sv.getAsMap();
        String read = StepDefs.asString(map, "read");
        if (read == null) {
            throw new RuntimeException("mutipart file json should have a value for 'read'");
        }
        ScriptValue fileValue = FileUtils.readFile(read, this.context);
        MultiPartItem item = new MultiPartItem(name, fileValue);
        String filename = StepDefs.asString(map, "filename");
        if (filename == null) {
            filename = name;
        }
        item.setFilename(filename);
        String contentType = StepDefs.asString(map, "contentType");
        if (contentType != null) {
            item.setContentType(contentType);
        }
        this.request.addMultiPartItem(item);
    }

    public void multiPart(String name, String value) {
        ScriptValue sv = Script.eval(value, this.context);
        this.request.addMultiPartItem(name, sv);
    }

    @When(value="^print (.+)")
    public void print(String exp) {
        if (this.context.isPrintEnabled() && this.context.logger.isInfoEnabled()) {
            String temp = Script.evalInNashorn(exp, this.context).getAsString();
            this.context.logger.info("[print] {}", (Object)temp);
        }
    }

    @When(value="^status (\\d+)")
    public void status(int status) {
        if (status != this.response.getStatus()) {
            String rawResponse = ((ScriptValue)this.context.vars.get("response")).getAsString();
            String responseTime = ((ScriptValue)this.context.vars.get("responseTime")).getAsString();
            String message = "status code was: " + this.response.getStatus() + ", expected: " + status + ", response time: " + responseTime + ", url: " + this.response.getUri() + ", response: " + rawResponse;
            this.context.logger.error(message);
            throw new KarateException(message);
        }
    }

    private static MatchType toMatchType(String each, String not, String only, boolean contains) {
        if (each == null) {
            if (not != null) {
                return MatchType.NOT_CONTAINS;
            }
            if (only != null) {
                return MatchType.CONTAINS_ONLY;
            }
            return contains ? MatchType.CONTAINS : MatchType.EQUALS;
        }
        if (not != null) {
            return MatchType.EACH_NOT_CONTAINS;
        }
        if (only != null) {
            return MatchType.EACH_CONTAINS_ONLY;
        }
        return contains ? MatchType.EACH_CONTAINS : MatchType.EACH_EQUALS;
    }

    @When(value="^match (each )?([^\\s]+)( [^\\s]+)? (==?)$")
    public void matchEqualsDocString(String each, String name, String path, String eqSymbol, String expected) {
        this.matchEquals(each, name, path, eqSymbol, expected);
    }

    @When(value="^match (each )?([^\\s]+)( [^\\s]+)? (!)?contains( only)?$")
    public void matchContainsDocString(String each, String name, String path, String not, String only, String expected) {
        this.matchContains(each, name, path, not, only, expected);
    }

    @When(value="^match (each )?([^\\s]+)( [^\\s]+)? (==?) (.+)")
    public void matchEquals(String each, String name, String path, String eqSymbol, String expected) {
        if (!eqSymbol.equals("==")) {
            throw new RuntimeException("use '==' for match (not '=')");
        }
        MatchType mt = StepDefs.toMatchType(each, null, null, false);
        this.matchNamed(mt, name, path, expected);
    }

    @When(value="^match (each )?([^\\s]+)( [^\\s]+)? (!)?contains( only)?(.+)")
    public void matchContains(String each, String name, String path, String not, String only, String expected) {
        MatchType mt = StepDefs.toMatchType(each, not, only, true);
        this.matchNamed(mt, name, path, expected);
    }

    public void matchNamed(MatchType matchType, String name, String path, String expected) {
        AssertionResult ar = Script.matchNamed(matchType, name, path, expected, this.context);
        this.handleFailure(ar);
    }

    @When(value="^set ([^\\s]+)( .+)? =$")
    public void setByPathDocString(String name, String path, String value) {
        this.setNamedByPath(name, path, value);
    }

    @When(value="^set ([^\\s]+)( .+)? = (.+)")
    public void setByPath(String name, String path, String value) {
        this.setNamedByPath(name, path, value);
    }

    public void setNamedByPath(String name, String path, String value) {
        Script.setValueByPath(name, path, value, this.context);
    }

    @When(value="^remove ([^\\s]+)( .+)?")
    public void removeByPath(String name, String path) {
        Script.removeValueByPath(name, path, this.context);
    }

    @When(value="^call ([^\\s]+)( .*)?")
    public final void callAndUpdateConfigAndVars(String name, String arg) {
        Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(false, name, arg, this.context);
    }

    @When(value="^callonce ([^\\s]+)( .*)?")
    public final void callOnceAndUpdateConfigAndVars(String name, String arg) {
        Script.callAndUpdateConfigAndAlsoVarsIfMapReturned(true, name, arg, this.context);
    }

    private void handleFailure(AssertionResult ar) {
        if (!ar.pass) {
            this.context.logger.error("{}", (Object)ar);
            throw new KarateException(ar.message);
        }
    }
}

