/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.convert;

import com.intuit.karate.convert.PostmanRequest;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostmanCollectionReader {
    private static final Logger logger = LoggerFactory.getLogger(PostmanCollectionReader.class);

    private PostmanCollectionReader() {
    }

    public static List<PostmanRequest> parseText(String json) {
        DocumentContext doc = JsonPath.parse((String)json);
        List list = (List)doc.read("$.item", new Predicate[0]);
        ArrayList<PostmanRequest> requests = new ArrayList<PostmanRequest>(list.size());
        for (Map map : list) {
            logger.debug("map: {}", (Object)map);
            String name = (String)map.get("name");
            Map requestInfo = (Map)map.get("request");
            String url = (String)requestInfo.get("url");
            String method = (String)requestInfo.get("method");
            List headersList = (List)requestInfo.get("header");
            HashMap<String, String> headers = new HashMap<String, String>();
            for (Map header : headersList) {
                headers.put((String)header.get("key"), (String)header.get("value"));
            }
            Map bodyInfo = (Map)requestInfo.get("body");
            String body = null;
            if (bodyInfo.containsKey("raw")) {
                body = ((String)bodyInfo.get("raw")).replace(System.lineSeparator(), "");
            } else if (bodyInfo.containsKey("formdata")) {
                body = ((List)bodyInfo.get("formdata")).toString().replace(System.lineSeparator(), "");
            }
            PostmanRequest request = new PostmanRequest();
            request.setName(name);
            request.setUrl(url);
            request.setMethod(method);
            request.setHeaders(headers);
            request.setBody(body);
            requests.add(request);
        }
        return requests;
    }

    public static List<PostmanRequest> parse(String path) {
        String json;
        File file = new File(path);
        try {
            json = FileUtils.readFileToString((File)file, (String)"utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return PostmanCollectionReader.parseText(json);
    }
}

