/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.exception.KarateException;
import com.intuit.karate.http.Cookie;
import com.intuit.karate.http.HttpConfig;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpResponse;
import com.intuit.karate.http.MultiPartItem;
import com.intuit.karate.http.MultiValuedMap;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public abstract class HttpClient<T> {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String KARATE_HTTP_PROPERTIES = "karate-http.properties";
    protected HttpRequest request;

    public abstract void configure(HttpConfig var1, ScriptContext var2);

    protected abstract T getEntity(List<MultiPartItem> var1, String var2);

    protected abstract T getEntity(MultiValuedMap var1, String var2);

    protected abstract T getEntity(InputStream var1, String var2);

    protected abstract T getEntity(String var1, String var2);

    protected abstract void buildUrl(String var1);

    protected abstract void buildPath(String var1);

    protected abstract void buildParam(String var1, Object ... var2);

    protected abstract void buildHeader(String var1, Object var2, boolean var3);

    protected abstract void buildCookie(Cookie var1);

    protected abstract HttpResponse makeHttpRequest(T var1, long var2);

    protected abstract String getRequestUri();

    private T getEntityInternal(ScriptValue body, String mediaType) {
        switch (body.getType()) {
            case JSON: {
                if (mediaType == null) {
                    mediaType = APPLICATION_JSON;
                }
                DocumentContext json = body.getValue(DocumentContext.class);
                return this.getEntity(json.jsonString(), mediaType);
            }
            case MAP: {
                if (mediaType == null) {
                    mediaType = APPLICATION_JSON;
                }
                Map map = body.getValue(Map.class);
                DocumentContext mapDoc = JsonPath.parse((Object)map);
                return this.getEntity(mapDoc.jsonString(), mediaType);
            }
            case LIST: {
                if (mediaType == null) {
                    mediaType = APPLICATION_JSON;
                }
                List list = body.getValue(List.class);
                DocumentContext listDoc = JsonPath.parse((Object)list);
                return this.getEntity(listDoc.jsonString(), mediaType);
            }
            case XML: {
                Node node = body.getValue(Node.class);
                if (mediaType == null) {
                    mediaType = APPLICATION_XML;
                }
                return this.getEntity(XmlUtils.toString(node), mediaType);
            }
            case INPUT_STREAM: {
                InputStream is = body.getValue(InputStream.class);
                if (mediaType == null) {
                    mediaType = APPLICATION_OCTET_STREAM;
                }
                return this.getEntity(is, mediaType);
            }
        }
        if (mediaType == null) {
            mediaType = TEXT_PLAIN;
        }
        return this.getEntity(body.getAsString(), mediaType);
    }

    /*
     * WARNING - void declaration
     */
    private T buildRequestInternal(HttpRequest request, ScriptContext context) {
        Map<String, Object> configHeaders;
        String method = request.getMethod();
        if (method == null) {
            String msg = "'method' is required to make an http call";
            context.logger.error(msg);
            throw new RuntimeException(msg);
        }
        method = method.toUpperCase();
        request.setMethod(method);
        this.request = request;
        String url = request.getUrl();
        if (url == null) {
            String msg = "url not set, please refer to the keyword documentation for 'url'";
            context.logger.error(msg);
            throw new RuntimeException(msg);
        }
        this.buildUrl(url);
        if (request.getPaths() != null) {
            for (String string : request.getPaths()) {
                this.buildPath(string);
            }
        }
        if (request.getParams() != null) {
            for (Map.Entry entry : request.getParams().entrySet()) {
                this.buildParam((String)entry.getKey(), ((List)entry.getValue()).toArray());
            }
        }
        if (request.getHeaders() != null) {
            for (Map.Entry entry : request.getHeaders().entrySet()) {
                for (Object value : (List)entry.getValue()) {
                    this.buildHeader((String)entry.getKey(), value, false);
                }
            }
        }
        if ((configHeaders = context.getConfigHeaders().evalAsMap(context)) != null) {
            for (Map.Entry<String, Object> entry : configHeaders.entrySet()) {
                this.buildHeader(entry.getKey(), entry.getValue(), true);
            }
        }
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies().values()) {
                this.buildCookie(cookie);
            }
        }
        Map<String, Object> map = context.getConfigCookies().evalAsMap(context);
        for (Cookie cookie : Cookie.toCookies(map)) {
            this.buildCookie(cookie);
        }
        if ("POST".equals(method) || "PUT".equals(method) || "PATCH".equals(method) || "DELETE".equals(method)) {
            String string = request.getContentType();
            if (request.getMultiPartItems() != null) {
                void var7_26;
                if (string == null) {
                    String string2 = MULTIPART_FORM_DATA;
                }
                return this.getEntity(request.getMultiPartItems(), (String)var7_26);
            }
            if (request.getFormFields() != null) {
                return this.getEntity(request.getFormFields(), APPLICATION_FORM_URLENCODED);
            }
            ScriptValue body = request.getBody();
            if (body == null || body.isNull()) {
                if ("DELETE".equals(method)) {
                    return null;
                }
                String msg = "request body is required for a " + method + ", please use the 'request' keyword";
                throw new RuntimeException(msg);
            }
            if (context.isLogPrettyRequest() && context.logger.isDebugEnabled()) {
                context.logger.debug("request:\n{}", (Object)body.getAsPrettyString());
            }
            return this.getEntityInternal(body, string);
        }
        return null;
    }

    protected static long getResponseTime(long startTime) {
        long endTime = System.currentTimeMillis();
        long responseTime = endTime - startTime;
        return responseTime;
    }

    public HttpResponse invoke(HttpRequest request, ScriptContext context) {
        T body = this.buildRequestInternal(request, context);
        long startTime = System.currentTimeMillis();
        try {
            HttpResponse response = this.makeHttpRequest(body, startTime);
            context.logger.debug("response time in milliseconds: {}", (Object)response.getTime());
            context.updateConfigCookies(response.getCookies());
            return response;
        }
        catch (Exception e) {
            long responseTime = HttpClient.getResponseTime(startTime);
            String message = "http call failed after " + responseTime + " milliseconds for URL: " + this.getRequestUri();
            context.logger.error(e.getMessage() + ", " + message);
            throw new KarateException(message, e);
        }
    }

    public static HttpClient construct(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (HttpClient)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HttpClient construct(HttpConfig config, ScriptContext context) {
        if (config.getClientInstance() != null) {
            return config.getClientInstance();
        }
        try {
            String className;
            if (config != null && config.getClientClass() != null) {
                className = config.getClientClass();
            } else {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(KARATE_HTTP_PROPERTIES);
                if (is == null) {
                    String msg = "karate-http.properties not found";
                    throw new RuntimeException(msg);
                }
                Properties props = new Properties();
                props.load(is);
                className = props.getProperty("client.class");
            }
            HttpClient client = HttpClient.construct(className);
            client.configure(config, context);
            return client;
        }
        catch (Exception e) {
            String msg = "failed to construct class by name: " + e.getMessage() + ", aborting";
            throw new RuntimeException(msg);
        }
    }
}

