/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.ScriptContext;
import com.intuit.karate.ScriptEnv;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.cucumber.DummyReporter;
import com.intuit.karate.cucumber.FeatureSection;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.cucumber.KarateBackend;
import com.intuit.karate.cucumber.KarateReporter;
import com.intuit.karate.cucumber.ScenarioOutlineWrapper;
import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.cucumber.StepResult;
import com.intuit.karate.cucumber.StepWrapper;
import com.intuit.karate.exception.KarateException;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.FeatureBuilder;
import cucumber.runtime.Glue;
import cucumber.runtime.RuntimeGlue;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.I18n;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Step;
import gherkin.parser.Parser;
import java.util.ArrayList;
import java.util.Map;

public class CucumberUtils {
    private static final DummyReporter DUMMY_REPORTER = new DummyReporter();

    private CucumberUtils() {
    }

    public static KarateBackend getBackendWithGlue(ScriptEnv env, ScriptContext parentContext, Map<String, Object> callArg, boolean reuseParentConfig) {
        KarateBackend backend = new KarateBackend(env, parentContext, callArg, reuseParentConfig);
        ClassLoader defaultClassLoader = Thread.currentThread().getContextClassLoader();
        RuntimeGlue glue = new RuntimeGlue(new UndefinedStepsTracker(), new LocalizedXStreams(defaultClassLoader));
        backend.loadGlue((Glue)glue, null);
        return backend;
    }

    public static CucumberFeature parse(String text) {
        ArrayList features = new ArrayList();
        FeatureBuilder builder = new FeatureBuilder(features);
        Parser parser = new Parser((Formatter)builder);
        parser.parse(text, "", Integer.valueOf(0));
        CucumberFeature cucumberFeature = (CucumberFeature)features.get(0);
        cucumberFeature.setI18n(parser.getI18nLanguage());
        return cucumberFeature;
    }

    public static ScriptValueMap call(FeatureWrapper feature, ScriptContext parentContext, Map<String, Object> callArg, boolean reuseParentConfig) {
        ScriptEnv env = feature.getEnv();
        KarateBackend backend = CucumberUtils.getBackendWithGlue(env, parentContext, callArg, reuseParentConfig);
        for (FeatureSection section : feature.getSections()) {
            if (section.isOutline()) {
                ScenarioOutlineWrapper outline = section.getScenarioOutline();
                for (ScenarioWrapper scenario : outline.getScenarios()) {
                    CucumberUtils.call(scenario, backend);
                }
                continue;
            }
            CucumberUtils.call(section.getScenario(), backend);
        }
        return backend.getStepDefs().getContext().getVars();
    }

    public static void call(ScenarioWrapper scenario, KarateBackend backend) {
        for (StepWrapper step : scenario.getSteps()) {
            StepResult result = CucumberUtils.runStep(step, backend);
            if (result.isPass()) continue;
            throw new KarateException("failed: " + backend.getEnv(), result.getError());
        }
    }

    public static StepResult runStep(StepWrapper step, KarateBackend backend) {
        FeatureWrapper wrapper = step.getScenario().getFeature();
        CucumberFeature feature = wrapper.getFeature();
        return CucumberUtils.runStep(wrapper.getPath(), step.getStep(), backend.getEnv().reporter, feature.getI18n(), backend, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StepResult runStep(String featurePath, Step step, Reporter reporter, I18n i18n, KarateBackend backend, boolean called) {
        long duration;
        StepDefinitionMatch match;
        backend.beforeStep(featurePath, step);
        if (reporter == null) {
            reporter = DUMMY_REPORTER;
        }
        try {
            match = backend.getGlue().stepDefinitionMatch(featurePath, step, i18n);
        }
        catch (AmbiguousStepDefinitionsException e) {
            StepDefinitionMatch match2 = (StepDefinitionMatch)e.getMatches().get(0);
            Result result = new Result("failed", Long.valueOf(0L), (Throwable)e, KarateReporter.DUMMY_OBJECT);
            return CucumberUtils.afterStep(reporter, step, (Match)match2, result, e, featurePath, backend, called);
        }
        if (match == null) {
            return CucumberUtils.afterStep(reporter, step, Match.UNDEFINED, Result.UNDEFINED, new KarateException("syntax error: " + step.getName()), featurePath, backend, called);
        }
        String status = "passed";
        Throwable error = null;
        long startTime = System.nanoTime();
        try {
            match.runStep(i18n);
            duration = called ? 0L : System.nanoTime() - startTime;
        }
        catch (Throwable t) {
            long duration2;
            try {
                error = t;
                status = "failed";
                duration2 = called ? 0L : System.nanoTime() - startTime;
            }
            catch (Throwable throwable) {
                long duration3 = called ? 0L : System.nanoTime() - startTime;
                Result result = new Result(status, Long.valueOf(duration3), error, KarateReporter.DUMMY_OBJECT);
                return CucumberUtils.afterStep(reporter, step, (Match)match, result, error, featurePath, backend, called);
            }
            Result result = new Result(status, Long.valueOf(duration2), error, KarateReporter.DUMMY_OBJECT);
            return CucumberUtils.afterStep(reporter, step, (Match)match, result, error, featurePath, backend, called);
        }
        Result result = new Result(status, Long.valueOf(duration), error, KarateReporter.DUMMY_OBJECT);
        return CucumberUtils.afterStep(reporter, step, (Match)match, result, error, featurePath, backend, called);
    }

    private static StepResult afterStep(Reporter reporter, Step step, Match match, Result result, Throwable error, String feature, KarateBackend backend, boolean called) {
        boolean isKarateReporter = reporter instanceof KarateReporter;
        if (isKarateReporter) {
            if (error != null && backend.getVars() != null) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : backend.getVars().entrySet()) {
                    sb.append(((ScriptValue)entry.getValue()).toPrettyString((String)entry.getKey()));
                }
                backend.getEnv().logger.error("{}:{} - variable state:\n{}", new Object[]{feature, step.getLine(), sb});
            }
            KarateReporter karateReporter = (KarateReporter)reporter;
            karateReporter.karateStep(step);
        }
        if (!called || isKarateReporter) {
            reporter.match(match);
            reporter.result(result);
        }
        StepResult stepResult = new StepResult(step, result, error);
        backend.afterStep(feature, stepResult);
        return stepResult;
    }
}

