/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.cucumber.KarateJunitFormatter;
import com.intuit.karate.cucumber.ReporterLogAppender;
import cucumber.runtime.formatter.CucumberJSONFormatter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class KarateReporter
implements Formatter,
Reporter {
    private final KarateJunitFormatter junit;
    private final CucumberJSONFormatter json;
    private final ReporterLogAppender logAppender;
    private Exception failureReason;
    public static final Object DUMMY_OBJECT = new Object();
    private String uri;

    public void setFailureReason(Exception failureReason) {
        this.failureReason = failureReason;
    }

    public Exception getFailureReason() {
        return this.failureReason;
    }

    public static Result passed(long time) {
        return new Result("passed", Long.valueOf(time), null, DUMMY_OBJECT);
    }

    public static Result failed(long time, Throwable t) {
        return new Result("failed", null, t, DUMMY_OBJECT);
    }

    public void call(FeatureWrapper feature, int index, Map<String, Object> arg) {
        DocString docString = null;
        if (arg != null) {
            String json = JsonUtils.toPrettyJsonString(JsonUtils.toJsonDoc(arg));
            docString = new DocString("", json, Integer.valueOf(0));
        }
        String suffix = index == -1 ? " " : "[" + index + "] ";
        Step step = new Step(null, "* ", "call" + suffix + feature.getPath(), Integer.valueOf(0), null, docString);
        this.karateStep(step);
        this.match(Match.UNDEFINED);
        this.result(KarateReporter.passed(0L));
    }

    public void karateStep(Step step) {
        if (step.getDocString() == null) {
            String log = this.logAppender.collect();
            DocString docString = log.isEmpty() ? null : new DocString("", log, step.getLine());
            step = new Step(step.getComments(), step.getKeyword(), step.getName(), step.getLine(), step.getRows(), docString);
        }
        this.junit.step(step);
        this.json.step(step);
    }

    public KarateJunitFormatter getJunitFormatter() {
        return this.junit;
    }

    public KarateReporter(String featurePath, String reportPath) throws IOException {
        this.junit = new KarateJunitFormatter(featurePath, reportPath);
        String jsonReportPath = reportPath.replaceFirst("\\.xml$", ".json");
        FileWriter fileWriter = new FileWriter(jsonReportPath);
        this.json = new CucumberJSONFormatter((Appendable)fileWriter);
        this.logAppender = new ReporterLogAppender();
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        this.junit.syntaxError(state, event, legalEvents, uri, line);
        this.json.syntaxError(state, event, legalEvents, uri, line);
    }

    public void uri(String uri) {
        this.junit.uri(uri);
        this.json.uri(uri);
        this.uri = uri;
    }

    private Feature rename(Feature f) {
        String name = this.uri;
        String description = f.getName();
        String extra = StringUtils.trimToNull(f.getDescription());
        if (extra != null) {
            description = description + '\n' + extra;
        }
        return new Feature(f.getComments(), f.getTags(), f.getKeyword(), name, description, f.getLine(), f.getId());
    }

    public void feature(Feature feature) {
        this.junit.feature(feature);
        this.json.feature(this.rename(feature));
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.junit.scenarioOutline(scenarioOutline);
        this.json.scenarioOutline(scenarioOutline);
    }

    public void examples(Examples examples) {
        this.junit.examples(examples);
        this.json.examples(examples);
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.junit.startOfScenarioLifeCycle(scenario);
        this.json.startOfScenarioLifeCycle(scenario);
    }

    public void background(Background background) {
        this.junit.background(background);
        this.json.background(background);
    }

    public void scenario(Scenario scenario) {
        this.junit.scenario(scenario);
        this.json.scenario(scenario);
    }

    public void step(Step step) {
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.junit.endOfScenarioLifeCycle(scenario);
        this.json.endOfScenarioLifeCycle(scenario);
    }

    public void done() {
        this.junit.done();
        this.json.done();
    }

    public void close() {
        this.junit.close();
        this.json.close();
    }

    public void eof() {
        this.junit.eof();
        this.json.eof();
    }

    public void before(Match match, Result result) {
        this.junit.before(match, result);
        this.json.before(match, result);
    }

    public void result(Result result) {
        this.junit.result(result);
        this.json.result(result);
    }

    public void after(Match match, Result result) {
        this.junit.after(match, result);
        this.json.after(match, result);
    }

    public void match(Match match) {
        this.junit.match(match);
        this.json.match(match);
    }

    public void embedding(String mimeType, byte[] data) {
        this.junit.embedding(mimeType, data);
        this.json.embedding(mimeType, data);
    }

    public void write(String text) {
        this.junit.write(text);
        this.json.write(text);
    }
}

