/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import com.intuit.karate.FileUtils;
import org.slf4j.LoggerFactory;

public class ReporterLogAppender
extends AppenderBase<ILoggingEvent> {
    private final Logger logger;
    private final PatternLayoutEncoder encoder;
    private final String threadName;
    private StringBuilder sb = new StringBuilder();

    public ReporterLogAppender() {
        this.threadName = Thread.currentThread().getName();
        this.logger = (Logger)LoggerFactory.getLogger((String)"com.intuit.karate");
        this.setName("karate-reporter");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.setContext((Context)lc);
        this.encoder = new PatternLayoutEncoder();
        this.encoder.setPattern("%d{HH:mm:ss.SSS} %-5level - %msg%n");
        this.encoder.setContext(this.context);
        this.encoder.start();
        this.start();
        this.logger.addAppender((Appender)this);
        this.logger.setLevel(Level.DEBUG);
    }

    public String collect() {
        String temp = this.sb.toString();
        this.sb = new StringBuilder();
        return temp;
    }

    protected void append(ILoggingEvent event) {
        if (!this.threadName.equals(event.getThreadName())) {
            return;
        }
        try {
            byte[] bytes = this.encoder.encode((Object)event);
            String line = FileUtils.toString(bytes);
            this.sb.append(line);
        }
        catch (Exception e) {
            System.err.println("possible logback version conflict: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

