/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.StringUtils;
import com.intuit.karate.cucumber.ScenarioWrapper;
import gherkin.formatter.model.DocString;
import gherkin.formatter.model.Step;

public class StepWrapper {
    private final ScenarioWrapper scenario;
    private final int index;
    private final Step step;
    private final boolean background;
    private final String priorText;
    private final String text;

    public StepWrapper(ScenarioWrapper scenario, int index, String priorText, Step step, boolean background) {
        this.scenario = scenario;
        this.index = index;
        this.priorText = StringUtils.trimToNull(priorText);
        this.background = background;
        this.step = step;
        this.text = StepWrapper.getStepText(step, scenario);
    }

    private static String getStepText(Step step, ScenarioWrapper scenario) {
        StringBuilder sb = new StringBuilder();
        sb.append(step.getKeyword());
        sb.append(step.getName());
        DocString docString = step.getDocString();
        if (docString != null) {
            sb.append("\n\"\"\"\n");
            sb.append(docString.getValue());
            sb.append("\n\"\"\"");
        }
        if (step.getRows() != null) {
            String text = scenario.getFeature().joinLines(step.getLine(), step.getLineRange().getLast() + 1);
            sb.append('\n').append(text);
        }
        return sb.toString();
    }

    public boolean isHttpCall() {
        String name = this.step.getName();
        return name.startsWith("method") || name.startsWith("soap");
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isBackground() {
        return this.background;
    }

    public boolean isPriorTextPresent() {
        return this.priorText != null;
    }

    public String getPriorText() {
        return this.priorText;
    }

    public int getPriorTextLineCount() {
        if (!this.isPriorTextPresent()) {
            return 0;
        }
        String[] split = this.priorText.split("\n");
        return split.length;
    }

    public Step getStep() {
        return this.step;
    }

    public int getStartLine() {
        return this.step.getLine() - 1;
    }

    public int getEndLine() {
        return this.step.getLineRange().getLast() - 1;
    }

    public ScenarioWrapper getScenario() {
        return this.scenario;
    }

    public String getText() {
        return this.text;
    }

    public int getLineCount() {
        return this.getEndLine() - this.getStartLine() + 1;
    }
}

