/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.FileUtils;
import com.intuit.karate.convert.ConvertUtils;
import com.intuit.karate.convert.PostmanRequest;
import com.intuit.karate.ui.AppSession;
import com.intuit.karate.ui.HeaderPanel;
import java.io.File;
import java.util.List;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Font;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class App
extends Application {
    private final FileChooser fileChooser = new FileChooser();
    private File workingDir = new File(".");
    private final BorderPane rootPane = new BorderPane();

    public static Font getDefaultFont() {
        return Font.font((String)"Courier");
    }

    private File chooseFile(Stage stage, String description, String extension) {
        this.fileChooser.setTitle("Choose Feature File");
        this.fileChooser.setInitialDirectory(this.workingDir);
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(description, new String[]{extension});
        this.fileChooser.getExtensionFilters().add((Object)extFilter);
        return this.fileChooser.showOpenDialog((Window)stage);
    }

    private void initUi(File file, String envString, Stage stage) {
        AppSession session = new AppSession(file, envString);
        this.rootPane.setTop((Node)session.headerPanel);
        this.rootPane.setCenter((Node)session.featurePanel);
        this.rootPane.setRight((Node)session.varsPanel);
        this.rootPane.setBottom((Node)session.logPanel);
        this.initFileOpenAction(session.headerPanel, envString, stage);
        this.initImportOpenAction(session.headerPanel, envString, stage);
        this.workingDir = file.getParentFile();
    }

    private void initFileOpenAction(HeaderPanel header, String envString, Stage stage) {
        header.setFileOpenAction((EventHandler<ActionEvent>)((EventHandler)e -> {
            File file = this.chooseFile(stage, "*.feature files", "*.feature");
            this.initUi(file, envString, stage);
        }));
    }

    private void initImportOpenAction(HeaderPanel header, String envString, Stage stage) {
        header.setImportOpenAction((EventHandler<ActionEvent>)((EventHandler)e -> {
            File file = this.chooseFile(stage, "*.postman_collection files", "*.postman_collection");
            String json = FileUtils.toString(file);
            List<PostmanRequest> requests = ConvertUtils.readPostmanJson(json);
            String featureText = ConvertUtils.toKarateFeature(requests);
            String featurePath = FileUtils.replaceFileExtension(file.getPath(), "feature");
            File featureFile = new File(featurePath);
            FileUtils.writeToFile(featureFile, featureText);
            this.initUi(featureFile, envString, stage);
        }));
    }

    public void start(Stage stage) throws Exception {
        List params = this.getParameters().getUnnamed();
        String envString = System.getProperty("karate.env");
        if (!params.isEmpty()) {
            String fileName = (String)params.get(0);
            if (params.size() > 1) {
                envString = (String)params.get(1);
            }
            this.initUi(new File(fileName), envString, stage);
        } else {
            HeaderPanel header = new HeaderPanel();
            this.rootPane.setTop((Node)header);
            this.initFileOpenAction(header, envString, stage);
            this.initImportOpenAction(header, envString, stage);
        }
        Scene scene = new Scene((Parent)this.rootPane, 900.0, 750.0);
        stage.setScene(scene);
        stage.setTitle("Karate UI");
        stage.show();
    }

    public static void main(String[] args) {
        App.launch((String[])args);
    }

    public static void run(String featurePath, String env) {
        App.launch((String[])new String[]{featurePath, env});
    }
}

