/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.cucumber.FeatureSection;
import com.intuit.karate.cucumber.ScenarioOutlineWrapper;
import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.ui.AppAction;
import com.intuit.karate.ui.AppSession;
import com.intuit.karate.ui.ScenarioOutlinePanel;
import com.intuit.karate.ui.ScenarioPanel;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;

public class SectionPanel
extends TitledPane {
    private final VBox content;
    private final AppSession session;
    private FeatureSection section;
    private ScenarioOutlinePanel outlinePanel;
    private ScenarioPanel scenarioPanel;
    private boolean runStarted;

    public SectionPanel(AppSession session, FeatureSection section) {
        this.section = section;
        this.session = session;
        this.content = new VBox(0.0);
        this.setContent((Node)this.content);
        this.initTitleAndContent();
    }

    private void initTitleAndContent() {
        if (this.section.isOutline()) {
            ScenarioOutlineWrapper outline = this.section.getScenarioOutline();
            this.setText(outline.getScenarioOutline().getVisualName());
            this.outlinePanel = new ScenarioOutlinePanel(this.session, outline);
            this.content.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.content.getChildren().add((Object)this.outlinePanel);
        } else {
            ScenarioWrapper scenario = this.section.getScenario();
            this.setText(scenario.getScenario().getVisualName());
            this.scenarioPanel = new ScenarioPanel(this.session, scenario);
            this.content.getChildren().add((Object)this.scenarioPanel);
        }
    }

    public void action(AppAction action) {
        switch (action) {
            case REFRESH: {
                this.section = this.session.refresh(this.section);
                break;
            }
            case RUN: {
                if (this.runStarted) break;
                this.session.resetBackendAndVarsTable(null);
                this.runStarted = true;
                break;
            }
            case RESET: {
                this.runStarted = false;
            }
        }
        if (this.section.isOutline()) {
            this.outlinePanel.action(action);
        } else {
            this.scenarioPanel.action(action);
        }
    }
}

