/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.barcodes;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import java.awt.Color;
import java.awt.Image;

public abstract class Barcode1D {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 3;
    protected PdfDocument document;
    protected float x;
    protected float n;
    protected PdfFont font;
    protected float size;
    protected float baseline;
    protected float barHeight;
    protected int textAlignment;
    protected boolean generateChecksum;
    protected boolean checksumText;
    protected boolean startStopText;
    protected boolean extended;
    protected String code = "";
    protected boolean guardBars;
    protected int codeType;
    protected float inkSpreading = 0.0f;
    protected String altText;

    protected Barcode1D(PdfDocument document) {
        this.document = document;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getN() {
        return this.n;
    }

    public void setN(float n) {
        this.n = n;
    }

    public PdfFont getFont() {
        return this.font;
    }

    public void setFont(PdfFont font) {
        this.font = font;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public float getBaseline() {
        return this.baseline;
    }

    public void setBaseline(float baseline) {
        this.baseline = baseline;
    }

    public float getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(float barHeight) {
        this.barHeight = barHeight;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public boolean isGenerateChecksum() {
        return this.generateChecksum;
    }

    public void setGenerateChecksum(boolean generateChecksum) {
        this.generateChecksum = generateChecksum;
    }

    public boolean isChecksumText() {
        return this.checksumText;
    }

    public void setChecksumText(boolean checksumText) {
        this.checksumText = checksumText;
    }

    public boolean isStartStopText() {
        return this.startStopText;
    }

    public void setStartStopText(boolean startStopText) {
        this.startStopText = startStopText;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isGuardBars() {
        return this.guardBars;
    }

    public void setGuardBars(boolean guardBars) {
        this.guardBars = guardBars;
    }

    public int getCodeType() {
        return this.codeType;
    }

    public void setCodeType(int codeType) {
        this.codeType = codeType;
    }

    public abstract Rectangle getBarcodeSize();

    public abstract Rectangle placeBarcode(PdfCanvas var1, com.itextpdf.kernel.color.Color var2, com.itextpdf.kernel.color.Color var3);

    public float getInkSpreading() {
        return this.inkSpreading;
    }

    public void setInkSpreading(float inkSpreading) {
        this.inkSpreading = inkSpreading;
    }

    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public abstract Image createAwtImage(Color var1, Color var2);

    public PdfFormXObject createFormXObject(PdfDocument document) {
        return this.createFormXObject(null, null, document);
    }

    public PdfFormXObject createFormXObject(com.itextpdf.kernel.color.Color barColor, com.itextpdf.kernel.color.Color textColor, PdfDocument document) {
        PdfFormXObject xObject = new PdfFormXObject((Rectangle)null);
        Rectangle rect = this.placeBarcode(new PdfCanvas(xObject, document), barColor, textColor);
        xObject.setBBox(new PdfArray(rect));
        return xObject;
    }

    public void fitWidth(float width) {
        this.setX(this.x * width / this.getBarcodeSize().getWidth());
    }

    protected float getDescender() {
        float sizeCoef = this.size / 1000.0f;
        return (float)this.font.getFontProgram().getFontMetrics().getTypoDescender() * sizeCoef;
    }
}

