/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.impl.tags.BrTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.ImgTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import java.util.Map;

public class DivTagWorker
implements ITagWorker,
IDisplayAware {
    private Div div = new Div();
    private WaitingInlineElementsHelper inlineHelper;
    private String display;

    public DivTagWorker(IElementNode element, ProcessorContext context) {
        Map<String, String> styles = element.getStyles();
        this.inlineHelper = new WaitingInlineElementsHelper(styles == null ? null : styles.get("white-space"), styles == null ? null : styles.get("text-transform"));
        this.display = element.getStyles() != null ? element.getStyles().get("display") : null;
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.div);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        boolean processed = false;
        IPropertyContainer element = childTagWorker.getElementResult();
        if (childTagWorker instanceof BrTagWorker) {
            this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
            return true;
        }
        if (childTagWorker instanceof IDisplayAware && "inline-block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()) && childTagWorker.getElementResult() instanceof IBlockElement) {
            this.inlineHelper.add((IBlockElement)childTagWorker.getElementResult());
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer childElement : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (childElement instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)childElement);
                    continue;
                }
                if (childElement instanceof IBlockElement && "inline-block".equals(((SpanTagWorker)childTagWorker).getElementDisplay(childElement))) {
                    this.inlineHelper.add((IBlockElement)childElement);
                    continue;
                }
                if (!(childElement instanceof IElement)) continue;
                allChildrenProcessed = this.addBlockChild((IElement)childElement) && allChildrenProcessed;
            }
            processed = allChildrenProcessed;
        } else if (element instanceof IFormField) {
            if (childTagWorker instanceof IDisplayAware && "block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay())) {
                this.postProcessInlineGroup();
                this.inlineHelper.add((IFormField)element);
                this.postProcessInlineGroup();
            } else {
                this.inlineHelper.add((IFormField)element);
            }
            processed = true;
        } else if (element instanceof AreaBreak) {
            this.postProcessInlineGroup();
            this.div.add((AreaBreak)element);
            processed = true;
        } else if (childTagWorker instanceof ImgTagWorker && element instanceof IElement) {
            if ("block".equals(((ImgTagWorker)childTagWorker).getDisplay())) {
                processed = this.addBlockChild((IElement)element);
            } else if (childTagWorker.getElementResult() instanceof Image) {
                this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
                processed = true;
            }
        } else if (element instanceof IElement) {
            processed = this.addBlockChild((IElement)element);
        }
        return processed;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.div;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    private boolean addBlockChild(IElement element) {
        this.postProcessInlineGroup();
        boolean processed = false;
        if (element instanceof IBlockElement) {
            this.div.add((IBlockElement)element);
            processed = true;
        } else if (element instanceof Image) {
            this.div.add((Image)element);
            processed = true;
        }
        return processed;
    }

    private void postProcessInlineGroup() {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.div);
    }
}

