/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.CssConstants;
import com.itextpdf.html2pdf.css.resolve.CssDefaults;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.DashedBorder;
import com.itextpdf.layout.borders.DottedBorder;
import com.itextpdf.layout.borders.DoubleBorder;
import com.itextpdf.layout.borders.GrooveBorder;
import com.itextpdf.layout.borders.InsetBorder;
import com.itextpdf.layout.borders.OutsetBorder;
import com.itextpdf.layout.borders.RidgeBorder;
import com.itextpdf.layout.borders.SolidBorder;
import com.itextpdf.layout.property.UnitValue;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineApplierUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutlineApplierUtil.class);

    private OutlineApplierUtil() {
    }

    public static void applyOutlines(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        UnitValue unitValue;
        float em = CssUtils.parseAbsoluteLength(cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        Border outline = OutlineApplierUtil.getCertainBorder(cssProps.get("outline-width"), cssProps.get("outline-style"), OutlineApplierUtil.getSpecificOutlineColorOrDefaultColor(cssProps, "outline-color"), em, rem);
        if (outline != null) {
            element.setProperty(106, (Object)outline);
        }
        if (cssProps.get("outline-offset") != null && element.getProperty(106) != null && (unitValue = CssUtils.parseLengthValueToPt(cssProps.get("outline-offset"), em, rem)) != null) {
            if (unitValue.isPercentValue()) {
                LOGGER.error("outline-width in percents is not supported");
            } else if (unitValue.getValue() != 0.0f) {
                element.setProperty(107, (Object)Float.valueOf(unitValue.getValue()));
            }
        }
    }

    public static Border getCertainBorder(String outlineWidth, String outlineStyle, String outlineColor, float em, float rem) {
        UnitValue unitValue;
        if (outlineStyle == null || "none".equals(outlineStyle)) {
            return null;
        }
        if (outlineWidth == null) {
            outlineWidth = CssDefaults.getDefaultValue("outline-width");
        }
        if (CssConstants.BORDER_WIDTH_VALUES.contains(outlineWidth)) {
            if ("thin".equals(outlineWidth)) {
                outlineWidth = "1px";
            } else if ("medium".equals(outlineWidth)) {
                outlineWidth = "2px";
            } else if ("thick".equals(outlineWidth)) {
                outlineWidth = "3px";
            }
        }
        if ((unitValue = CssUtils.parseLengthValueToPt(outlineWidth, em, rem)) == null) {
            return null;
        }
        if (unitValue.isPercentValue()) {
            LOGGER.error("outline-width in percents is not supported");
            return null;
        }
        float outlineWidthValue = unitValue.getValue();
        SolidBorder outline = null;
        if (outlineWidthValue > 0.0f) {
            DeviceRgb color = (DeviceRgb)ColorConstants.BLACK;
            float opacity = 1.0f;
            if (outlineColor != null) {
                if (!"transparent".equals(outlineColor)) {
                    float[] rgbaColor = CssUtils.parseRgbaColor(outlineColor);
                    color = new DeviceRgb(rgbaColor[0], rgbaColor[1], rgbaColor[2]);
                    opacity = rgbaColor[3];
                } else {
                    opacity = 0.0f;
                }
            } else if ("groove".equals(outlineStyle) || "ridge".equals(outlineStyle) || "inset".equals(outlineStyle) || "outset".equals(outlineStyle)) {
                color = new DeviceRgb(212, 208, 200);
            }
            switch (outlineStyle) {
                case "solid": 
                case "auto": {
                    outline = new SolidBorder((Color)color, outlineWidthValue, opacity);
                    break;
                }
                case "dashed": {
                    outline = new DashedBorder((Color)color, outlineWidthValue, opacity);
                    break;
                }
                case "dotted": {
                    outline = new DottedBorder((Color)color, outlineWidthValue, opacity);
                    break;
                }
                case "double": {
                    outline = new DoubleBorder((Color)color, outlineWidthValue, opacity);
                    break;
                }
                case "groove": {
                    outline = new GrooveBorder(color, outlineWidthValue, opacity);
                    break;
                }
                case "ridge": {
                    outline = new RidgeBorder(color, outlineWidthValue, opacity);
                    break;
                }
                case "inset": {
                    outline = new InsetBorder(color, outlineWidthValue, opacity);
                    break;
                }
                case "outset": {
                    outline = new OutsetBorder(color, outlineWidthValue, opacity);
                    break;
                }
                default: {
                    outline = null;
                }
            }
        }
        return outline;
    }

    private static String getSpecificOutlineColorOrDefaultColor(Map<String, String> styles, String specificOutlineColorProperty) {
        String outlineColor = styles.get(specificOutlineColorProperty);
        if (outlineColor == null || outlineColor.equals("currentcolor")) {
            outlineColor = styles.get("color");
        } else if ("invert".equals(outlineColor)) {
            LOGGER.warn("Invert color for outline is not supported");
            outlineColor = styles.get("color");
        }
        return outlineColor;
    }
}

