/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.impl.layout.DimensionContainer;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.styledxmlparser.css.CssContextNode;

class WidthDimensionContainer
extends DimensionContainer {
    public WidthDimensionContainer(CssContextNode node, float maxWidth, IRenderer renderer, float additionalWidthFix) {
        String width = (String)node.getStyles().get("width");
        if (width != null && !width.equals("auto")) {
            this.dimension = this.parseDimension(node, width, maxWidth, additionalWidthFix);
        }
        this.minDimension = this.getMinWidth(node, maxWidth, additionalWidthFix);
        this.maxDimension = this.getMaxWidth(node, maxWidth, additionalWidthFix);
        if (!this.isAutoDimension()) {
            this.maxContentDimension = this.dimension;
            this.maxContentDimension = this.dimension;
        } else if (renderer instanceof BlockRenderer) {
            MinMaxWidth minMaxWidth = ((BlockRenderer)renderer).getMinMaxWidth();
            this.maxContentDimension = minMaxWidth.getMaxWidth();
            this.minContentDimension = minMaxWidth.getMinWidth();
        }
    }

    private float getMinWidth(CssContextNode node, float maxAvailableWidth, float additionalWidthFix) {
        String content = (String)node.getStyles().get("min-width");
        if (content == null) {
            return 0.0f;
        }
        return this.parseDimension(node, content, maxAvailableWidth, additionalWidthFix);
    }

    private float getMaxWidth(CssContextNode node, float maxAvailableWidth, float additionalWidthFix) {
        String content = (String)node.getStyles().get("max-width");
        if (content == null) {
            return Float.MAX_VALUE;
        }
        float dim = this.parseDimension(node, content, maxAvailableWidth, additionalWidthFix);
        if (dim == 0.0f) {
            return Float.MAX_VALUE;
        }
        return dim;
    }
}

