/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.AlignmentPropertyValue;
import com.itextpdf.layout.property.JustifyContent;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlexApplierUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexApplierUtil.class);

    private FlexApplierUtil() {
    }

    public static void applyFlexItemProperties(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String flexBasis;
        String flexShrink;
        element.setProperty(89, null);
        FlexApplierUtil.logWarningIfThereAreNotSupportedPropertyValues(FlexApplierUtil.createSupportedFlexItemPropertiesAndValuesMap(), cssProps);
        String flexGrow = cssProps.get("flex-grow");
        if (flexGrow != null) {
            Float flexGrowValue = CssDimensionParsingUtils.parseFloat((String)flexGrow);
            element.setProperty(132, (Object)flexGrowValue);
        }
        if ((flexShrink = cssProps.get("flex-shrink")) != null) {
            Float flexShrinkValue = CssDimensionParsingUtils.parseFloat((String)flexShrink);
            element.setProperty(133, (Object)flexShrinkValue);
        }
        if ((flexBasis = cssProps.get("flex-basis")) == null || "auto".equals(flexBasis)) {
            String flexElementWidth = cssProps.get("width");
            if (flexElementWidth != null) {
                float em = CssDimensionParsingUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
                float rem = context.getCssContext().getRootFontSize();
                UnitValue flexElementWidthAbsoluteLength = CssDimensionParsingUtils.parseLengthValueToPt((String)flexElementWidth, (float)em, (float)rem);
                element.setProperty(131, (Object)flexElementWidthAbsoluteLength);
            }
        } else if (!"content".equals(flexBasis)) {
            float em = CssDimensionParsingUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
            float rem = context.getCssContext().getRootFontSize();
            UnitValue flexBasisAbsoluteLength = CssDimensionParsingUtils.parseLengthValueToPt((String)flexBasis, (float)em, (float)rem);
            element.setProperty(131, (Object)flexBasisAbsoluteLength);
        } else {
            LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{"flex-basis", "content"}));
        }
    }

    public static void applyFlexContainerProperties(Map<String, String> cssProps, IPropertyContainer element) {
        FlexApplierUtil.logWarningIfThereAreNotSupportedPropertyValues(FlexApplierUtil.createSupportedFlexContainerPropertiesAndValuesMap(), cssProps);
        FlexApplierUtil.applyAlignItems(cssProps, element);
        FlexApplierUtil.applyJustifyContent(cssProps, element);
    }

    private static void applyAlignItems(Map<String, String> cssProps, IPropertyContainer element) {
        String alignItemsString = cssProps.get("align-items");
        if (alignItemsString != null) {
            AlignmentPropertyValue alignItems;
            switch (alignItemsString) {
                case "normal": {
                    alignItems = AlignmentPropertyValue.NORMAL;
                    break;
                }
                case "start": {
                    alignItems = AlignmentPropertyValue.START;
                    break;
                }
                case "end": {
                    alignItems = AlignmentPropertyValue.END;
                    break;
                }
                case "flex-start": {
                    alignItems = AlignmentPropertyValue.FLEX_START;
                    break;
                }
                case "flex-end": {
                    alignItems = AlignmentPropertyValue.FLEX_END;
                    break;
                }
                case "center": {
                    alignItems = AlignmentPropertyValue.CENTER;
                    break;
                }
                case "self-start": {
                    alignItems = AlignmentPropertyValue.SELF_START;
                    break;
                }
                case "self-end": {
                    alignItems = AlignmentPropertyValue.SELF_END;
                    break;
                }
                case "stretch": {
                    alignItems = AlignmentPropertyValue.STRETCH;
                    break;
                }
                default: {
                    LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{"align-items", alignItemsString}));
                    alignItems = AlignmentPropertyValue.STRETCH;
                }
            }
            element.setProperty(134, (Object)alignItems);
        }
    }

    private static void applyJustifyContent(Map<String, String> cssProps, IPropertyContainer element) {
        String justifyContentString = cssProps.get("justify-content");
        if (justifyContentString != null) {
            JustifyContent justifyContent;
            switch (justifyContentString) {
                case "normal": {
                    justifyContent = JustifyContent.NORMAL;
                    break;
                }
                case "start": {
                    justifyContent = JustifyContent.START;
                    break;
                }
                case "end": {
                    justifyContent = JustifyContent.END;
                    break;
                }
                case "flex-end": {
                    justifyContent = JustifyContent.FLEX_END;
                    break;
                }
                case "self-start": {
                    justifyContent = JustifyContent.SELF_START;
                    break;
                }
                case "self-end": {
                    justifyContent = JustifyContent.SELF_END;
                    break;
                }
                case "left": {
                    justifyContent = JustifyContent.LEFT;
                    break;
                }
                case "right": {
                    justifyContent = JustifyContent.RIGHT;
                    break;
                }
                case "center": {
                    justifyContent = JustifyContent.CENTER;
                    break;
                }
                case "stretch": {
                    justifyContent = JustifyContent.STRETCH;
                    break;
                }
                case "flex-start": {
                    justifyContent = JustifyContent.FLEX_START;
                    break;
                }
                default: {
                    LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{"justify-content", justifyContentString}));
                    justifyContent = JustifyContent.FLEX_START;
                }
            }
            element.setProperty(135, (Object)justifyContent);
        }
    }

    private static void logWarningIfThereAreNotSupportedPropertyValues(Map<String, Set<String>> supportedPairs, Map<String, String> cssProps) {
        for (Map.Entry<String, Set<String>> entry : supportedPairs.entrySet()) {
            String supportedPair = entry.getKey();
            Set<String> supportedValues = entry.getValue();
            String propertyValue = cssProps.get(supportedPair);
            if (propertyValue == null || supportedValues.contains(propertyValue)) continue;
            LOGGER.warn(MessageFormatUtil.format((String)"Flex related property {0}: {1} is not supported yet.", (Object[])new Object[]{supportedPair, propertyValue}));
        }
    }

    private static Map<String, Set<String>> createSupportedFlexItemPropertiesAndValuesMap() {
        HashMap<String, Set<String>> supportedPairs = new HashMap<String, Set<String>>();
        HashSet<String> supportedAlignSelfValues = new HashSet<String>();
        supportedAlignSelfValues.add("auto");
        supportedPairs.put("align-self", supportedAlignSelfValues);
        HashSet supportedOrderValues = new HashSet();
        supportedPairs.put("order", supportedOrderValues);
        return supportedPairs;
    }

    private static Map<String, Set<String>> createSupportedFlexContainerPropertiesAndValuesMap() {
        HashMap<String, Set<String>> supportedPairs = new HashMap<String, Set<String>>();
        HashSet<String> supportedFlexDirectionValues = new HashSet<String>();
        supportedFlexDirectionValues.add("row");
        supportedPairs.put("flex-direction", supportedFlexDirectionValues);
        HashSet<String> supportedFlexWrapValues = new HashSet<String>();
        supportedFlexWrapValues.add("nowrap");
        supportedPairs.put("flex-wrap", supportedFlexWrapValues);
        HashSet<String> supportedAlignContentValues = new HashSet<String>();
        supportedAlignContentValues.add("stretch");
        supportedAlignContentValues.add("normal");
        supportedPairs.put("align-content", supportedAlignContentValues);
        HashSet<String> supportedRowGapValues = new HashSet<String>();
        supportedRowGapValues.add("normal");
        supportedPairs.put("row-gap", supportedRowGapValues);
        HashSet<String> supportedColumnGapValues = new HashSet<String>();
        supportedColumnGapValues.add("normal");
        supportedPairs.put("column-gap", supportedColumnGapValues);
        return supportedPairs;
    }
}

