/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.FontConstants;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.OpenTypeParser;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphPositioningTableReader;
import com.itextpdf.io.font.otf.GlyphSubstitutionTableReader;
import com.itextpdf.io.font.otf.OpenTypeGdefTableReader;
import com.itextpdf.io.util.IntHashtable;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrueTypeFont
extends FontProgram {
    private static final long serialVersionUID = -2232044646577669268L;
    private OpenTypeParser fontParser;
    protected int[][] bBoxes;
    protected boolean isVertical;
    private GlyphSubstitutionTableReader gsubTable;
    private GlyphPositioningTableReader gposTable;
    private OpenTypeGdefTableReader gdefTable;
    protected IntHashtable kerning = new IntHashtable();
    private byte[] fontStreamBytes;

    protected TrueTypeFont() {
    }

    public TrueTypeFont(String path) throws java.io.IOException {
        this.checkFilePath(path);
        this.fontParser = new OpenTypeParser(path);
        this.initializeFontProperties();
    }

    public TrueTypeFont(byte[] ttf) throws java.io.IOException {
        this.fontParser = new OpenTypeParser(ttf);
        this.initializeFontProperties();
    }

    TrueTypeFont(String ttcPath, int ttcIndex) throws java.io.IOException {
        this.checkFilePath(ttcPath);
        this.fontParser = new OpenTypeParser(ttcPath, ttcIndex);
        this.initializeFontProperties();
    }

    TrueTypeFont(byte[] ttc, int ttcIndex) throws java.io.IOException {
        this.fontParser = new OpenTypeParser(ttc, ttcIndex);
        this.initializeFontProperties();
    }

    @Override
    public boolean hasKernPairs() {
        return this.kerning.size() > 0;
    }

    @Override
    public int getKerning(Glyph first, Glyph second) {
        if (first == null || second == null) {
            return 0;
        }
        return this.kerning.get((first.getCode() << 16) + second.getCode());
    }

    public boolean isCff() {
        return this.fontParser.isCff();
    }

    public Map<Integer, int[]> getActiveCmap() {
        OpenTypeParser.CmapTable cmaps = this.fontParser.getCmapTable();
        if (cmaps.cmapExt != null) {
            return cmaps.cmapExt;
        }
        if (!cmaps.fontSpecific && cmaps.cmap31 != null) {
            return cmaps.cmap31;
        }
        if (cmaps.fontSpecific && cmaps.cmap10 != null) {
            return cmaps.cmap10;
        }
        if (cmaps.cmap31 != null) {
            return cmaps.cmap31;
        }
        return cmaps.cmap10;
    }

    public byte[] getFontStreamBytes() {
        if (this.fontStreamBytes != null) {
            return this.fontStreamBytes;
        }
        try {
            this.fontStreamBytes = this.fontParser.isCff() ? this.fontParser.readCffFont() : this.fontParser.getFullFont();
        }
        catch (java.io.IOException e) {
            this.fontStreamBytes = null;
            throw new IOException("io.exception", e);
        }
        return this.fontStreamBytes;
    }

    @Override
    public int getPdfFontFlags() {
        int flags = 0;
        if (this.fontMetrics.isFixedPitch()) {
            flags |= 1;
        }
        flags |= this.isFontSpecific() ? 4 : 32;
        if (this.fontNames.isItalic()) {
            flags |= 0x40;
        }
        if (this.fontNames.isBold() || this.fontNames.getFontWeight() > 500) {
            flags |= 0x40000;
        }
        return flags;
    }

    public int getDirectoryOffset() {
        return this.fontParser.directoryOffset;
    }

    public GlyphSubstitutionTableReader getGsubTable() {
        return this.gsubTable;
    }

    public GlyphPositioningTableReader getGposTable() {
        return this.gposTable;
    }

    public byte[] getSubset(Set<Integer> glyphs, boolean subset) {
        try {
            return this.fontParser.getSubset(glyphs, subset);
        }
        catch (java.io.IOException e) {
            throw new IOException("io.exception", e);
        }
    }

    protected void readGdefTable() throws java.io.IOException {
        int[] gdef = this.fontParser.tables.get("GDEF");
        this.gdefTable = gdef != null ? new OpenTypeGdefTableReader(this.fontParser.raf, gdef[0]) : new OpenTypeGdefTableReader(this.fontParser.raf, 0);
    }

    protected void readGsubTable() throws java.io.IOException {
        int[] gsub = this.fontParser.tables.get("GSUB");
        if (gsub != null) {
            this.gsubTable = new GlyphSubstitutionTableReader(this.fontParser.raf, gsub[0], this.gdefTable, this.codeToGlyph, this.fontMetrics.getUnitsPerEm());
        }
    }

    protected void readGposTable() throws java.io.IOException {
        int[] gpos = this.fontParser.tables.get("GPOS");
        if (gpos != null) {
            this.gposTable = new GlyphPositioningTableReader(this.fontParser.raf, gpos[0], this.gdefTable, this.codeToGlyph, this.fontMetrics.getUnitsPerEm());
        }
    }

    private void initializeFontProperties() throws java.io.IOException {
        String[][] ttfUniqueId;
        OpenTypeParser.HeaderTable head = this.fontParser.getHeadTable();
        OpenTypeParser.HorizontalHeader hhea = this.fontParser.getHheaTable();
        OpenTypeParser.WindowsMetrics os_2 = this.fontParser.getOs_2Table();
        OpenTypeParser.PostTable post = this.fontParser.getPostTable();
        this.isFontSpecific = this.fontParser.getCmapTable().fontSpecific;
        this.kerning = this.fontParser.readKerning(head.unitsPerEm);
        this.bBoxes = this.fontParser.readBbox(head.unitsPerEm);
        this.fontNames.setAllNames(this.fontParser.getAllNameEntries());
        this.fontNames.setFontName(this.fontParser.getPsFontName());
        this.fontNames.setFullName(this.fontNames.getNames(4));
        String[][] otfFamilyName = this.fontNames.getNames(16);
        if (otfFamilyName != null) {
            this.fontNames.setFamilyName(otfFamilyName);
        } else {
            this.fontNames.setFamilyName(this.fontNames.getNames(1));
        }
        String[][] subfamily = this.fontNames.getNames(2);
        if (subfamily != null) {
            this.fontNames.setStyle(subfamily[0][3]);
        }
        String[][] otfSubFamily = this.fontNames.getNames(17);
        if (otfFamilyName != null) {
            this.fontNames.setSubfamily(otfSubFamily);
        } else {
            this.fontNames.setSubfamily(subfamily);
        }
        String[][] cidName = this.fontNames.getNames(20);
        if (cidName != null) {
            this.fontNames.setCidFontName(cidName[0][3]);
        }
        this.fontNames.setWeight(os_2.usWeightClass);
        this.fontNames.setWidth(os_2.usWidthClass);
        this.fontNames.setMacStyle(head.macStyle);
        this.fontNames.setAllowEmbedding(os_2.fsType != 2);
        this.fontMetrics.setUnitsPerEm(head.unitsPerEm);
        this.fontMetrics.updateBbox(head.xMin, head.yMin, head.xMax, head.yMax);
        this.fontMetrics.setMaxGlyphId(this.fontParser.readMaxGlyphId());
        this.fontMetrics.setGlyphWidths(this.fontParser.getGlyphWidthsByIndex());
        this.fontMetrics.setTypoAscender(os_2.sTypoAscender);
        this.fontMetrics.setTypoDescender(os_2.sTypoDescender);
        this.fontMetrics.setCapHeight(os_2.sCapHeight);
        this.fontMetrics.setXHeight(os_2.sxHeight);
        this.fontMetrics.setItalicAngle(post.italicAngle);
        this.fontMetrics.setAscender(hhea.Ascender);
        this.fontMetrics.setDescender(hhea.Descender);
        this.fontMetrics.setLineGap(hhea.LineGap);
        this.fontMetrics.setWinAscender(os_2.usWinAscent);
        this.fontMetrics.setWinDescender(os_2.usWinDescent);
        this.fontMetrics.setAdvanceWidthMax(hhea.advanceWidthMax);
        this.fontMetrics.setUnderlinePosition((post.underlinePosition - post.underlineThickness) / 2);
        this.fontMetrics.setUnderlineThickness(post.underlineThickness);
        this.fontMetrics.setStrikeoutPosition(os_2.yStrikeoutPosition);
        this.fontMetrics.setStrikeoutSize(os_2.yStrikeoutSize);
        this.fontMetrics.setSubscriptOffset(-os_2.ySubscriptYOffset);
        this.fontMetrics.setSubscriptSize(os_2.ySubscriptYSize);
        this.fontMetrics.setSuperscriptOffset(os_2.ySuperscriptYOffset);
        this.fontMetrics.setSuperscriptSize(os_2.ySuperscriptYSize);
        this.fontMetrics.setIsFixedPitch(post.isFixedPitch);
        String[][] ttfVersion = this.fontNames.getNames(5);
        if (ttfVersion != null) {
            this.fontIdentification.setTtfVersion(ttfVersion[0][3]);
        }
        if ((ttfUniqueId = this.fontNames.getNames(3)) != null) {
            this.fontIdentification.setTtfVersion(ttfUniqueId[0][3]);
        }
        this.fontIdentification.setPanose(os_2.panose);
        Map<Integer, int[]> cmap = this.getActiveCmap();
        int[] glyphWidths = this.fontParser.getGlyphWidthsByIndex();
        this.unicodeToGlyph = new LinkedHashMap(cmap.size());
        this.codeToGlyph = new LinkedHashMap(glyphWidths.length);
        this.avgWidth = 0;
        for (Integer charCode : cmap.keySet()) {
            int index = cmap.get(charCode)[0];
            if (index >= glyphWidths.length) {
                Logger LOGGER = LoggerFactory.getLogger(TrueTypeFont.class);
                LOGGER.warn(MessageFormat.format("Font {0} has invalid glyph: {1}", this.getFontNames().getFontName(), index));
                continue;
            }
            Glyph glyph = new Glyph(index, glyphWidths[index], charCode, this.bBoxes != null ? this.bBoxes[index] : null);
            this.unicodeToGlyph.put(charCode, glyph);
            this.codeToGlyph.put(index, glyph);
            this.avgWidth += glyph.getWidth();
        }
        this.fixSpaceIssue();
        for (int index = 0; index < glyphWidths.length; ++index) {
            if (this.codeToGlyph.containsKey(index)) continue;
            Glyph glyph = new Glyph(index, glyphWidths[index], -1);
            this.codeToGlyph.put(index, glyph);
            this.avgWidth += glyph.getWidth();
        }
        if (this.codeToGlyph.size() != 0) {
            this.avgWidth /= this.codeToGlyph.size();
        }
        this.readGdefTable();
        this.readGsubTable();
        this.readGposTable();
        this.isVertical = false;
    }

    public String[] getCodePagesSupported() {
        long cp = ((long)this.fontParser.getOs_2Table().ulCodePageRange2 << 32) + ((long)this.fontParser.getOs_2Table().ulCodePageRange1 & 0xFFFFFFFFL);
        int count = 0;
        long bit = 1L;
        for (int k = 0; k < 64; ++k) {
            if ((cp & bit) != 0L && FontConstants.CODE_PAGES[k] != null) {
                ++count;
            }
            bit <<= 1;
        }
        String[] ret = new String[count];
        count = 0;
        bit = 1L;
        for (int k = 0; k < 64; ++k) {
            if ((cp & bit) != 0L && FontConstants.CODE_PAGES[k] != null) {
                ret[count++] = FontConstants.CODE_PAGES[k];
            }
            bit <<= 1;
        }
        return ret;
    }
}

