/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFontsDir() {
        String winDir = System.getenv("windir");
        String fileSeparator = System.getProperty("file.separator");
        return winDir + fileSeparator + "fonts";
    }

    public static boolean fileExists(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists() && f.isFile();
        }
        return false;
    }

    public static boolean directoryExists(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists() && f.isDirectory();
        }
        return false;
    }

    public static String[] listFilesInDirectory(String path, boolean recursive) {
        Object[] files;
        File root;
        if (path != null && (root = new File(path)).exists() && root.isDirectory() && (files = root.listFiles()) != null) {
            Arrays.sort(files);
            ArrayList<String> list = new ArrayList<String>();
            for (Object file : files) {
                if (((File)file).isDirectory() && recursive) {
                    FileUtil.listAllFiles(((File)file).getAbsolutePath(), list);
                    continue;
                }
                list.add(((File)file).getAbsolutePath());
            }
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    public static File[] listFilesInDirectoryByFilter(String outPath, FileFilter fileFilter) {
        File[] result = null;
        if (outPath != null && !outPath.isEmpty()) {
            result = new File(outPath).listFiles(fileFilter);
        }
        if (result != null) {
            Arrays.sort(result);
        }
        return result;
    }

    private static void listAllFiles(String dir, List<String> list) {
        Object[] files = new File(dir).listFiles();
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                if (((File)file).isDirectory()) {
                    FileUtil.listAllFiles(((File)file).getAbsolutePath(), list);
                    continue;
                }
                list.add(((File)file).getAbsolutePath());
            }
        }
    }

    public static PrintWriter createPrintWriter(OutputStream output, String encoding) throws UnsupportedEncodingException {
        return new PrintWriter(new OutputStreamWriter(output, encoding));
    }

    public static OutputStream getBufferedOutputStream(String filename) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(filename));
    }

    public static OutputStream wrapWithBufferedOutputStream(OutputStream outputStream) {
        if (outputStream instanceof ByteArrayOutputStream || outputStream instanceof BufferedOutputStream) {
            return outputStream;
        }
        return new BufferedOutputStream(outputStream);
    }

    public static File createTempFile(String path) throws IOException {
        File tempFile = new File(path);
        if (tempFile.isDirectory()) {
            tempFile = File.createTempFile("pdf", null, tempFile);
        }
        return tempFile;
    }

    public static FileOutputStream getFileOutputStream(File tempFile) throws FileNotFoundException {
        return new FileOutputStream(tempFile);
    }

    public static RandomAccessFile getRandomAccessFile(File tempFile) throws FileNotFoundException {
        return new RandomAccessFile(tempFile, "rw");
    }

    public static void createDirectories(String outPath) {
        new File(outPath).mkdirs();
    }

    @Deprecated
    public static String getParentDirectory(String file) {
        return new File(file).getParent();
    }

    public static String getParentDirectory(File file) throws MalformedURLException {
        return file != null ? Paths.get(file.getParent(), new String[0]).toUri().toURL().toExternalForm() : "";
    }

    public static boolean deleteFile(File file) {
        return file.delete();
    }

    public static String parentDirectory(URL url) throws URISyntaxException {
        return url.toURI().resolve(".").toString();
    }
}

