/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.clipper;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Subpath;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.ClipperOffset;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.IClipper;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Path;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.Point;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyNode;
import com.itextpdf.kernel.pdf.canvas.parser.clipper.PolyTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ClipperBridge {
    public static double floatMultiplier = Math.pow(10.0, 14.0);

    public static com.itextpdf.kernel.geom.Path convertToPath(PolyTree result) {
        com.itextpdf.kernel.geom.Path path = new com.itextpdf.kernel.geom.Path();
        for (PolyNode node = result.getFirst(); node != null; node = node.getNext()) {
            ClipperBridge.addContour(path, node.getContour(), !node.isOpen());
        }
        return path;
    }

    public static void addPath(IClipper clipper, com.itextpdf.kernel.geom.Path path, IClipper.PolyType polyType) {
        for (Subpath subpath : path.getSubpaths()) {
            if (subpath.isSinglePointClosed() || subpath.isSinglePointOpen()) continue;
            List<Point> linearApproxPoints = subpath.getPiecewiseLinearApproximation();
            clipper.addPath(new Path((Collection<? extends Point.LongPoint>)ClipperBridge.convertToLongPoints(linearApproxPoints)), polyType, subpath.isClosed());
        }
    }

    public static List<Subpath> addPath(ClipperOffset offset, com.itextpdf.kernel.geom.Path path, IClipper.JoinType joinType, IClipper.EndType endType) {
        ArrayList<Subpath> degenerateSubpaths = new ArrayList<Subpath>();
        for (Subpath subpath : path.getSubpaths()) {
            if (subpath.isDegenerate()) {
                degenerateSubpaths.add(subpath);
                continue;
            }
            if (subpath.isSinglePointClosed() || subpath.isSinglePointOpen()) continue;
            IClipper.EndType et = subpath.isClosed() ? IClipper.EndType.CLOSED_LINE : endType;
            List<Point> linearApproxPoints = subpath.getPiecewiseLinearApproximation();
            offset.addPath(new Path((Collection<? extends Point.LongPoint>)ClipperBridge.convertToLongPoints(linearApproxPoints)), joinType, et);
        }
        return degenerateSubpaths;
    }

    public static List<Point> convertToFloatPoints(List<Point.LongPoint> points) {
        ArrayList<Point> convertedPoints = new ArrayList<Point>(points.size());
        for (Point.LongPoint point : points) {
            convertedPoints.add(new Point((double)point.getX() / floatMultiplier, (double)point.getY() / floatMultiplier));
        }
        return convertedPoints;
    }

    public static List<Point.LongPoint> convertToLongPoints(List<Point> points) {
        ArrayList<Point.LongPoint> convertedPoints = new ArrayList<Point.LongPoint>(points.size());
        for (Point point : points) {
            convertedPoints.add(new Point.LongPoint(floatMultiplier * point.getX(), floatMultiplier * point.getY()));
        }
        return convertedPoints;
    }

    public static IClipper.JoinType getJoinType(int lineJoinStyle) {
        switch (lineJoinStyle) {
            case 2: {
                return IClipper.JoinType.BEVEL;
            }
            case 0: {
                return IClipper.JoinType.MITER;
            }
        }
        return IClipper.JoinType.ROUND;
    }

    public static IClipper.EndType getEndType(int lineCapStyle) {
        switch (lineCapStyle) {
            case 0: {
                return IClipper.EndType.OPEN_BUTT;
            }
            case 2: {
                return IClipper.EndType.OPEN_SQUARE;
            }
        }
        return IClipper.EndType.OPEN_ROUND;
    }

    public static IClipper.PolyFillType getFillType(int fillingRule) {
        IClipper.PolyFillType fillType = IClipper.PolyFillType.NON_ZERO;
        if (fillingRule == 2) {
            fillType = IClipper.PolyFillType.EVEN_ODD;
        }
        return fillType;
    }

    @Deprecated
    public static void addContour(com.itextpdf.kernel.geom.Path path, List<Point.LongPoint> contour, Boolean close) {
        List<Point> floatContour = ClipperBridge.convertToFloatPoints(contour);
        Point point = floatContour.get(0);
        path.moveTo((float)point.getX(), (float)point.getY());
        for (int i = 1; i < floatContour.size(); ++i) {
            point = floatContour.get(i);
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        if (close.booleanValue()) {
            path.closeSubpath();
        }
    }

    public static void addRectToClipper(IClipper clipper, Point[] rectVertices, IClipper.PolyType polyType) {
        clipper.addPath(new Path((Collection<? extends Point.LongPoint>)ClipperBridge.convertToLongPoints(new ArrayList<Point>(Arrays.asList(rectVertices)))), polyType, true);
    }
}

