/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.font.FontUtil;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PdfFont
extends PdfObjectWrapper<PdfDictionary> {
    public static final int SIMPLE_FONT_MAX_CHAR_CODE_VALUE = 255;
    private static final long serialVersionUID = -7661159455613720321L;
    protected FontProgram fontProgram;
    protected static final byte[] EMPTY_BYTES = new byte[0];
    @Deprecated
    protected static final double[] DEFAULT_FONT_MATRIX = new double[]{0.001, 0.0, 0.0, 0.001, 0.0, 0.0};
    protected Map<Integer, Glyph> notdefGlyphs = new HashMap<Integer, Glyph>();
    protected boolean newFont = true;
    protected boolean embedded = false;
    protected boolean subset = true;
    protected List<int[]> subsetRanges;

    protected PdfFont(PdfDictionary fontDictionary) {
        super(fontDictionary);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
    }

    protected PdfFont() {
        super(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.Font);
    }

    public abstract Glyph getGlyph(int var1);

    public boolean containsGlyph(int unicode) {
        Glyph glyph = this.getGlyph(unicode);
        if (glyph != null) {
            if (this.getFontProgram() != null && this.getFontProgram().isFontSpecific()) {
                return glyph.getCode() > -1;
            }
            return glyph.getCode() > 0;
        }
        return false;
    }

    public abstract GlyphLine createGlyphLine(String var1);

    public abstract int appendGlyphs(String var1, int var2, int var3, List<Glyph> var4);

    public abstract int appendAnyGlyph(String var1, int var2, List<Glyph> var3);

    public abstract byte[] convertToBytes(String var1);

    public abstract byte[] convertToBytes(GlyphLine var1);

    public abstract String decode(PdfString var1);

    public abstract GlyphLine decodeIntoGlyphLine(PdfString var1);

    public boolean appendDecodedCodesToGlyphsList(List<Glyph> list, PdfString characterCodes) {
        return false;
    }

    public abstract float getContentWidth(PdfString var1);

    public abstract byte[] convertToBytes(Glyph var1);

    public abstract void writeText(GlyphLine var1, int var2, int var3, PdfOutputStream var4);

    public abstract void writeText(String var1, PdfOutputStream var2);

    @Deprecated
    public double[] getFontMatrix() {
        return DEFAULT_FONT_MATRIX;
    }

    public int getWidth(int unicode) {
        Glyph glyph = this.getGlyph(unicode);
        return glyph != null ? glyph.getWidth() : 0;
    }

    public float getWidth(int unicode, float fontSize) {
        return (float)this.getWidth(unicode) * fontSize / 1000.0f;
    }

    public int getWidth(String text) {
        int total = 0;
        for (int i = 0; i < text.length(); ++i) {
            int ch;
            if (TextUtil.isSurrogatePair((String)text, (int)i)) {
                ch = TextUtil.convertToUtf32((String)text, (int)i);
                ++i;
            } else {
                ch = text.charAt(i);
            }
            Glyph glyph = this.getGlyph(ch);
            if (glyph == null) continue;
            total += glyph.getWidth();
        }
        return total;
    }

    public float getWidth(String text, float fontSize) {
        return (float)this.getWidth(text) * fontSize / 1000.0f;
    }

    public int getDescent(String text, float fontSize) {
        int min = 0;
        for (int k = 0; k < text.length(); ++k) {
            int ch;
            if (TextUtil.isSurrogatePair((String)text, (int)k)) {
                ch = TextUtil.convertToUtf32((String)text, (int)k);
                ++k;
            } else {
                ch = text.charAt(k);
            }
            Glyph glyph = this.getGlyph(ch);
            if (glyph == null) continue;
            int[] bbox = glyph.getBbox();
            if (bbox != null && bbox[1] < min) {
                min = bbox[1];
                continue;
            }
            if (bbox != null || this.getFontProgram().getFontMetrics().getTypoDescender() >= min) continue;
            min = this.getFontProgram().getFontMetrics().getTypoDescender();
        }
        return (int)((float)min * fontSize / 1000.0f);
    }

    public int getDescent(int unicode, float fontSize) {
        int min = 0;
        Glyph glyph = this.getGlyph(unicode);
        if (glyph == null) {
            return 0;
        }
        int[] bbox = glyph.getBbox();
        if (bbox != null && bbox[1] < min) {
            min = bbox[1];
        } else if (bbox == null && this.getFontProgram().getFontMetrics().getTypoDescender() < min) {
            min = this.getFontProgram().getFontMetrics().getTypoDescender();
        }
        return (int)((float)min * fontSize / 1000.0f);
    }

    public int getAscent(String text, float fontSize) {
        int max = 0;
        for (int k = 0; k < text.length(); ++k) {
            int ch;
            if (TextUtil.isSurrogatePair((String)text, (int)k)) {
                ch = TextUtil.convertToUtf32((String)text, (int)k);
                ++k;
            } else {
                ch = text.charAt(k);
            }
            Glyph glyph = this.getGlyph(ch);
            if (glyph == null) continue;
            int[] bbox = glyph.getBbox();
            if (bbox != null && bbox[3] > max) {
                max = bbox[3];
                continue;
            }
            if (bbox != null || this.getFontProgram().getFontMetrics().getTypoAscender() <= max) continue;
            max = this.getFontProgram().getFontMetrics().getTypoAscender();
        }
        return (int)((float)max * fontSize / 1000.0f);
    }

    public int getAscent(int unicode, float fontSize) {
        int max = 0;
        Glyph glyph = this.getGlyph(unicode);
        if (glyph == null) {
            return 0;
        }
        int[] bbox = glyph.getBbox();
        if (bbox != null && bbox[3] > max) {
            max = bbox[3];
        } else if (bbox == null && this.getFontProgram().getFontMetrics().getTypoAscender() > max) {
            max = this.getFontProgram().getFontMetrics().getTypoAscender();
        }
        return (int)((float)max * fontSize / 1000.0f);
    }

    public FontProgram getFontProgram() {
        return this.fontProgram;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean subset) {
        this.subset = subset;
    }

    public void addSubsetRange(int[] range) {
        if (this.subsetRanges == null) {
            this.subsetRanges = new ArrayList<int[]>();
        }
        this.subsetRanges.add(range);
        this.setSubset(true);
    }

    public List<String> splitString(String text, float fontSize, float maxWidth) {
        ArrayList<String> resultString = new ArrayList<String>();
        int lastWhiteSpace = 0;
        int startPos = 0;
        float tokenLength = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            float currentCharWidth;
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                lastWhiteSpace = i;
            }
            if (tokenLength + (currentCharWidth = this.getWidth(ch, fontSize)) >= maxWidth || ch == '\n') {
                if (startPos < lastWhiteSpace) {
                    resultString.add(text.substring(startPos, lastWhiteSpace));
                    startPos = lastWhiteSpace + 1;
                    tokenLength = 0.0f;
                    i = lastWhiteSpace;
                    continue;
                }
                if (startPos != i) {
                    resultString.add(text.substring(startPos, i));
                    startPos = i;
                    tokenLength = currentCharWidth;
                    continue;
                }
                resultString.add(text.substring(startPos, startPos + 1));
                startPos = i + 1;
                tokenLength = 0.0f;
                continue;
            }
            tokenLength += currentCharWidth;
        }
        resultString.add(text.substring(startPos));
        return resultString;
    }

    public boolean isBuiltWith(String fontProgram, String encoding) {
        return false;
    }

    @Override
    public void flush() {
        super.flush();
    }

    protected abstract PdfDictionary getFontDescriptor(String var1);

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected static String updateSubsetPrefix(String fontName, boolean isSubset, boolean isEmbedded) {
        if (isSubset && isEmbedded) {
            return FontUtil.addRandomSubsetPrefixForFontName(fontName);
        }
        return fontName;
    }

    protected PdfStream getPdfFontStream(byte[] fontStreamBytes, int[] fontStreamLengths) {
        if (fontStreamBytes == null) {
            throw new PdfException("Font embedding issue.");
        }
        PdfStream fontStream = new PdfStream(fontStreamBytes);
        this.makeObjectIndirect(fontStream);
        for (int k = 0; k < fontStreamLengths.length; ++k) {
            fontStream.put(new PdfName("Length" + (k + 1)), new PdfNumber(fontStreamLengths[k]));
        }
        return fontStream;
    }

    @Deprecated
    protected static int[] compactRanges(List<int[]> ranges) {
        ArrayList<int[]> simp = new ArrayList<int[]>();
        for (int[] range : ranges) {
            for (int j = 0; j < range.length; j += 2) {
                simp.add(new int[]{Math.max(0, Math.min(range[j], range[j + 1])), Math.min(65535, Math.max(range[j], range[j + 1]))});
            }
        }
        for (int k1 = 0; k1 < simp.size() - 1; ++k1) {
            for (int k2 = k1 + 1; k2 < simp.size(); ++k2) {
                int[] r2;
                int[] r1 = (int[])simp.get(k1);
                if ((r1[0] < (r2 = (int[])simp.get(k2))[0] || r1[0] > r2[1]) && (r1[1] < r2[0] || r1[0] > r2[1])) continue;
                r1[0] = Math.min(r1[0], r2[0]);
                r1[1] = Math.max(r1[1], r2[1]);
                simp.remove(k2);
                --k2;
            }
        }
        int[] s = new int[simp.size() * 2];
        for (int k = 0; k < simp.size(); ++k) {
            int[] r = (int[])simp.get(k);
            s[k * 2] = r[0];
            s[k * 2 + 1] = r[1];
        }
        return s;
    }

    boolean makeObjectIndirect(PdfObject obj) {
        if (((PdfDictionary)this.getPdfObject()).getIndirectReference() != null) {
            obj.makeIndirect(((PdfDictionary)this.getPdfObject()).getIndirectReference().getDocument());
            return true;
        }
        PdfFont.markObjectAsIndirect(obj);
        return false;
    }

    public String toString() {
        return "PdfFont{fontProgram=" + this.fontProgram + '}';
    }
}

