/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.listener;

import com.itextpdf.kernel.geom.LineSegment;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.ITextChunkLocation;
import com.itextpdf.kernel.pdf.canvas.parser.listener.TextChunk;
import com.itextpdf.kernel.pdf.canvas.parser.listener.TextChunkLocationDefaultImp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CharacterRenderInfo
extends TextChunk {
    private Rectangle boundingBox;

    static StringConversionInfo mapString(List<CharacterRenderInfo> cris) {
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        StringBuilder sb = new StringBuilder();
        TextChunk lastChunk = null;
        for (int i = 0; i < cris.size(); ++i) {
            CharacterRenderInfo chunk = cris.get(i);
            if (lastChunk == null) {
                CharacterRenderInfo.putCharsWithIndex(chunk.getText(), i, indexMap, sb);
            } else if (chunk.sameLine(lastChunk)) {
                if (chunk.getLocation().isAtWordBoundary(lastChunk.getLocation()) && !chunk.getText().startsWith(" ") && !chunk.getText().endsWith(" ")) {
                    sb.append(' ');
                }
                CharacterRenderInfo.putCharsWithIndex(chunk.getText(), i, indexMap, sb);
            } else {
                CharacterRenderInfo.putCharsWithIndex(chunk.getText(), i, indexMap, sb);
            }
            lastChunk = chunk;
        }
        StringConversionInfo ret = new StringConversionInfo();
        ret.indexMap = indexMap;
        ret.text = sb.toString();
        return ret;
    }

    private static void putCharsWithIndex(CharSequence seq, int index, Map<Integer, Integer> indexMap, StringBuilder sb) {
        int charCount = seq.length();
        for (int i = 0; i < charCount; ++i) {
            indexMap.put(sb.length(), index);
            sb.append(seq.charAt(i));
        }
    }

    public CharacterRenderInfo(TextRenderInfo tri) {
        super(tri == null ? "" : tri.getText(), tri == null ? null : CharacterRenderInfo.getLocation(tri));
        if (tri == null) {
            throw new IllegalArgumentException("TextRenderInfo argument is not nullable.");
        }
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(tri.getDescentLine().getStartPoint().get(0), tri.getDescentLine().getStartPoint().get(1)));
        points.add(new Point(tri.getDescentLine().getEndPoint().get(0), tri.getDescentLine().getEndPoint().get(1)));
        points.add(new Point(tri.getAscentLine().getStartPoint().get(0), tri.getAscentLine().getStartPoint().get(1)));
        points.add(new Point(tri.getAscentLine().getEndPoint().get(0), tri.getAscentLine().getEndPoint().get(1)));
        this.boundingBox = Rectangle.calculateBBox(points);
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    private static ITextChunkLocation getLocation(TextRenderInfo tri) {
        LineSegment baseline = tri.getBaseline();
        return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), tri.getSingleSpaceWidth());
    }

    static class StringConversionInfo {
        Map<Integer, Integer> indexMap;
        String text;

        StringConversionInfo() {
        }
    }
}

