/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.exceptions.MemoryLimitsAwareException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import java.util.HashSet;

public class MemoryLimitsAwareHandler {
    private static final int SINGLE_SCALE_COEFFICIENT = 100;
    private static final int SUM_SCALE_COEFFICIENT = 500;
    private static final int SINGLE_DECOMPRESSED_PDF_STREAM_MIN_SIZE = 21474836;
    private static final long SUM_OF_DECOMPRESSED_PDF_STREAMW_MIN_SIZE = 0x6666666L;
    private int maxSizeOfSingleDecompressedPdfStream;
    private long maxSizeOfDecompressedPdfStreamsSum;
    private long allMemoryUsedForDecompression = 0L;
    private long memoryUsedForCurrentPdfStreamDecompression = 0L;
    boolean considerCurrentPdfStream = false;

    public MemoryLimitsAwareHandler() {
        this.maxSizeOfSingleDecompressedPdfStream = 21474836;
        this.maxSizeOfDecompressedPdfStreamsSum = 0x6666666L;
    }

    public MemoryLimitsAwareHandler(long documentSize) {
        this.maxSizeOfSingleDecompressedPdfStream = (int)MemoryLimitsAwareHandler.calculateDefaultParameter(documentSize, 100, 21474836L);
        this.maxSizeOfDecompressedPdfStreamsSum = MemoryLimitsAwareHandler.calculateDefaultParameter(documentSize, 500, 0x6666666L);
    }

    public int getMaxSizeOfSingleDecompressedPdfStream() {
        return this.maxSizeOfSingleDecompressedPdfStream;
    }

    public MemoryLimitsAwareHandler setMaxSizeOfSingleDecompressedPdfStream(int maxSizeOfSingleDecompressedPdfStream) {
        this.maxSizeOfSingleDecompressedPdfStream = maxSizeOfSingleDecompressedPdfStream;
        return this;
    }

    public long getMaxSizeOfDecompressedPdfStreamsSum() {
        return this.maxSizeOfDecompressedPdfStreamsSum;
    }

    public MemoryLimitsAwareHandler setMaxSizeOfDecompressedPdfStreamsSum(long maxSizeOfDecompressedPdfStreamsSum) {
        this.maxSizeOfDecompressedPdfStreamsSum = maxSizeOfDecompressedPdfStreamsSum;
        return this;
    }

    public boolean isMemoryLimitsAwarenessRequiredOnDecompression(PdfArray filters) {
        HashSet<PdfName> filterSet = new HashSet<PdfName>();
        for (int index = 0; index < filters.size(); ++index) {
            PdfName filterName = filters.getAsName(index);
            if (filterSet.add(filterName)) continue;
            return true;
        }
        return false;
    }

    MemoryLimitsAwareHandler considerBytesOccupiedByDecompressedPdfStream(long numOfOccupiedBytes) {
        if (this.considerCurrentPdfStream && this.memoryUsedForCurrentPdfStreamDecompression < numOfOccupiedBytes) {
            this.memoryUsedForCurrentPdfStreamDecompression = numOfOccupiedBytes;
            if (this.memoryUsedForCurrentPdfStreamDecompression > (long)this.maxSizeOfSingleDecompressedPdfStream) {
                throw new MemoryLimitsAwareException("During decompression a single stream occupied more memory than allowed. Please either check your pdf or increase the allowed multiple decompressed pdf streams maximum size value by setting the appropriate parameter of ReaderProperties's MemoryLimitsAwareHandler.");
            }
        }
        return this;
    }

    MemoryLimitsAwareHandler beginDecompressedPdfStreamProcessing() {
        this.ensureCurrentStreamIsReset();
        this.considerCurrentPdfStream = true;
        return this;
    }

    MemoryLimitsAwareHandler endDecompressedPdfStreamProcessing() {
        this.allMemoryUsedForDecompression += this.memoryUsedForCurrentPdfStreamDecompression;
        if (this.allMemoryUsedForDecompression > this.maxSizeOfDecompressedPdfStreamsSum) {
            throw new MemoryLimitsAwareException("During decompression multiple streams in sum occupied more memory than allowed. Please either check your pdf or increase the allowed single decompressed pdf stream maximum size value by setting the appropriate parameter of ReaderProperties's MemoryLimitsAwareHandler.");
        }
        this.ensureCurrentStreamIsReset();
        this.considerCurrentPdfStream = false;
        return this;
    }

    long getAllMemoryUsedForDecompression() {
        return this.allMemoryUsedForDecompression;
    }

    private static long calculateDefaultParameter(long documentSize, int scale, long min) {
        long result = documentSize * (long)scale;
        if (result < min) {
            result = min;
        }
        if (result > min * (long)scale) {
            result = min * (long)scale;
        }
        return result;
    }

    private void ensureCurrentStreamIsReset() {
        this.memoryUsedForCurrentPdfStreamDecompression = 0L;
    }
}

