/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.annot;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.InteriorColorUtil;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.da.AnnotationDefaultAppearance;

public class PdfRedactAnnotation
extends PdfMarkupAnnotation {
    public PdfRedactAnnotation(Rectangle rect) {
        super(rect);
    }

    protected PdfRedactAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    @Override
    public PdfName getSubtype() {
        return PdfName.Redact;
    }

    public PdfString getDefaultAppearance() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.DA);
    }

    public PdfRedactAnnotation setDefaultAppearance(PdfString appearanceString) {
        return (PdfRedactAnnotation)this.put(PdfName.DA, appearanceString);
    }

    public PdfRedactAnnotation setDefaultAppearance(AnnotationDefaultAppearance da) {
        return this.setDefaultAppearance(da.toPdfString());
    }

    public PdfRedactAnnotation setOverlayText(PdfString text) {
        return (PdfRedactAnnotation)this.put(PdfName.OverlayText, text);
    }

    public PdfString getOverlayText() {
        return ((PdfDictionary)this.getPdfObject()).getAsString(PdfName.OverlayText);
    }

    public PdfRedactAnnotation setRedactRolloverAppearance(PdfStream stream) {
        return (PdfRedactAnnotation)this.put(PdfName.RO, stream);
    }

    public PdfStream getRedactRolloverAppearance() {
        return ((PdfDictionary)this.getPdfObject()).getAsStream(PdfName.RO);
    }

    public PdfRedactAnnotation setRepeat(PdfBoolean repeat) {
        return (PdfRedactAnnotation)this.put(PdfName.Repeat, repeat);
    }

    public PdfBoolean getRepeat() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.Repeat);
    }

    public PdfArray getQuadPoints() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.QuadPoints);
    }

    public PdfRedactAnnotation setQuadPoints(PdfArray quadPoints) {
        return (PdfRedactAnnotation)this.put(PdfName.QuadPoints, quadPoints);
    }

    public Color getInteriorColor() {
        return InteriorColorUtil.parseInteriorColor(((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.IC));
    }

    public PdfRedactAnnotation setInteriorColor(PdfArray interiorColor) {
        return (PdfRedactAnnotation)this.put(PdfName.IC, interiorColor);
    }

    public PdfRedactAnnotation setInteriorColor(float[] interiorColor) {
        return this.setInteriorColor(new PdfArray(interiorColor));
    }

    public int getJustification() {
        PdfNumber q = ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.Q);
        return q == null ? 0 : q.intValue();
    }

    public PdfRedactAnnotation setJustification(int justification) {
        return (PdfRedactAnnotation)this.put(PdfName.Q, new PdfNumber(justification));
    }
}

