/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.parser.data;

import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;

public class AbstractRenderInfo
implements IEventData {
    protected CanvasGraphicsState gs;
    private boolean graphicsStateIsPreserved;

    public AbstractRenderInfo(CanvasGraphicsState gs) {
        this.gs = gs;
    }

    @Override
    public CanvasGraphicsState getGraphicsState() {
        this.checkGraphicsState();
        return this.graphicsStateIsPreserved ? this.gs : new CanvasGraphicsState(this.gs);
    }

    public boolean isGraphicsStatePreserved() {
        return this.graphicsStateIsPreserved;
    }

    public void preserveGraphicsState() {
        this.checkGraphicsState();
        this.graphicsStateIsPreserved = true;
        this.gs = new CanvasGraphicsState(this.gs);
    }

    public void releaseGraphicsState() {
        if (!this.graphicsStateIsPreserved) {
            this.gs = null;
        }
    }

    protected void checkGraphicsState() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
    }
}

