/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionaryEntrySet;
import com.itextpdf.kernel.pdf.PdfDictionaryValues;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.utils.ICopyFilter;
import com.itextpdf.kernel.utils.NullCopyFilter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PdfDictionary
extends PdfObject {
    private Map<PdfName, PdfObject> map = new TreeMap<PdfName, PdfObject>();

    public PdfDictionary() {
    }

    public PdfDictionary(Map<PdfName, PdfObject> map) {
        this.map.putAll(map);
    }

    public PdfDictionary(Set<Map.Entry<PdfName, PdfObject>> entrySet) {
        for (Map.Entry<PdfName, PdfObject> entry : entrySet) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public PdfDictionary(PdfDictionary dictionary) {
        this.map.putAll(dictionary.map);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    public boolean containsKey(PdfName key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(PdfObject value) {
        return this.map.values().contains(value);
    }

    public PdfObject get(PdfName key) {
        return this.get(key, true);
    }

    public PdfArray getAsArray(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 1) {
            return (PdfArray)direct;
        }
        return null;
    }

    public PdfDictionary getAsDictionary(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 3) {
            return (PdfDictionary)direct;
        }
        return null;
    }

    public PdfStream getAsStream(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 9) {
            return (PdfStream)direct;
        }
        return null;
    }

    public PdfNumber getAsNumber(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 8) {
            return (PdfNumber)direct;
        }
        return null;
    }

    public PdfName getAsName(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 6) {
            return (PdfName)direct;
        }
        return null;
    }

    public PdfString getAsString(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 10) {
            return (PdfString)direct;
        }
        return null;
    }

    public PdfBoolean getAsBoolean(PdfName key) {
        PdfObject direct = this.get(key, true);
        if (direct != null && direct.getType() == 2) {
            return (PdfBoolean)direct;
        }
        return null;
    }

    public Rectangle getAsRectangle(PdfName key) {
        PdfArray a = this.getAsArray(key);
        return a == null ? null : a.toRectangle();
    }

    public Float getAsFloat(PdfName key) {
        PdfNumber number = this.getAsNumber(key);
        Float floatNumber = null;
        if (number != null) {
            floatNumber = Float.valueOf(number.floatValue());
        }
        return floatNumber;
    }

    public Integer getAsInt(PdfName key) {
        PdfNumber number = this.getAsNumber(key);
        Integer intNumber = null;
        if (number != null) {
            intNumber = number.intValue();
        }
        return intNumber;
    }

    public Boolean getAsBool(PdfName key) {
        PdfBoolean b = this.getAsBoolean(key);
        Boolean booleanValue = null;
        if (b != null) {
            booleanValue = b.getValue();
        }
        return booleanValue;
    }

    public PdfObject put(PdfName key, PdfObject value) {
        assert (value != null);
        return this.map.put(key, value);
    }

    public PdfObject remove(PdfName key) {
        return this.map.remove(key);
    }

    public void putAll(PdfDictionary d) {
        this.map.putAll(d.map);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<PdfName> keySet() {
        return this.map.keySet();
    }

    public Collection<PdfObject> values(boolean asDirects) {
        if (asDirects) {
            return this.values();
        }
        return this.map.values();
    }

    public Collection<PdfObject> values() {
        return new PdfDictionaryValues(this.map.values());
    }

    public Set<Map.Entry<PdfName, PdfObject>> entrySet() {
        return new PdfDictionaryEntrySet(this.map.entrySet());
    }

    @Override
    public byte getType() {
        return 3;
    }

    public String toString() {
        if (!this.isFlushed()) {
            String string = "<<";
            for (Map.Entry<PdfName, PdfObject> entry : this.map.entrySet()) {
                PdfIndirectReference indirectReference = entry.getValue().getIndirectReference();
                string = string + entry.getKey().toString() + " " + (indirectReference == null ? entry.getValue().toString() : indirectReference.toString()) + " ";
            }
            string = string + ">>";
            return string;
        }
        return this.indirectReference.toString();
    }

    public PdfDictionary clone(List<PdfName> excludeKeys) {
        TreeMap<PdfName, PdfObject> excluded = new TreeMap<PdfName, PdfObject>();
        for (PdfName key : excludeKeys) {
            PdfObject obj = this.map.get(key);
            if (obj == null) continue;
            excluded.put(key, this.map.remove(key));
        }
        PdfDictionary dictionary = (PdfDictionary)this.clone();
        this.map.putAll(excluded);
        return dictionary;
    }

    public PdfDictionary copyTo(PdfDocument document, List<PdfName> excludeKeys, boolean allowDuplicating) {
        return this.copyTo(document, excludeKeys, allowDuplicating, NullCopyFilter.getInstance());
    }

    public PdfDictionary copyTo(PdfDocument document, List<PdfName> excludeKeys, boolean allowDuplicating, ICopyFilter copyFilter) {
        TreeMap<PdfName, PdfObject> excluded = new TreeMap<PdfName, PdfObject>();
        for (PdfName key : excludeKeys) {
            PdfObject obj = this.map.get(key);
            if (obj == null) continue;
            excluded.put(key, this.map.remove(key));
        }
        PdfDictionary dictionary = (PdfDictionary)this.copyTo(document, allowDuplicating, copyFilter);
        this.map.putAll(excluded);
        return dictionary;
    }

    public PdfObject get(PdfName key, boolean asDirect) {
        if (!asDirect) {
            return this.map.get(key);
        }
        PdfObject obj = this.map.get(key);
        if (obj != null && obj.getType() == 5) {
            return ((PdfIndirectReference)obj).getRefersTo(true);
        }
        return obj;
    }

    public void mergeDifferent(PdfDictionary other) {
        for (PdfName key : other.keySet()) {
            if (this.containsKey(key)) continue;
            this.put(key, other.get(key));
        }
    }

    @Override
    protected PdfObject newInstance() {
        return new PdfDictionary();
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document) {
        this.copyContent(from, document, NullCopyFilter.getInstance());
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document, ICopyFilter copyFilter) {
        super.copyContent(from, document, copyFilter);
        PdfDictionary dictionary = (PdfDictionary)from;
        for (Map.Entry<PdfName, PdfObject> entry : dictionary.map.entrySet()) {
            if (!copyFilter.shouldProcess(this, entry.getKey(), entry.getValue())) continue;
            this.map.put(entry.getKey(), entry.getValue().processCopying(document, false, copyFilter));
        }
    }

    protected void releaseContent() {
        this.map = null;
    }
}

