/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.crypto.securityhandler;

import com.itextpdf.kernel.crypto.AesGcmDecryptor;
import com.itextpdf.kernel.crypto.IDecryptor;
import com.itextpdf.kernel.crypto.OutputStreamAesGcmEncryption;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import com.itextpdf.kernel.crypto.securityhandler.StandardHandlerUsingAes256;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfVersion;
import java.io.OutputStream;

public class StandardHandlerUsingAesGcm
extends StandardHandlerUsingAes256 {
    protected byte[] noncePart = null;
    protected int inObjectNonceCounter = 0;

    public StandardHandlerUsingAesGcm(PdfDictionary encryptionDictionary, byte[] userPassword, byte[] ownerPassword, int permissions, boolean encryptMetadata, boolean embeddedFilesOnly) {
        super(encryptionDictionary, userPassword, ownerPassword, permissions, encryptMetadata, embeddedFilesOnly, PdfVersion.PDF_2_0);
    }

    public StandardHandlerUsingAesGcm(PdfDictionary encryptionDictionary, byte[] password) {
        super(encryptionDictionary, password);
    }

    @Override
    public void setHashKeyForNextObject(int objNumber, int objGeneration) {
        this.inObjectNonceCounter = 0;
        this.noncePart = new byte[]{0, 0, (byte)objGeneration, (byte)(objNumber >>> 24), (byte)(objNumber >>> 16), (byte)(objNumber >>> 8), (byte)objNumber};
    }

    @Override
    public OutputStreamEncryption getEncryptionStream(OutputStream os) {
        int ctr = this.inObjectNonceCounter;
        this.noncePart[0] = (byte)(ctr >>> 8);
        this.noncePart[1] = (byte)ctr;
        return new OutputStreamAesGcmEncryption(os, this.nextObjectKey, this.noncePart);
    }

    @Override
    public IDecryptor getDecryptor() {
        return new AesGcmDecryptor(this.nextObjectKey, 0, this.nextObjectKeySize);
    }

    @Override
    void setAES256DicEntries(PdfDictionary encryptionDictionary, byte[] oeKey, byte[] ueKey, byte[] aes256Perms, boolean encryptMetadata, boolean embeddedFilesOnly) {
        int version = 6;
        int revision = 7;
        PdfName cryptoFilter = PdfName.AESV4;
        this.setEncryptionDictionaryEntries(encryptionDictionary, oeKey, ueKey, aes256Perms, encryptMetadata, embeddedFilesOnly, version, revision, cryptoFilter);
    }

    @Override
    boolean isPdf2(PdfDictionary encryptionDictionary) {
        return true;
    }
}

