/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.geom;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.HashCode;

public class Point
implements Cloneable {
    private double x;
    private double y;

    public Point() {
        this.setLocation(0.0, 0.0);
    }

    public Point(double x, double y) {
        this.setLocation(x, y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void move(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public double distance(double px, double py) {
        return Math.sqrt(Point.distanceSq(this.getX(), this.getY(), px, py));
    }

    public double distance(Point p) {
        return this.distance(p.getX(), p.getY());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point) {
            Point p = (Point)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public String toString() {
        return MessageFormatUtil.format((String)"Point: [x={0},y={1}]", (Object[])new Object[]{this.x, this.y});
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.getX());
        hash.append(this.getY());
        return hash.hashCode();
    }

    public Object clone() {
        return new Point(this.x, this.y);
    }

    private static double distanceSq(double x1, double y1, double x2, double y2) {
        return (x2 -= x1) * x2 + (y2 -= y1) * y2;
    }
}

