/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.colorspace.shading;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.shading.AbstractPdfShading;
import com.itextpdf.kernel.pdf.function.IPdfFunction;

public class PdfFunctionBasedShading
extends AbstractPdfShading {
    public PdfFunctionBasedShading(PdfDictionary pdfDictionary) {
        super(pdfDictionary);
    }

    public PdfFunctionBasedShading(PdfColorSpace colorSpace, IPdfFunction function) {
        this((PdfObject)colorSpace.getPdfObject(), function);
    }

    public PdfFunctionBasedShading(PdfObject colorSpace, IPdfFunction function) {
        super(new PdfDictionary(), 1, PdfColorSpace.makeColorSpace(colorSpace));
        this.setFunction(function);
    }

    public PdfArray getDomain() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Domain);
    }

    public void setDomain(float xmin, float xmax, float ymin, float ymax) {
        this.setDomain(new PdfArray(new float[]{xmin, xmax, ymin, ymax}));
    }

    public void setDomain(PdfArray domain) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Domain, domain);
        this.setModified();
    }

    public PdfArray getMatrix() {
        PdfArray matrix = ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Matrix);
        if (matrix == null) {
            matrix = new PdfArray(new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f});
            this.setMatrix(matrix);
        }
        return matrix;
    }

    public void setMatrix(float[] matrix) {
        this.setMatrix(new PdfArray(matrix));
    }

    public void setMatrix(PdfArray matrix) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Matrix, matrix);
        this.setModified();
    }
}

