/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.TabStop;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.LineLayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.TabAlignment;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.MaxSumWidthHandler;
import com.itextpdf.layout.renderer.TabRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.renderer.TypographyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

public class LineRenderer
extends AbstractRenderer {
    protected float maxAscent;
    protected float maxDescent;
    protected byte[] levels;

    @Override
    public LineLayoutResult layout(LayoutContext layoutContext) {
        LineRenderer processed;
        Rectangle layoutBox = layoutContext.getArea().getBBox().clone();
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        if (floatRendererAreas != null) {
            this.adjustLineAreaAccordingToFloatRenderers(floatRendererAreas, layoutBox);
        }
        this.occupiedArea = new LayoutArea(layoutContext.getArea().getPageNumber(), layoutBox.clone().moveDown(-layoutBox.getHeight()).setHeight(0.0f));
        float curWidth = 0.0f;
        this.maxAscent = 0.0f;
        this.maxDescent = 0.0f;
        int childPos = 0;
        MinMaxWidth minMaxWidth = new MinMaxWidth(0.0f, layoutBox.getWidth());
        MaxSumWidthHandler widthHandler = new MaxSumWidthHandler(minMaxWidth);
        this.updateChildrenParent();
        this.resolveChildrenFonts();
        int totalNumberOfTrimmedGlyphs = this.trimFirst();
        BaseDirection baseDirection = this.applyOtf();
        this.updateBidiLevels(totalNumberOfTrimmedGlyphs, baseDirection);
        boolean anythingPlaced = false;
        TabStop hangingTabStop = null;
        LayoutResult result = null;
        ArrayList<Rectangle> currentLineFloatRendererAreas = new ArrayList<Rectangle>();
        while (childPos < this.childRenderers.size()) {
            boolean shouldBreakLayouting;
            IRenderer childRenderer = (IRenderer)this.childRenderers.get(childPos);
            Rectangle bbox = new Rectangle(layoutBox.getX() + curWidth, layoutBox.getY(), layoutBox.getWidth() - curWidth, layoutBox.getHeight());
            if (childRenderer instanceof TextRenderer) {
                childRenderer.deleteOwnProperty(15);
                childRenderer.deleteOwnProperty(78);
            } else if (childRenderer instanceof TabRenderer) {
                if (hangingTabStop != null) {
                    IRenderer tabRenderer = (IRenderer)this.childRenderers.get(childPos - 1);
                    tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox)));
                    curWidth += tabRenderer.getOccupiedArea().getBBox().getWidth();
                    ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(tabRenderer.getOccupiedArea().getBBox().getWidth());
                }
                hangingTabStop = this.calculateTab(childRenderer, curWidth, layoutBox.getWidth());
                if (childPos == this.childRenderers.size() - 1) {
                    hangingTabStop = null;
                }
                if (hangingTabStop != null) {
                    ++childPos;
                    continue;
                }
            }
            if (hangingTabStop != null && hangingTabStop.getTabAlignment() == TabAlignment.ANCHOR && childRenderer instanceof TextRenderer) {
                childRenderer.setProperty(66, hangingTabStop.getTabAnchor());
            }
            Iterator<IRenderer> childWidth = childRenderer.getProperty(77);
            boolean childWidthWasReplaced = false;
            boolean childRendererHasOwnWidthProperty = childRenderer.hasOwnProperty(77);
            if (childWidth instanceof UnitValue && ((UnitValue)((Object)childWidth)).isPercentValue()) {
                float normalizedChildWidth = ((UnitValue)((Object)childWidth)).getValue() / 100.0f * layoutContext.getArea().getBBox().getWidth();
                if (childRenderer instanceof AbstractRenderer) {
                    Rectangle dummyRect = new Rectangle(normalizedChildWidth, 0.0f);
                    ((AbstractRenderer)childRenderer).applyMargins(dummyRect, false);
                    ((AbstractRenderer)childRenderer).applyBorderBox(dummyRect, false);
                    ((AbstractRenderer)childRenderer).applyPaddings(dummyRect, false);
                    normalizedChildWidth = dummyRect.getWidth();
                }
                if (normalizedChildWidth > 0.0f) {
                    childRenderer.setProperty(77, UnitValue.createPointValue(normalizedChildWidth));
                    childWidthWasReplaced = true;
                }
            }
            LayoutResult childResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox)));
            if (childWidthWasReplaced) {
                if (childRendererHasOwnWidthProperty) {
                    childRenderer.setProperty(77, childWidth);
                } else {
                    childRenderer.deleteOwnProperty(77);
                }
            }
            float minChildWidth = 0.0f;
            float maxChildWidth = 0.0f;
            if (childResult instanceof MinMaxWidthLayoutResult) {
                if (!childWidthWasReplaced) {
                    minChildWidth = ((MinMaxWidthLayoutResult)childResult).getNotNullMinMaxWidth(bbox.getWidth()).getMinWidth();
                }
                maxChildWidth = ((MinMaxWidthLayoutResult)childResult).getNotNullMinMaxWidth(bbox.getWidth()).getMaxWidth();
            }
            float childAscent = 0.0f;
            float childDescent = 0.0f;
            if (childRenderer instanceof ILeafElementRenderer) {
                childAscent = ((ILeafElementRenderer)childRenderer).getAscent();
                childDescent = ((ILeafElementRenderer)childRenderer).getDescent();
            }
            if (!childRenderer.hasProperty(99) || !(childRenderer instanceof ImageRenderer)) {
                this.maxAscent = Math.max(this.maxAscent, childAscent);
            } else if (childResult.getStatus() != 3 && childRenderer instanceof ImageRenderer) {
                currentLineFloatRendererAreas.add(childRenderer.getOccupiedArea().getBBox());
            }
            this.maxDescent = Math.min(this.maxDescent, childDescent);
            float maxHeight = this.maxAscent - this.maxDescent;
            if (hangingTabStop != null) {
                IRenderer tabRenderer = (IRenderer)this.childRenderers.get(childPos - 1);
                float tabWidth = this.calculateTab(layoutBox, curWidth, hangingTabStop, childRenderer, childResult, tabRenderer);
                tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox)));
                childResult.getOccupiedArea().getBBox().moveRight(tabWidth);
                if (childResult.getSplitRenderer() != null) {
                    childResult.getSplitRenderer().getOccupiedArea().getBBox().moveRight(tabWidth);
                }
                float tabAndNextElemWidth = tabWidth + childResult.getOccupiedArea().getBBox().getWidth();
                curWidth = hangingTabStop.getTabAlignment() == TabAlignment.RIGHT && curWidth + tabAndNextElemWidth < hangingTabStop.getTabPosition() ? hangingTabStop.getTabPosition() : (curWidth += tabAndNextElemWidth);
                ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth);
                ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(tabWidth + maxChildWidth);
                hangingTabStop = null;
            } else {
                curWidth += childResult.getOccupiedArea().getBBox().getWidth();
                ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth);
                ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(maxChildWidth);
            }
            this.occupiedArea.setBBox(new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight() - maxHeight, curWidth, maxHeight));
            boolean newLineOccurred = childResult instanceof TextLayoutResult && ((TextLayoutResult)childResult).isSplitForcedByNewline();
            boolean bl = shouldBreakLayouting = childResult.getStatus() != 1 || newLineOccurred;
            if (shouldBreakLayouting) {
                LayoutResult newLayoutResult;
                LineRenderer[] split = this.split();
                split[0].childRenderers = new ArrayList(this.childRenderers.subList(0, childPos));
                boolean wordWasSplitAndItWillFitOntoNextLine = false;
                if (childResult instanceof TextLayoutResult && ((TextLayoutResult)childResult).isWordHasBeenSplit() && (newLayoutResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), layoutBox)))) instanceof TextLayoutResult && !((TextLayoutResult)newLayoutResult).isWordHasBeenSplit()) {
                    wordWasSplitAndItWillFitOntoNextLine = true;
                }
                if (wordWasSplitAndItWillFitOntoNextLine) {
                    split[1].childRenderers.add(childRenderer);
                    split[1].childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                } else {
                    if (childResult.getStatus() == 2 || childResult.getStatus() == 1) {
                        split[0].addChild(childResult.getSplitRenderer());
                        anythingPlaced = true;
                    }
                    if (childResult.getStatus() == 2 && childResult.getOverflowRenderer() instanceof ImageRenderer) {
                        ((ImageRenderer)childResult.getOverflowRenderer()).autoScale(layoutContext.getArea());
                    }
                    if (null != childResult.getOverflowRenderer()) {
                        split[1].childRenderers.add(childResult.getOverflowRenderer());
                    }
                    split[1].childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                    if (split[1].childRenderers.size() == 0) {
                        split[1] = null;
                    }
                }
                IRenderer causeOfNothing = childResult.getStatus() == 3 ? childResult.getCauseOfNothing() : childRenderer;
                floatRendererAreas.addAll(currentLineFloatRendererAreas);
                result = split[1] == null ? new LineLayoutResult(1, this.occupiedArea, split[0], split[1], causeOfNothing) : (anythingPlaced ? new LineLayoutResult(2, this.occupiedArea, split[0], split[1], causeOfNothing) : new LineLayoutResult(3, null, split[0], split[1], causeOfNothing));
                if (!newLineOccurred) break;
                ((LineLayoutResult)result).setSplitForcedByNewline(true);
                break;
            }
            anythingPlaced = true;
            ++childPos;
        }
        if (result == null) {
            result = anythingPlaced || 0 == this.childRenderers.size() ? new LineLayoutResult(1, this.occupiedArea, null, null) : new LineLayoutResult(3, null, null, this, this);
        }
        if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI) {
            List<IRenderer> children = null;
            if (result.getStatus() == 2) {
                children = result.getSplitRenderer().getChildRenderers();
            } else if (result.getStatus() == 1) {
                children = this.getChildRenderers();
            }
            if (children != null) {
                int[] reorder;
                boolean newLineFound = false;
                ArrayList lineGlyphs = new ArrayList();
                block1: for (IRenderer child : children) {
                    if (newLineFound) break;
                    if (!(child instanceof TextRenderer)) continue;
                    GlyphLine childLine = ((TextRenderer)child).line;
                    for (int i = childLine.start; i < childLine.end; ++i) {
                        if (TextUtil.isNewLine((Glyph)childLine.get(i))) {
                            newLineFound = true;
                            continue block1;
                        }
                        lineGlyphs.add(new RendererGlyph(childLine.get(i), (TextRenderer)child));
                    }
                }
                byte[] lineLevels = new byte[lineGlyphs.size()];
                if (this.levels != null) {
                    System.arraycopy(this.levels, 0, lineLevels, 0, lineGlyphs.size());
                }
                if ((reorder = TypographyUtils.reorderLine(lineGlyphs, lineLevels, this.levels)) != null) {
                    children.clear();
                    int pos = 0;
                    int initialPos = 0;
                    boolean reversed = false;
                    int offset = 0;
                    while (pos < lineGlyphs.size()) {
                        TextRenderer renderer = ((RendererGlyph)lineGlyphs.get((int)pos)).renderer;
                        TextRenderer newRenderer = new TextRenderer(renderer).removeReversedRanges();
                        children.add(newRenderer);
                        newRenderer.line = new GlyphLine(newRenderer.line);
                        ArrayList<Glyph> replacementGlyphs = new ArrayList<Glyph>();
                        while (pos < lineGlyphs.size() && ((RendererGlyph)lineGlyphs.get((int)pos)).renderer == renderer) {
                            if (pos + 1 < lineGlyphs.size()) {
                                if (reorder[pos] == reorder[pos + 1] + 1 && !TextUtil.isSpaceOrWhitespace((Glyph)((RendererGlyph)lineGlyphs.get((int)(pos + 1))).glyph) && !TextUtil.isSpaceOrWhitespace((Glyph)((RendererGlyph)lineGlyphs.get((int)pos)).glyph)) {
                                    reversed = true;
                                } else {
                                    if (reversed) {
                                        List<int[]> reversedRange = newRenderer.initReversedRanges();
                                        reversedRange.add(new int[]{initialPos - offset, pos - offset});
                                        reversed = false;
                                    }
                                    initialPos = pos + 1;
                                }
                            }
                            replacementGlyphs.add(((RendererGlyph)lineGlyphs.get((int)pos)).glyph);
                            ++pos;
                        }
                        if (reversed) {
                            List<int[]> reversedRange = newRenderer.initReversedRanges();
                            reversedRange.add(new int[]{initialPos - offset, pos - 1 - offset});
                            reversed = false;
                            initialPos = pos;
                        }
                        offset = initialPos;
                        newRenderer.line.setGlyphs(replacementGlyphs);
                    }
                    float currentXPos = this.occupiedArea.getBBox().getLeft();
                    for (IRenderer child : children) {
                        float currentWidth = ((TextRenderer)child).calculateLineWidth();
                        float[] margins = ((TextRenderer)child).getMargins();
                        ((TextRenderer)child).occupiedArea.getBBox().setX(currentXPos).setWidth(currentWidth += margins[1] + margins[3]);
                        currentXPos += currentWidth;
                    }
                }
                if (result.getStatus() == 2) {
                    LineRenderer overflow = (LineRenderer)result.getOverflowRenderer();
                    if (this.levels != null) {
                        overflow.levels = new byte[this.levels.length - lineLevels.length];
                        System.arraycopy(this.levels, lineLevels.length, overflow.levels, 0, overflow.levels.length);
                        if (overflow.levels.length == 0) {
                            overflow.levels = null;
                        }
                    }
                }
            }
        }
        LineRenderer lineRenderer = processed = result.getStatus() == 1 ? this : (LineRenderer)result.getSplitRenderer();
        if (anythingPlaced) {
            processed.adjustChildrenYLine().trimLast();
            ((MinMaxWidthLayoutResult)result).setMinMaxWidth(minMaxWidth);
        } else if (floatRendererAreas.size() > 0) {
            float maxFloatHeight = 0.0f;
            for (Rectangle floatRenderer : floatRendererAreas) {
                if (!(maxFloatHeight < floatRenderer.getHeight())) continue;
                maxFloatHeight = floatRenderer.getHeight();
            }
            processed.getOccupiedArea().getBBox().setHeight(maxFloatHeight);
            processed.getOccupiedArea().getBBox().moveDown(maxFloatHeight);
        }
        List<IRenderer> currentLineChildRenderers = result.getStatus() == 1 ? this.childRenderers : result.getSplitRenderer().getChildRenderers();
        LayoutArea editedArea = this.applyFloatPropertyOnChildRenderers(currentLineChildRenderers);
        if (editedArea != null) {
            processed.getOccupiedArea().setBBox(editedArea.getBBox());
        }
        floatRendererAreas.addAll(currentLineFloatRendererAreas);
        return result;
    }

    public float getMaxAscent() {
        return this.maxAscent;
    }

    public float getMaxDescent() {
        return this.maxDescent;
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() - this.maxDescent;
    }

    public float getLeadingValue(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return leading.getValue();
            }
            case 2: {
                return this.occupiedArea.getBBox().getHeight() * leading.getValue();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IRenderer getNextRenderer() {
        return new LineRenderer();
    }

    @Override
    protected Float getFirstYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    public void justify(float width) {
        float ratio = this.getPropertyAsFloat(61).floatValue();
        float freeWidth = this.occupiedArea.getBBox().getX() + width - this.getLastChildRenderer().getOccupiedArea().getBBox().getX() - this.getLastChildRenderer().getOccupiedArea().getBBox().getWidth();
        int numberOfSpaces = this.getNumberOfSpaces();
        int baseCharsCount = this.baseCharactersCount();
        float baseFactor = freeWidth / (ratio * (float)numberOfSpaces + (1.0f - ratio) * (float)(baseCharsCount - 1));
        float wordSpacing = ratio * baseFactor;
        float characterSpacing = (1.0f - ratio) * baseFactor;
        float lastRightPos = this.occupiedArea.getBBox().getX();
        for (int i = 0; i < this.childRenderers.size(); ++i) {
            IRenderer child = (IRenderer)this.childRenderers.get(i);
            float childX = child.getOccupiedArea().getBBox().getX();
            child.move(lastRightPos - childX, 0.0f);
            childX = lastRightPos;
            if (child instanceof TextRenderer) {
                float childHSCale = ((TextRenderer)child).getPropertyAsFloat(29, Float.valueOf(1.0f)).floatValue();
                child.setProperty(15, Float.valueOf(characterSpacing / childHSCale));
                child.setProperty(78, Float.valueOf(wordSpacing / childHSCale));
                boolean isLastTextRenderer = i + 1 == this.childRenderers.size();
                float widthAddition = (float)(isLastTextRenderer ? ((TextRenderer)child).lineLength() - 1 : ((TextRenderer)child).lineLength()) * characterSpacing + wordSpacing * (float)((TextRenderer)child).getNumberOfSpaces();
                child.getOccupiedArea().getBBox().setWidth(child.getOccupiedArea().getBBox().getWidth() + widthAddition);
            }
            lastRightPos = childX + child.getOccupiedArea().getBBox().getWidth();
        }
        this.getOccupiedArea().getBBox().setWidth(width);
    }

    protected int getNumberOfSpaces() {
        int spaces = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer)) continue;
            spaces += ((TextRenderer)child).getNumberOfSpaces();
        }
        return spaces;
    }

    protected int length() {
        int length = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer)) continue;
            length += ((TextRenderer)child).lineLength();
        }
        return length;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer)) continue;
            count += ((TextRenderer)child).baseCharactersCount();
        }
        return count;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    protected LineRenderer createSplitRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer createOverflowRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer[] split() {
        LineRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.maxAscent = this.maxAscent;
        splitRenderer.maxDescent = this.maxDescent;
        splitRenderer.levels = this.levels;
        splitRenderer.addAllProperties(this.getOwnProperties());
        LineRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return new LineRenderer[]{splitRenderer, overflowRenderer};
    }

    protected LineRenderer adjustChildrenYLine() {
        float actualYLine = this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.maxAscent;
        for (IRenderer renderer : this.childRenderers) {
            if (renderer instanceof ILeafElementRenderer) {
                float descent = ((ILeafElementRenderer)renderer).getDescent();
                renderer.move(0.0f, actualYLine - renderer.getOccupiedArea().getBBox().getBottom() + descent);
                if (!(renderer instanceof ImageRenderer) || !renderer.hasProperty(99)) continue;
                renderer.move(0.0f, -((ILeafElementRenderer)renderer).getAscent() + this.maxAscent);
                continue;
            }
            renderer.move(0.0f, this.occupiedArea.getBBox().getY() - renderer.getOccupiedArea().getBBox().getBottom());
        }
        return this;
    }

    protected LineRenderer trimLast() {
        IRenderer lastRenderer;
        IRenderer iRenderer = lastRenderer = this.childRenderers.size() > 0 ? (IRenderer)this.childRenderers.get(this.childRenderers.size() - 1) : null;
        if (lastRenderer instanceof TextRenderer) {
            float trimmedSpace = ((TextRenderer)lastRenderer).trimLast();
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - trimmedSpace);
        }
        return this;
    }

    public boolean containsImage() {
        for (IRenderer renderer : this.childRenderers) {
            if (!(renderer instanceof ImageRenderer)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MinMaxWidth getMinMaxWidth(float availableWidth) {
        LineLayoutResult result = this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(availableWidth, 1000000.0f))));
        return result.getNotNullMinMaxWidth(availableWidth);
    }

    private LayoutArea applyFloatPropertyOnChildRenderers(List<IRenderer> childRenderers) {
        LayoutArea editedArea = null;
        float lineHeight = 0.0f;
        boolean lineHasFloatProperty = false;
        for (IRenderer renderer : childRenderers) {
            if (renderer.hasProperty(99)) {
                lineHasFloatProperty = true;
                continue;
            }
            if (!(renderer instanceof BlockRenderer) || renderer.getOccupiedArea() == null || !(renderer.getOccupiedArea().getBBox().getHeight() > lineHeight)) continue;
            lineHeight = renderer.getOccupiedArea().getBBox().getHeight();
        }
        if (lineHasFloatProperty && lineHeight > 0.0f) {
            editedArea = this.occupiedArea.clone();
            editedArea.getBBox().moveUp(editedArea.getBBox().getHeight() - lineHeight);
        }
        return editedArea;
    }

    private IRenderer getLastChildRenderer() {
        return (IRenderer)this.childRenderers.get(this.childRenderers.size() - 1);
    }

    private TabStop getNextTabStop(float curWidth) {
        NavigableMap tabStops = (NavigableMap)this.getProperty(69);
        Map.Entry nextTabStopEntry = null;
        TabStop nextTabStop = null;
        if (tabStops != null) {
            nextTabStopEntry = tabStops.higherEntry(Float.valueOf(curWidth));
        }
        if (nextTabStopEntry != null) {
            nextTabStop = (TabStop)nextTabStopEntry.getValue();
        }
        return nextTabStop;
    }

    private TabStop calculateTab(IRenderer childRenderer, float curWidth, float lineWidth) {
        TabStop nextTabStop = this.getNextTabStop(curWidth);
        if (nextTabStop == null) {
            this.processDefaultTab(childRenderer, curWidth, lineWidth);
            return null;
        }
        childRenderer.setProperty(68, nextTabStop.getTabLeader());
        childRenderer.setProperty(77, UnitValue.createPointValue(nextTabStop.getTabPosition() - curWidth));
        childRenderer.setProperty(85, Float.valueOf(this.maxAscent - this.maxDescent));
        if (nextTabStop.getTabAlignment() == TabAlignment.LEFT) {
            return null;
        }
        return nextTabStop;
    }

    private float calculateTab(Rectangle layoutBox, float curWidth, TabStop tabStop, IRenderer nextElementRenderer, LayoutResult nextElementResult, IRenderer tabRenderer) {
        float childWidth = 0.0f;
        if (nextElementRenderer != null) {
            childWidth = nextElementRenderer.getOccupiedArea().getBBox().getWidth();
        }
        float tabWidth = 0.0f;
        switch (tabStop.getTabAlignment()) {
            case RIGHT: {
                tabWidth = tabStop.getTabPosition() - curWidth - childWidth;
                break;
            }
            case CENTER: {
                tabWidth = tabStop.getTabPosition() - curWidth - childWidth / 2.0f;
                break;
            }
            case ANCHOR: {
                float anchorPosition = -1.0f;
                if (nextElementRenderer instanceof TextRenderer) {
                    anchorPosition = ((TextRenderer)nextElementRenderer).getTabAnchorCharacterPosition();
                }
                if (anchorPosition == -1.0f) {
                    anchorPosition = childWidth;
                }
                tabWidth = tabStop.getTabPosition() - curWidth - anchorPosition;
            }
        }
        if (tabWidth < 0.0f) {
            tabWidth = 0.0f;
        }
        if (curWidth + tabWidth + childWidth > layoutBox.getWidth()) {
            tabWidth -= curWidth + childWidth + tabWidth - layoutBox.getWidth();
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth));
        tabRenderer.setProperty(85, Float.valueOf(this.maxAscent - this.maxDescent));
        return tabWidth;
    }

    private void processDefaultTab(IRenderer tabRenderer, float curWidth, float lineWidth) {
        Float tabDefault = this.getPropertyAsFloat(67);
        Float tabWidth = Float.valueOf(tabDefault.floatValue() - curWidth % tabDefault.floatValue());
        if (curWidth + tabWidth.floatValue() > lineWidth) {
            tabWidth = Float.valueOf(lineWidth - curWidth);
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth.floatValue()));
        tabRenderer.setProperty(85, Float.valueOf(this.maxAscent - this.maxDescent));
    }

    private void updateChildrenParent() {
        for (IRenderer renderer : this.childRenderers) {
            renderer.setParent(this);
        }
    }

    private int trimFirst() {
        IRenderer renderer;
        int totalNumberOfTrimmedGlyphs = 0;
        Iterator iterator = this.childRenderers.iterator();
        while (iterator.hasNext() && (renderer = (IRenderer)iterator.next()) instanceof TextRenderer) {
            TextRenderer textRenderer = (TextRenderer)renderer;
            GlyphLine currentText = textRenderer.getText();
            if (currentText != null) {
                int prevTextStart = currentText.start;
                textRenderer.trimFirst();
                int numOfTrimmedGlyphs = textRenderer.getText().start - prevTextStart;
                totalNumberOfTrimmedGlyphs += numOfTrimmedGlyphs;
            }
            if (textRenderer.length() <= 0) continue;
            break;
        }
        return totalNumberOfTrimmedGlyphs;
    }

    private BaseDirection applyOtf() {
        BaseDirection baseDirection = (BaseDirection)((Object)this.getProperty(7));
        for (IRenderer renderer : this.childRenderers) {
            if (!(renderer instanceof TextRenderer)) continue;
            ((TextRenderer)renderer).applyOtf();
            if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI) continue;
            baseDirection = (BaseDirection)((Object)renderer.getOwnProperty(7));
        }
        return baseDirection;
    }

    private void updateBidiLevels(int totalNumberOfTrimmedGlyphs, BaseDirection baseDirection) {
        if (totalNumberOfTrimmedGlyphs != 0 && this.levels != null) {
            this.levels = Arrays.copyOfRange(this.levels, totalNumberOfTrimmedGlyphs, this.levels.length);
        }
        ArrayList<Integer> unicodeIdsReorderingList = null;
        if (this.levels == null && baseDirection != null && baseDirection != BaseDirection.NO_BIDI) {
            unicodeIdsReorderingList = new ArrayList<Integer>();
            boolean newLineFound = false;
            block0: for (IRenderer child : this.childRenderers) {
                if (newLineFound) break;
                if (!(child instanceof TextRenderer)) continue;
                GlyphLine text = ((TextRenderer)child).getText();
                for (int i = text.start; i < text.end; ++i) {
                    Glyph glyph = text.get(i);
                    if (TextUtil.isNewLine((Glyph)glyph)) {
                        newLineFound = true;
                        continue block0;
                    }
                    int unicode = glyph.hasValidUnicode() ? glyph.getUnicode() : glyph.getUnicodeChars()[0];
                    unicodeIdsReorderingList.add(unicode);
                }
            }
            this.levels = unicodeIdsReorderingList.size() > 0 ? TypographyUtils.getBidiLevels(baseDirection, ArrayUtil.toArray(unicodeIdsReorderingList)) : null;
        }
    }

    private void resolveChildrenFonts() {
        ArrayList<IRenderer> newChildRenderers = new ArrayList<IRenderer>(this.childRenderers.size());
        boolean updateChildRendrers = false;
        for (IRenderer child : this.childRenderers) {
            if (child instanceof TextRenderer) {
                if (!((TextRenderer)child).resolveFonts(newChildRenderers)) continue;
                updateChildRendrers = true;
                continue;
            }
            newChildRenderers.add(child);
        }
        if (updateChildRendrers) {
            this.childRenderers = newChildRenderers;
        }
    }

    static class RendererGlyph {
        public Glyph glyph;
        public TextRenderer renderer;

        public RendererGlyph(Glyph glyph, TextRenderer textRenderer) {
            this.glyph = glyph;
            this.renderer = textRenderer;
        }
    }
}

