/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseInfo;
import com.itextpdf.layout.property.ParagraphOrphansControl;
import com.itextpdf.layout.property.ParagraphWidowsControl;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.ArrayList;

class OrphansWidowsLayoutHelper {
    private OrphansWidowsLayoutHelper() {
    }

    static LayoutResult orphansWidowsAwareLayout(ParagraphRenderer renderer, LayoutContext context, ParagraphOrphansControl orphansControl, ParagraphWidowsControl widowsControl) {
        OrphansWidowsLayoutAttempt layoutAttempt = OrphansWidowsLayoutHelper.attemptLayout(renderer, context, context.getArea().clone());
        if (context.isClippedHeight() || renderer.isPositioned() || layoutAttempt.attemptResult.getStatus() != 2 || layoutAttempt.attemptResult.getSplitRenderer() == null) {
            return OrphansWidowsLayoutHelper.handleAttemptAsSuccessful(layoutAttempt, context);
        }
        ParagraphRenderer splitRenderer = (ParagraphRenderer)layoutAttempt.attemptResult.getSplitRenderer();
        boolean orphansViolation = orphansControl != null && splitRenderer != null && splitRenderer.getLines().size() < orphansControl.getMinOrphans() && !renderer.isFirstOnRootArea();
        boolean forcedPlacement = Boolean.TRUE.equals(renderer.getPropertyAsBoolean(26));
        if (orphansViolation && forcedPlacement) {
            orphansControl.handleViolatedOrphans(splitRenderer, "Ignored orphans constraint due to forced placement.");
        }
        if (orphansViolation && !forcedPlacement) {
            layoutAttempt = null;
        } else if (widowsControl != null && splitRenderer != null && layoutAttempt.attemptResult.getOverflowRenderer() != null) {
            int extraWidows;
            ParagraphRenderer overflowRenderer = (ParagraphRenderer)layoutAttempt.attemptResult.getOverflowRenderer();
            int simulationHeight = 3500;
            LayoutArea simulationArea = new LayoutArea(context.getArea().getPageNumber(), context.getArea().getBBox().clone().setHeight((float)simulationHeight));
            LayoutContext simulationContext = new LayoutContext(simulationArea);
            LayoutResult simulationResult = overflowRenderer.directLayout(simulationContext);
            if (simulationResult.getStatus() == 1 && (extraWidows = widowsControl.getMinWidows() - overflowRenderer.getLines().size()) > 0) {
                int extraLinesToMove;
                int n = extraLinesToMove = orphansControl != null ? Math.max(orphansControl.getMinOrphans(), 1) : 1;
                if (extraWidows <= widowsControl.getMaxLinesToMove() && splitRenderer.getLines().size() - extraWidows >= extraLinesToMove) {
                    LineRenderer lastLine = splitRenderer.getLines().get(splitRenderer.getLines().size() - 1);
                    LineRenderer lastLineToLeave = splitRenderer.getLines().get(splitRenderer.getLines().size() - extraWidows - 1);
                    float d = lastLineToLeave.getOccupiedArea().getBBox().getY() - lastLine.getOccupiedArea().getBBox().getY() - 1.0E-4f;
                    Rectangle smallerBBox = new Rectangle(context.getArea().getBBox());
                    smallerBBox.decreaseHeight(d);
                    smallerBBox.moveUp(d);
                    LayoutArea smallerAvailableArea = new LayoutArea(context.getArea().getPageNumber(), smallerBBox);
                    layoutAttempt = OrphansWidowsLayoutHelper.attemptLayout(renderer, context, smallerAvailableArea);
                } else if (forcedPlacement || renderer.isFirstOnRootArea() || !widowsControl.isOverflowOnWidowsViolation()) {
                    if (forcedPlacement) {
                        widowsControl.handleViolatedWidows(overflowRenderer, "forced placement");
                    } else {
                        widowsControl.handleViolatedWidows(overflowRenderer, "inability to fix it");
                    }
                } else {
                    layoutAttempt = null;
                }
            }
        }
        if (layoutAttempt != null) {
            return OrphansWidowsLayoutHelper.handleAttemptAsSuccessful(layoutAttempt, context);
        }
        return new LayoutResult(3, null, null, renderer);
    }

    private static OrphansWidowsLayoutAttempt attemptLayout(ParagraphRenderer renderer, LayoutContext originalContext, LayoutArea attemptArea) {
        LayoutContext attemptContext;
        OrphansWidowsLayoutAttempt attemptResult = new OrphansWidowsLayoutAttempt();
        MarginsCollapseInfo copiedMarginsCollapseInfo = null;
        if (originalContext.getMarginsCollapseInfo() != null) {
            copiedMarginsCollapseInfo = MarginsCollapseInfo.createDeepCopy(originalContext.getMarginsCollapseInfo());
        }
        ArrayList<Rectangle> attemptFloatRectsList = new ArrayList<Rectangle>(originalContext.getFloatRendererAreas());
        attemptResult.attemptContext = attemptContext = new LayoutContext(attemptArea, copiedMarginsCollapseInfo, attemptFloatRectsList, originalContext.isClippedHeight());
        attemptResult.attemptResult = renderer.directLayout(attemptContext);
        return attemptResult;
    }

    private static LayoutResult handleAttemptAsSuccessful(OrphansWidowsLayoutAttempt attemptResult, LayoutContext originalContext) {
        originalContext.getFloatRendererAreas().clear();
        originalContext.getFloatRendererAreas().addAll(attemptResult.attemptContext.getFloatRendererAreas());
        if (originalContext.getMarginsCollapseInfo() != null) {
            MarginsCollapseInfo.updateFromCopy(originalContext.getMarginsCollapseInfo(), attemptResult.attemptContext.getMarginsCollapseInfo());
        }
        return attemptResult.attemptResult;
    }

    private static class OrphansWidowsLayoutAttempt {
        LayoutContext attemptContext;
        LayoutResult attemptResult;

        private OrphansWidowsLayoutAttempt() {
        }
    }
}

