/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.margincollapse.MarginsCollapseHandler;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.BorderCollapsePropertyValue;
import com.itextpdf.layout.properties.CaptionSide;
import com.itextpdf.layout.properties.FloatPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AccessibleAttributesApplier;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.CollapsedTableBorders;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.SeparatedTableBorders;
import com.itextpdf.layout.renderer.TableBorderDescriptor;
import com.itextpdf.layout.renderer.TableBorderUtil;
import com.itextpdf.layout.renderer.TableBorders;
import com.itextpdf.layout.renderer.TableWidths;
import com.itextpdf.layout.renderer.TargetCounterHandler;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRenderer
extends AbstractRenderer {
    protected List<CellRenderer[]> rows = new ArrayList<CellRenderer[]>();
    protected Table.RowRange rowRange;
    protected TableRenderer headerRenderer;
    protected TableRenderer footerRenderer;
    protected DivRenderer captionRenderer;
    protected boolean isOriginalNonSplitRenderer = true;
    TableBorders bordersHandler;
    private float[] columnWidths = null;
    private List<Float> heights = new ArrayList<Float>();
    private float[] countedColumnWidth = null;
    private float totalWidthForColumns;
    private float topBorderMaxWidth;

    private TableRenderer() {
    }

    public TableRenderer(Table modelElement, Table.RowRange rowRange) {
        super(modelElement);
        this.setRowRange(rowRange);
    }

    public TableRenderer(Table modelElement) {
        this(modelElement, new Table.RowRange(0, modelElement.getNumberOfRows() - 1));
    }

    @Override
    public void addChild(IRenderer renderer) {
        if (renderer instanceof CellRenderer) {
            Cell cell = (Cell)renderer.getModelElement();
            this.rows.get((int)(cell.getRow() - this.rowRange.getStartRow() + cell.getRowspan() - 1))[cell.getCol()] = (CellRenderer)renderer;
        } else {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error("Only CellRenderer could be added");
        }
    }

    @Override
    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            super.applyBorderBox(rect, borders, reverse);
        }
        return rect;
    }

    @Override
    protected Rectangle applyPaddings(Rectangle rect, UnitValue[] paddings, boolean reverse) {
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            super.applyPaddings(rect, paddings, reverse);
        }
        return rect;
    }

    @Override
    public Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            super.applyPaddings(rect, reverse);
        }
        return rect;
    }

    private Rectangle applySpacing(Rectangle rect, float horizontalSpacing, float verticalSpacing, boolean reverse) {
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            return rect.applyMargins(verticalSpacing / 2.0f, horizontalSpacing / 2.0f, verticalSpacing / 2.0f, horizontalSpacing / 2.0f, reverse);
        }
        return rect;
    }

    private Rectangle applySingleSpacing(Rectangle rect, float spacing, boolean isHorizontal, boolean reverse) {
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            if (isHorizontal) {
                return rect.applyMargins(0.0f, spacing / 2.0f, 0.0f, spacing / 2.0f, reverse);
            }
            return rect.applyMargins(spacing / 2.0f, 0.0f, spacing / 2.0f, 0.0f, reverse);
        }
        return rect;
    }

    Table getTable() {
        return (Table)this.getModelElement();
    }

    private void initializeHeaderAndFooter(boolean isFirstOnThePage) {
        boolean footerShouldBeApplied;
        boolean headerShouldBeApplied;
        Table table = (Table)this.getModelElement();
        Border[] tableBorder = this.getBorders();
        Table headerElement = table.getHeader();
        boolean isFirstHeader = this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer;
        boolean bl = headerShouldBeApplied = !(!table.isComplete() && this.rows.isEmpty() || !isFirstOnThePage || table.isSkipFirstHeader() && isFirstHeader || Boolean.TRUE.equals(this.getOwnProperty(97)));
        if (headerElement != null && headerShouldBeApplied) {
            this.headerRenderer = this.initFooterOrHeaderRenderer(false, tableBorder);
        }
        Table footerElement = table.getFooter();
        boolean bl2 = footerShouldBeApplied = (!table.isComplete() || 0 == table.getLastRowBottomBorder().size() || !table.isSkipLastFooter()) && !Boolean.TRUE.equals(this.getOwnProperty(96));
        if (footerElement != null && footerShouldBeApplied) {
            this.footerRenderer = this.initFooterOrHeaderRenderer(true, tableBorder);
        }
    }

    private void initializeCaptionRenderer(Div caption) {
        if (this.isOriginalNonSplitRenderer && null != caption) {
            this.captionRenderer = (DivRenderer)caption.createRendererSubTree();
            this.captionRenderer.setParent(this.parent);
            LayoutTaggingHelper taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
            if (taggingHelper != null) {
                taggingHelper.addKidsHint(this, Collections.singletonList(this.captionRenderer));
                LayoutTaggingHelper.addTreeHints(taggingHelper, this.captionRenderer);
            }
        }
    }

    private boolean isOriginalRenderer() {
        return this.isOriginalNonSplitRenderer && !this.isFooterRenderer() && !this.isHeaderRenderer();
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        float verticalBorderSpacing;
        boolean isFirstOnThePage;
        Float blockMinHeight = this.retrieveMinHeight();
        Float blockMaxHeight = this.retrieveMaxHeight();
        LayoutArea area = layoutContext.getArea();
        boolean wasParentsHeightClipped = layoutContext.isClippedHeight();
        boolean wasHeightClipped = false;
        Rectangle layoutBox = area.getBBox().clone();
        Table tableModel = (Table)this.getModelElement();
        if (!tableModel.isComplete()) {
            this.setProperty(43, UnitValue.createPointValue(0.0f));
        }
        if (this.rowRange.getStartRow() != 0) {
            this.setProperty(46, UnitValue.createPointValue(0.0f));
        }
        this.heights.clear();
        this.childRenderers.clear();
        HashMap<Integer, Integer> rowMoves = new HashMap<Integer, Integer>();
        int numberOfColumns = ((Table)this.getModelElement()).getNumberOfColumns();
        List<Border> lastFlushedRowBottomBorder = tableModel.getLastRowBottomBorder();
        boolean isAndWasComplete = tableModel.isComplete() && 0 == lastFlushedRowBottomBorder.size();
        boolean bl = isFirstOnThePage = 0 == this.rowRange.getStartRow() || this.isFirstOnRootArea(true);
        if (!this.isFooterRenderer() && !this.isHeaderRenderer() && this.isOriginalNonSplitRenderer) {
            boolean isSeparated = BorderCollapsePropertyValue.SEPARATE.equals(this.getProperty(114));
            this.bordersHandler = isSeparated ? new SeparatedTableBorders(this.rows, numberOfColumns, this.getBorders(), !isAndWasComplete ? this.rowRange.getStartRow() : 0) : new CollapsedTableBorders(this.rows, numberOfColumns, this.getBorders(), !isAndWasComplete ? this.rowRange.getStartRow() : 0);
            this.bordersHandler.initializeBorders();
        }
        this.bordersHandler.setRowRange(this.rowRange.getStartRow(), this.rowRange.getFinishRow());
        this.initializeHeaderAndFooter(isFirstOnThePage);
        this.bordersHandler.updateBordersOnNewPage(this.isOriginalNonSplitRenderer, this.isFooterRenderer() || this.isHeaderRenderer(), this, this.headerRenderer, this.footerRenderer);
        if (this.isOriginalNonSplitRenderer) {
            this.correctRowRange();
        }
        float horizontalBorderSpacing = this.bordersHandler instanceof SeparatedTableBorders && null != this.getPropertyAsFloat(115) ? this.getPropertyAsFloat(115).floatValue() : 0.0f;
        float f = verticalBorderSpacing = this.bordersHandler instanceof SeparatedTableBorders && null != this.getPropertyAsFloat(116) ? this.getPropertyAsFloat(116).floatValue() : 0.0f;
        if (!isAndWasComplete && !isFirstOnThePage) {
            layoutBox.increaseHeight(verticalBorderSpacing);
        }
        if (this.isOriginalRenderer()) {
            this.applyMarginsAndPaddingsAndCalculateColumnWidths(layoutBox);
        }
        float tableWidth = this.getTableWidth();
        MarginsCollapseHandler marginsCollapseHandler = null;
        boolean marginsCollapsingEnabled = Boolean.TRUE.equals(this.getPropertyAsBoolean(89));
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler = new MarginsCollapseHandler(this, layoutContext.getMarginsCollapseInfo());
        }
        List<Rectangle> siblingFloatRendererAreas = layoutContext.getFloatRendererAreas();
        float clearHeightCorrection = FloatingHelper.calculateClearHeightCorrection(this, siblingFloatRendererAreas, layoutBox);
        FloatPropertyValue floatPropertyValue = (FloatPropertyValue)((Object)this.getProperty(99));
        if (FloatingHelper.isRendererFloating(this, floatPropertyValue)) {
            layoutBox.decreaseHeight(clearHeightCorrection);
            FloatingHelper.adjustFloatedTableLayoutBox(this, layoutBox, tableWidth, siblingFloatRendererAreas, floatPropertyValue);
        } else {
            clearHeightCorrection = FloatingHelper.adjustLayoutBoxAccordingToFloats(siblingFloatRendererAreas, layoutBox, Float.valueOf(tableWidth), clearHeightCorrection, marginsCollapseHandler);
        }
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.startMarginsCollapse(layoutBox);
        }
        this.applyMargins(layoutBox, false);
        this.applyFixedXOrYPosition(true, layoutBox);
        this.applyPaddings(layoutBox, false);
        if (null != blockMaxHeight && blockMaxHeight.floatValue() <= layoutBox.getHeight() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
            layoutBox.moveUp(layoutBox.getHeight() - blockMaxHeight.floatValue()).setHeight(blockMaxHeight.floatValue());
            wasHeightClipped = true;
        }
        this.initializeCaptionRenderer(this.getTable().getCaption());
        if (this.captionRenderer != null) {
            float minCaptionWidth = this.captionRenderer.getMinMaxWidth().getMinWidth();
            LayoutResult captionLayoutResult = this.captionRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY(), Math.max(tableWidth, minCaptionWidth), layoutBox.getHeight())), wasHeightClipped || wasParentsHeightClipped));
            if (1 != captionLayoutResult.getStatus()) {
                return new LayoutResult(3, null, null, this, captionLayoutResult.getCauseOfNothing());
            }
            float captionHeight = captionLayoutResult.getOccupiedArea().getBBox().getHeight();
            if (CaptionSide.BOTTOM.equals(tableModel.getCaption().getProperty(119))) {
                this.captionRenderer.move(0.0f, -(layoutBox.getHeight() - captionHeight));
                layoutBox.decreaseHeight(captionHeight);
                layoutBox.moveUp(captionHeight);
            } else {
                layoutBox.decreaseHeight(captionHeight);
            }
        }
        this.occupiedArea = new LayoutArea(area.getPageNumber(), new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight(), tableWidth, 0.0f));
        TargetCounterHandler.addPageByID(this);
        if (this.footerRenderer != null) {
            this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
            if (0 != this.rows.size() || !isAndWasComplete) {
                this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, false);
            } else if (null != this.headerRenderer) {
                this.headerRenderer.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, false);
            }
            LayoutResult result = this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
            if (result.getStatus() != 1) {
                this.deleteOwnProperty(10);
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float footerHeight = result.getOccupiedArea().getBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
            layoutBox.moveDown(verticalBorderSpacing).increaseHeight(verticalBorderSpacing);
            if (!tableModel.isEmpty()) {
                float maxFooterTopBorderWidth = this.footerRenderer.bordersHandler.getMaxTopWidth();
                this.footerRenderer.occupiedArea.getBBox().decreaseHeight(maxFooterTopBorderWidth);
                layoutBox.moveDown(maxFooterTopBorderWidth).increaseHeight(maxFooterTopBorderWidth);
            }
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                this.footerRenderer.setProperty(26, true);
            }
        }
        if (this.headerRenderer != null) {
            this.prepareFooterOrHeaderRendererForLayout(this.headerRenderer, layoutBox.getWidth());
            if (0 != this.rows.size()) {
                this.bordersHandler.collapseTableWithHeader(this.headerRenderer.bordersHandler, !tableModel.isEmpty());
            } else if (null != this.footerRenderer) {
                this.footerRenderer.bordersHandler.collapseTableWithHeader(this.headerRenderer.bordersHandler, true);
            }
            this.topBorderMaxWidth = this.bordersHandler.getMaxTopWidth();
            LayoutResult result = this.headerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
            if (result.getStatus() != 1) {
                this.deleteOwnProperty(13);
                return new LayoutResult(3, null, null, this, result.getCauseOfNothing());
            }
            float headerHeight = result.getOccupiedArea().getBBox().getHeight();
            layoutBox.decreaseHeight(headerHeight);
            this.occupiedArea.getBBox().moveDown(headerHeight).increaseHeight(headerHeight);
            this.bordersHandler.fixHeaderOccupiedArea(this.occupiedArea.getBBox(), layoutBox);
            layoutBox.increaseHeight(verticalBorderSpacing);
            this.occupiedArea.getBBox().moveUp(verticalBorderSpacing).decreaseHeight(verticalBorderSpacing);
        }
        this.applySpacing(layoutBox, horizontalBorderSpacing, verticalBorderSpacing, false);
        this.applySingleSpacing(this.occupiedArea.getBBox(), horizontalBorderSpacing, true, false);
        this.occupiedArea.getBBox().moveDown(verticalBorderSpacing / 2.0f);
        this.topBorderMaxWidth = this.bordersHandler.getMaxTopWidth();
        this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, false);
        this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, tableModel.isEmpty() || 0 == this.rows.size(), isAndWasComplete, false);
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            float bottomBorderWidth = this.bordersHandler.getMaxBottomWidth();
            layoutBox.moveUp(bottomBorderWidth).decreaseHeight(bottomBorderWidth);
        }
        LayoutResult[] splits = new LayoutResult[numberOfColumns];
        int[] targetOverflowRowIndex = new int[numberOfColumns];
        ArrayList<Boolean> rowsHasCellWithSetHeight = new ArrayList<Boolean>();
        for (int row = 0; row < this.rows.size(); ++row) {
            LayoutArea editedArea;
            int status;
            LayoutTaggingHelper taggingHelper;
            int col;
            ArrayList<Rectangle> childFloatRendererAreas = new ArrayList<Rectangle>();
            if (row == 1 && Boolean.TRUE.equals(this.getProperty(26))) {
                if (Boolean.TRUE.equals(this.getOwnProperty(26))) {
                    this.deleteOwnProperty(26);
                } else {
                    this.setProperty(26, false);
                }
            }
            CellRenderer[] currentRow = this.rows.get(row);
            float rowHeight = 0.0f;
            boolean split = false;
            boolean hasContent = true;
            boolean cellWithBigRowspanAdded = false;
            ArrayList<CellRenderer> currChildRenderers = new ArrayList<CellRenderer>();
            ArrayDeque<CellRendererInfo> cellProcessingQueue = new ArrayDeque<CellRendererInfo>();
            for (col = 0; col < currentRow.length; ++col) {
                if (currentRow[col] == null) continue;
                cellProcessingQueue.addLast(new CellRendererInfo(currentRow[col], col, row));
            }
            boolean rowHasCellWithSetHeight = false;
            IRenderer firstCauseOfNothing = null;
            this.bordersHandler.setFinishRow(this.rowRange.getStartRow() + row);
            List<Border> rowBottomBorderIfLastOnPage = this.bordersHandler.getHorizontalBorder(this.rowRange.getStartRow() + row + 1);
            Border widestRowBottomBorder = TableBorderUtil.getWidestBorder(rowBottomBorderIfLastOnPage);
            float widestRowBottomBorderWidth = null == widestRowBottomBorder ? 0.0f : widestRowBottomBorder.getWidth();
            this.bordersHandler.setFinishRow(this.rowRange.getFinishRow());
            while (cellProcessingQueue.size() > 0) {
                boolean currentCellHasBigRowspan;
                CellRendererInfo currentCellInfo = (CellRendererInfo)cellProcessingQueue.pop();
                col = currentCellInfo.column;
                CellRenderer cell = currentCellInfo.cellRenderer;
                int colspan = cell.getPropertyAsInteger(16);
                int rowspan = cell.getPropertyAsInteger(60);
                if (1 != rowspan) {
                    cellWithBigRowspanAdded = true;
                }
                targetOverflowRowIndex[col] = currentCellInfo.finishRowInd;
                boolean bl2 = currentCellHasBigRowspan = row != currentCellInfo.finishRowInd;
                if (cell.hasOwnOrModelProperty(27)) {
                    rowHasCellWithSetHeight = true;
                }
                float cellWidth = 0.0f;
                float colOffset = 0.0f;
                for (int k = col; k < col + colspan; ++k) {
                    cellWidth += this.countedColumnWidth[k];
                }
                for (int l = 0; l < col; ++l) {
                    colOffset += this.countedColumnWidth[l];
                }
                float rowspanOffset = 0.0f;
                for (int m = row - 1; m > currentCellInfo.finishRowInd - rowspan && m >= 0; --m) {
                    rowspanOffset += this.heights.get(m).floatValue();
                }
                float cellLayoutBoxHeight = rowspanOffset + (!currentCellHasBigRowspan || hasContent ? layoutBox.getHeight() : 0.0f);
                float cellLayoutBoxBottom = layoutBox.getY() + (!currentCellHasBigRowspan || hasContent ? 0.0f : layoutBox.getHeight());
                Rectangle cellLayoutBox = new Rectangle(layoutBox.getX() + colOffset, cellLayoutBoxBottom, cellWidth, cellLayoutBoxHeight);
                LayoutArea cellArea = new LayoutArea(layoutContext.getArea().getPageNumber(), cellLayoutBox);
                VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)cell.getProperty(75));
                cell.setProperty(75, null);
                UnitValue cellWidthProperty = (UnitValue)cell.getProperty(77);
                if (cellWidthProperty != null && cellWidthProperty.isPercentValue()) {
                    cell.setProperty(77, UnitValue.createPointValue(cellWidth));
                }
                float[] cellIndents = this.bordersHandler.getCellBorderIndents(currentCellInfo.finishRowInd, col, rowspan, colspan);
                if (!(this.bordersHandler instanceof SeparatedTableBorders)) {
                    float potentialWideCellBorder = null == rowBottomBorderIfLastOnPage.get(col) ? 0.0f : rowBottomBorderIfLastOnPage.get(col).getWidth();
                    this.bordersHandler.applyCellIndents(cellArea.getBBox(), cellIndents[0], cellIndents[1], potentialWideCellBorder + widestRowBottomBorderWidth, cellIndents[3], false);
                }
                cellWidth = cellArea.getBBox().getWidth();
                LayoutTaggingHelper taggingHelper2 = (LayoutTaggingHelper)this.getProperty(108);
                if (taggingHelper2 != null) {
                    taggingHelper2.addKidsHint(this, Collections.singletonList(cell));
                    LayoutTaggingHelper.addTreeHints(taggingHelper2, cell);
                }
                LayoutResult cellResult = cell.setParent(this).layout(new LayoutContext(cellArea, null, childFloatRendererAreas, wasHeightClipped || wasParentsHeightClipped));
                if (cellWidthProperty != null && cellWidthProperty.isPercentValue()) {
                    cell.setProperty(77, cellWidthProperty);
                    if (null != cellResult.getOverflowRenderer()) {
                        cellResult.getOverflowRenderer().setProperty(77, cellWidthProperty);
                    }
                }
                cell.setProperty(75, (Object)verticalAlignment);
                if (cellResult.getStatus() != 3) {
                    cell.getOccupiedArea().getBBox().setWidth(cellWidth);
                } else if (null == firstCauseOfNothing) {
                    firstCauseOfNothing = cellResult.getCauseOfNothing();
                }
                if (currentCellHasBigRowspan) {
                    if (cellResult.getStatus() != 1) {
                        splits[col] = cellResult;
                        if (cellResult.getStatus() != 3) {
                            splits[col].getOverflowRenderer().setProperty(75, (Object)VerticalAlignment.TOP);
                        }
                    }
                    if (cellResult.getStatus() == 2) {
                        currentRow[col] = (CellRenderer)cellResult.getSplitRenderer();
                    } else {
                        this.rows.get((int)currentCellInfo.finishRowInd)[col] = null;
                        currentRow[col] = cell;
                        rowMoves.put(col, currentCellInfo.finishRowInd);
                    }
                } else if (cellResult.getStatus() != 1) {
                    if (!split) {
                        int addCol;
                        boolean skipLastFooter;
                        boolean bl3 = skipLastFooter = null != this.footerRenderer && tableModel.isSkipLastFooter() && tableModel.isComplete() && !Boolean.TRUE.equals(this.getOwnProperty(26));
                        if (skipLastFooter) {
                            LayoutArea potentialArea = new LayoutArea(area.getPageNumber(), layoutBox.clone());
                            this.applySingleSpacing(potentialArea.getBBox(), horizontalBorderSpacing, true, true);
                            Border widestRowTopBorder = this.bordersHandler.getWidestHorizontalBorder(this.rowRange.getStartRow() + row);
                            if (this.bordersHandler instanceof CollapsedTableBorders && null != widestRowTopBorder) {
                                potentialArea.getBBox().increaseHeight(widestRowTopBorder.getWidth() / 2.0f);
                            }
                            if (null == this.headerRenderer) {
                                potentialArea.getBBox().increaseHeight(this.bordersHandler.getMaxTopWidth());
                            }
                            this.bordersHandler.applyLeftAndRightTableBorder(potentialArea.getBBox(), true);
                            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight();
                            potentialArea.getBBox().moveDown(footerHeight - verticalBorderSpacing / 2.0f).increaseHeight(footerHeight);
                            TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
                            overflowRenderer.rows = this.rows.subList(row, this.rows.size());
                            overflowRenderer.setProperty(97, true);
                            overflowRenderer.setProperty(96, true);
                            overflowRenderer.setProperty(46, UnitValue.createPointValue(0.0f));
                            overflowRenderer.setProperty(43, UnitValue.createPointValue(0.0f));
                            overflowRenderer.setProperty(44, UnitValue.createPointValue(0.0f));
                            overflowRenderer.setProperty(45, UnitValue.createPointValue(0.0f));
                            if (null != this.headerRenderer) {
                                overflowRenderer.setProperty(13, Border.NO_BORDER);
                            }
                            overflowRenderer.bordersHandler = this.bordersHandler;
                            this.bordersHandler.skipFooter(overflowRenderer.getBorders());
                            if (null != this.headerRenderer) {
                                this.bordersHandler.skipHeader(overflowRenderer.getBorders());
                            }
                            int savedStartRow = overflowRenderer.bordersHandler.startRow;
                            overflowRenderer.bordersHandler.setStartRow(row);
                            this.prepareFooterOrHeaderRendererForLayout(overflowRenderer, potentialArea.getBBox().getWidth());
                            LayoutResult res = overflowRenderer.layout(new LayoutContext(potentialArea, wasHeightClipped || wasParentsHeightClipped));
                            this.bordersHandler.setStartRow(savedStartRow);
                            if (1 == res.getStatus()) {
                                if (taggingHelper2 != null) {
                                    taggingHelper2.markArtifactHint(this.footerRenderer);
                                }
                                this.footerRenderer = null;
                                layoutBox.increaseHeight(footerHeight).moveDown(footerHeight);
                                this.deleteOwnProperty(10);
                                this.bordersHandler.setFinishRow(this.rowRange.getStartRow() + row);
                                widestRowBottomBorder = this.bordersHandler.getWidestHorizontalBorder(this.rowRange.getStartRow() + row + 1);
                                this.bordersHandler.setFinishRow(this.rowRange.getFinishRow());
                                widestRowBottomBorderWidth = null == widestRowBottomBorder ? 0.0f : widestRowBottomBorder.getWidth();
                                cellProcessingQueue.clear();
                                currChildRenderers.clear();
                                for (addCol = 0; addCol < currentRow.length; ++addCol) {
                                    if (currentRow[addCol] == null) continue;
                                    cellProcessingQueue.addLast(new CellRendererInfo(currentRow[addCol], addCol, row));
                                }
                                continue;
                            }
                            if (null != this.headerRenderer) {
                                this.bordersHandler.collapseTableWithHeader(this.headerRenderer.bordersHandler, false);
                            }
                            this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, false);
                            this.bordersHandler.tableBoundingBorders[2] = Border.NO_BORDER;
                        }
                        block7: for (addCol = 0; addCol < currentRow.length; ++addCol) {
                            if (currentRow[addCol] != null) continue;
                            for (int addRow = row + 1; addRow < this.rows.size(); ++addRow) {
                                if (this.rows.get(addRow)[addCol] == null) continue;
                                CellRenderer addRenderer = this.rows.get(addRow)[addCol];
                                if (row + addRenderer.getPropertyAsInteger(60) - 1 < addRow) continue block7;
                                cellProcessingQueue.addLast(new CellRendererInfo(addRenderer, addCol, addRow));
                                continue block7;
                            }
                        }
                    }
                    split = true;
                    splits[col] = cellResult;
                    if (cellResult.getStatus() == 3) {
                        hasContent = false;
                        splits[col].getOverflowRenderer().setProperty(75, (Object)verticalAlignment);
                    }
                }
                currChildRenderers.add(cell);
                if (cellResult.getStatus() == 3) continue;
                rowHeight = Math.max(rowHeight, cellResult.getOccupiedArea().getBBox().getHeight() + this.bordersHandler.getCellVerticalAddition(cellIndents) - rowspanOffset);
            }
            if (hasContent) {
                this.heights.add(Float.valueOf(rowHeight));
                rowsHasCellWithSetHeight.add(rowHasCellWithSetHeight);
                this.occupiedArea.getBBox().moveDown(rowHeight);
                this.occupiedArea.getBBox().increaseHeight(rowHeight);
                layoutBox.decreaseHeight(rowHeight);
            }
            if (split || row == this.rows.size() - 1) {
                this.bordersHandler.setFinishRow(this.bordersHandler.getStartRow() + row);
                if (!hasContent && this.bordersHandler.getFinishRow() != this.bordersHandler.getStartRow()) {
                    this.bordersHandler.setFinishRow(this.bordersHandler.getFinishRow() - 1);
                }
                boolean skip = false;
                if (null != this.footerRenderer && tableModel.isComplete() && tableModel.isSkipLastFooter() && !split && !Boolean.TRUE.equals(this.getOwnProperty(26))) {
                    LayoutTaggingHelper taggingHelper3 = (LayoutTaggingHelper)this.getProperty(108);
                    if (taggingHelper3 != null) {
                        taggingHelper3.markArtifactHint(this.footerRenderer);
                    }
                    this.footerRenderer = null;
                    if (tableModel.isEmpty()) {
                        this.deleteOwnProperty(13);
                    }
                    skip = true;
                }
                this.correctLayoutedCellsOccupiedAreas(splits, row, targetOverflowRowIndex, blockMinHeight, layoutBox, rowsHasCellWithSetHeight, !split, !hasContent && cellWithBigRowspanAdded, skip);
            }
            if ((split || row == this.rows.size() - 1) && null != this.footerRenderer) {
                if (!hasContent && this.childRenderers.size() == 0) {
                    this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, true);
                } else {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, tableModel.isEmpty(), false, true);
                }
                if (!(this.bordersHandler instanceof SeparatedTableBorders)) {
                    layoutBox.moveDown(this.footerRenderer.occupiedArea.getBBox().getHeight()).increaseHeight(this.footerRenderer.occupiedArea.getBBox().getHeight());
                    this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, true);
                    this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
                    if (this.bordersHandler instanceof CollapsedTableBorders) {
                        ((CollapsedTableBorders)this.bordersHandler).setBottomBorderCollapseWith(null, null);
                    }
                    this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, hasContent || 0 != this.childRenderers.size());
                    if (this.bordersHandler instanceof CollapsedTableBorders) {
                        this.footerRenderer.setBorders(CollapsedTableBorders.getCollapsedBorder(this.footerRenderer.getBorders()[2], this.getBorders()[2]), 2);
                    }
                    this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
                    this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, false);
                    float footerHeight = this.footerRenderer.getOccupiedAreaBBox().getHeight();
                    this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
                    layoutBox.setY(this.footerRenderer.occupiedArea.getBBox().getTop()).setHeight(this.occupiedArea.getBBox().getBottom() - layoutBox.getBottom());
                }
            }
            if (!split) {
                this.childRenderers.addAll(currChildRenderers);
                currChildRenderers.clear();
            }
            if (split && this.footerRenderer != null && (taggingHelper = (LayoutTaggingHelper)this.getProperty(108)) != null) {
                taggingHelper.markArtifactHint(this.footerRenderer);
            }
            if (!split) continue;
            if (marginsCollapsingEnabled) {
                marginsCollapseHandler.endMarginsCollapse(layoutBox);
            }
            TableRenderer[] splitResult = this.split(row, hasContent, cellWithBigRowspanAdded);
            OverflowRowsWrapper overflowRows = new OverflowRowsWrapper(splitResult[1]);
            if (null != this.headerRenderer || null != this.footerRenderer) {
                if (null != this.headerRenderer || tableModel.isEmpty()) {
                    splitResult[1].deleteOwnProperty(13);
                }
                if (null != this.footerRenderer || tableModel.isEmpty()) {
                    splitResult[1].deleteOwnProperty(10);
                }
            }
            int[] rowspans = new int[currentRow.length];
            boolean[] columnsWithCellToBeEnlarged = new boolean[currentRow.length];
            for (col = 0; col < currentRow.length; ++col) {
                boolean isBigRowspannedCell;
                if (splits[col] != null) {
                    CellRenderer cellSplit = (CellRenderer)splits[col].getSplitRenderer();
                    if (null != cellSplit) {
                        rowspans[col] = ((Cell)cellSplit.getModelElement()).getRowspan();
                    }
                    if (splits[col].getStatus() != 3 && (hasContent || cellWithBigRowspanAdded)) {
                        this.childRenderers.add(cellSplit);
                    }
                    LayoutArea cellOccupiedArea = currentRow[col].getOccupiedArea();
                    if (hasContent || cellWithBigRowspanAdded || splits[col].getStatus() == 3) {
                        CellRenderer cellOverflow = (CellRenderer)splits[col].getOverflowRenderer();
                        CellRenderer originalCell = currentRow[col];
                        currentRow[col] = null;
                        this.rows.get((int)targetOverflowRowIndex[col])[col] = originalCell;
                        overflowRows.setCell(0, col, null);
                        overflowRows.setCell(targetOverflowRowIndex[col] - row, col, cellOverflow);
                    } else {
                        overflowRows.setCell(targetOverflowRowIndex[col] - row, col, currentRow[col]);
                    }
                    overflowRows.getCell((int)(targetOverflowRowIndex[col] - row), (int)col).occupiedArea = cellOccupiedArea;
                    continue;
                }
                if (currentRow[col] == null) continue;
                if (hasContent) {
                    rowspans[col] = ((Cell)currentRow[col].getModelElement()).getRowspan();
                }
                boolean bl4 = isBigRowspannedCell = 1 != ((Cell)currentRow[col].getModelElement()).getRowspan();
                if (!hasContent && !isBigRowspannedCell) continue;
                columnsWithCellToBeEnlarged[col] = true;
            }
            int minRowspan = Integer.MAX_VALUE;
            for (col = 0; col < rowspans.length; ++col) {
                if (0 == rowspans[col]) continue;
                minRowspan = Math.min(minRowspan, rowspans[col]);
            }
            for (col = 0; col < numberOfColumns; ++col) {
                if (!columnsWithCellToBeEnlarged[col]) continue;
                this.enlargeCell(col, row, minRowspan, currentRow, overflowRows, targetOverflowRowIndex, splitResult);
            }
            this.applySpacing(layoutBox, horizontalBorderSpacing, verticalBorderSpacing, true);
            this.applySingleSpacing(this.occupiedArea.getBBox(), horizontalBorderSpacing, true, true);
            if (null != this.footerRenderer) {
                layoutBox.moveUp(verticalBorderSpacing).decreaseHeight(verticalBorderSpacing);
            }
            if (null != this.headerRenderer || !tableModel.isEmpty()) {
                layoutBox.decreaseHeight(verticalBorderSpacing);
            }
            if (0 == row && !hasContent && null == this.headerRenderer) {
                this.occupiedArea.getBBox().moveUp(verticalBorderSpacing / 2.0f);
            } else {
                this.applySingleSpacing(this.occupiedArea.getBBox(), verticalBorderSpacing, false, true);
            }
            if (!isAndWasComplete && null != this.footerRenderer && 0 == splitResult[0].rows.size()) {
                layoutBox.increaseHeight(verticalBorderSpacing);
            }
            if (null == this.footerRenderer) {
                if (!splitResult[0].rows.isEmpty() || currChildRenderers.size() == this.childRenderers.size()) {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, false);
                } else {
                    this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, true);
                    if (!isAndWasComplete && !isFirstOnThePage) {
                        this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                    }
                }
            }
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86)) || Boolean.TRUE.equals(this.getPropertyAsBoolean(87))) {
                this.extendLastRow(splitResult[1].rows.get(0), layoutBox);
            }
            this.adjustFooterAndFixOccupiedArea(layoutBox, 0 != this.heights.size() ? verticalBorderSpacing : 0.0f);
            this.adjustCaptionAndFixOccupiedArea(layoutBox, 0 != this.heights.size() ? verticalBorderSpacing : 0.0f);
            for (Map.Entry entry : rowMoves.entrySet()) {
                if (null != splitResult[1].rows.get((Integer)entry.getValue() - splitResult[0].rows.size())[(Integer)entry.getKey()]) continue;
                CellRenderer originalCellRenderer = this.rows.get(row)[(Integer)entry.getKey()];
                CellRenderer overflowCellRenderer = splitResult[1].rows.get(row - splitResult[0].rows.size())[(Integer)entry.getKey()];
                this.rows.get((int)((Integer)entry.getValue()).intValue())[((Integer)entry.getKey()).intValue()] = originalCellRenderer;
                this.rows.get((int)row)[((Integer)entry.getKey()).intValue()] = null;
                overflowRows.setCell((Integer)entry.getValue() - splitResult[0].rows.size(), (Integer)entry.getKey(), overflowCellRenderer);
                overflowRows.setCell(row - splitResult[0].rows.size(), (Integer)entry.getKey(), null);
            }
            if (this.isKeepTogether(firstCauseOfNothing) && 0 == lastFlushedRowBottomBorder.size() && !Boolean.TRUE.equals(this.getPropertyAsBoolean(26))) {
                return new LayoutResult(3, null, null, this, null == firstCauseOfNothing ? this : firstCauseOfNothing);
            }
            float footerHeight = null == this.footerRenderer ? 0.0f : this.footerRenderer.getOccupiedArea().getBBox().getHeight();
            float headerHeight = null == this.headerRenderer ? 0.0f : this.headerRenderer.getOccupiedArea().getBBox().getHeight() - this.headerRenderer.bordersHandler.getMaxBottomWidth();
            float captionHeight = null == this.captionRenderer ? 0.0f : this.captionRenderer.getOccupiedArea().getBBox().getHeight();
            float heightDiff = this.occupiedArea.getBBox().getHeight() - footerHeight - headerHeight - captionHeight;
            int n = status = Float.compare(0.0f, heightDiff) == 0 && (isAndWasComplete || isFirstOnThePage) ? 3 : 2;
            if (status == 3 && Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) || wasHeightClipped) {
                if (wasHeightClipped) {
                    Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                    logger.warn("Element content was clipped because some height properties are set.");
                    if (status == 3) {
                        this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                        this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                    }
                    if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
                        float blockBottom = Math.max(this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()), layoutBox.getBottom());
                        if (0 == this.heights.size()) {
                            this.heights.add(Float.valueOf(blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight() / 2.0f));
                        } else {
                            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()));
                        }
                        this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - blockBottom).setY(blockBottom);
                    }
                }
                this.applyFixedXOrYPosition(false, layoutBox);
                this.applyPaddings(this.occupiedArea.getBBox(), true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
                editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, siblingFloatRendererAreas, layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
                return new LayoutResult(1, editedArea, splitResult[0], null);
            }
            this.updateHeightsOnSplit(false, splitResult[0], splitResult[1]);
            this.applyFixedXOrYPosition(false, layoutBox);
            this.applyPaddings(this.occupiedArea.getBBox(), true);
            this.applyMargins(this.occupiedArea.getBBox(), true);
            editedArea = null;
            if (status != 3) {
                editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, siblingFloatRendererAreas, layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
            }
            return new LayoutResult(status, editedArea, splitResult[0], splitResult[1], null == firstCauseOfNothing ? this : firstCauseOfNothing);
        }
        if (tableModel.isComplete() && !tableModel.isEmpty()) {
            int lastInRow;
            CellRenderer[] lastRow = this.rows.get(this.rows.size() - 1);
            for (lastInRow = lastRow.length - 1; lastInRow >= 0 && null == lastRow[lastInRow]; --lastInRow) {
            }
            if (lastInRow < 0 || lastRow.length != lastInRow + lastRow[lastInRow].getPropertyAsInteger(16)) {
                Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                logger.warn("Last row is not completed. Table bottom border may collapse as you do not expect it");
            }
        }
        if (!(this.bordersHandler instanceof SeparatedTableBorders) && tableModel.isComplete() && (0 != lastFlushedRowBottomBorder.size() || tableModel.isEmpty()) && null != this.footerRenderer) {
            layoutBox.moveDown(this.footerRenderer.occupiedArea.getBBox().getHeight()).increaseHeight(this.footerRenderer.occupiedArea.getBBox().getHeight());
            this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, true);
            this.prepareFooterOrHeaderRendererForLayout(this.footerRenderer, layoutBox.getWidth());
            if (0 != this.rows.size() || !isAndWasComplete) {
                this.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, true);
            } else if (null != this.headerRenderer) {
                this.headerRenderer.bordersHandler.collapseTableWithFooter(this.footerRenderer.bordersHandler, true);
            }
            this.footerRenderer.layout(new LayoutContext(new LayoutArea(area.getPageNumber(), layoutBox), wasHeightClipped || wasParentsHeightClipped));
            this.bordersHandler.applyLeftAndRightTableBorder(layoutBox, false);
            float footerHeight = this.footerRenderer.getOccupiedAreaBBox().getHeight();
            this.footerRenderer.move(0.0f, -(layoutBox.getHeight() - footerHeight));
            layoutBox.moveUp(footerHeight).decreaseHeight(footerHeight);
        }
        this.applySpacing(layoutBox, horizontalBorderSpacing, verticalBorderSpacing, true);
        this.applySingleSpacing(this.occupiedArea.getBBox(), horizontalBorderSpacing, true, true);
        if (null != this.footerRenderer) {
            layoutBox.moveUp(verticalBorderSpacing).decreaseHeight(verticalBorderSpacing);
        }
        if (null != this.headerRenderer || !tableModel.isEmpty()) {
            layoutBox.decreaseHeight(verticalBorderSpacing);
        }
        if (tableModel.isEmpty() && null == this.headerRenderer) {
            this.occupiedArea.getBBox().moveUp(verticalBorderSpacing / 2.0f);
        } else if (isAndWasComplete || 0 != this.rows.size()) {
            this.applySingleSpacing(this.occupiedArea.getBBox(), verticalBorderSpacing, false, true);
        }
        float bottomTableBorderWidth = this.bordersHandler.getMaxBottomWidth();
        if (tableModel.isComplete()) {
            if (null == this.footerRenderer) {
                if (0 != this.childRenderers.size()) {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, false);
                } else if (0 != lastFlushedRowBottomBorder.size()) {
                    this.bordersHandler.applyTopTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                } else {
                    this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), true, false);
                }
            } else if (tableModel.isEmpty() && null != this.headerRenderer) {
                float headerBottomBorderWidth = this.headerRenderer.bordersHandler.getMaxBottomWidth();
                this.headerRenderer.bordersHandler.applyBottomTableBorder(this.headerRenderer.occupiedArea.getBBox(), layoutBox, true, true, true);
                this.occupiedArea.getBBox().moveUp(headerBottomBorderWidth).decreaseHeight(headerBottomBorderWidth);
            }
        } else if (null == this.footerRenderer) {
            if (0 != this.childRenderers.size()) {
                this.bordersHandler.applyBottomTableBorder(this.occupiedArea.getBBox(), layoutBox, 0 == this.childRenderers.size(), false, true);
            }
        } else {
            layoutBox.increaseHeight(bottomTableBorderWidth);
        }
        if (0 != this.rows.size()) {
            if (Boolean.TRUE.equals(this.getPropertyAsBoolean(86))) {
                this.extendLastRow(this.rows.get(this.rows.size() - 1), layoutBox);
            }
        } else if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight()) {
            float blockBottom = Math.max(this.occupiedArea.getBBox().getBottom() - (blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight()), layoutBox.getBottom());
            if (0 != this.heights.size()) {
                this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + this.occupiedArea.getBBox().getBottom() - blockBottom));
            } else {
                this.heights.add(Float.valueOf(this.occupiedArea.getBBox().getBottom() - blockBottom + this.occupiedArea.getBBox().getHeight() / 2.0f));
            }
            this.occupiedArea.getBBox().increaseHeight(this.occupiedArea.getBBox().getBottom() - blockBottom).setY(blockBottom);
        }
        this.applyFixedXOrYPosition(false, layoutBox);
        if (marginsCollapsingEnabled) {
            marginsCollapseHandler.endMarginsCollapse(layoutBox);
        }
        this.applyPaddings(this.occupiedArea.getBBox(), true);
        this.applyMargins(this.occupiedArea.getBBox(), true);
        if (!tableModel.isComplete() && null != this.footerRenderer) {
            LayoutTaggingHelper taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
            if (taggingHelper != null) {
                taggingHelper.markArtifactHint(this.footerRenderer);
            }
            this.footerRenderer = null;
            this.bordersHandler.skipFooter(this.bordersHandler.tableBoundingBorders);
        }
        this.adjustFooterAndFixOccupiedArea(layoutBox, null != this.headerRenderer || !tableModel.isEmpty() ? verticalBorderSpacing : 0.0f);
        this.adjustCaptionAndFixOccupiedArea(layoutBox, null != this.headerRenderer || !tableModel.isEmpty() ? verticalBorderSpacing : 0.0f);
        FloatingHelper.removeFloatsAboveRendererBottom(siblingFloatRendererAreas, this);
        if (!isAndWasComplete && !isFirstOnThePage && (0 != this.rows.size() || null != this.footerRenderer && tableModel.isComplete())) {
            this.occupiedArea.getBBox().decreaseHeight(verticalBorderSpacing);
        }
        LayoutArea editedArea = FloatingHelper.adjustResultOccupiedAreaForFloatAndClear(this, siblingFloatRendererAreas, layoutContext.getArea().getBBox(), clearHeightCorrection, marginsCollapsingEnabled);
        return new LayoutResult(1, editedArea, null, null, null);
    }

    @Override
    public void draw(DrawContext drawContext) {
        boolean isTagged = drawContext.isTaggingEnabled();
        LayoutTaggingHelper taggingHelper = null;
        if (isTagged) {
            taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
            if (taggingHelper == null) {
                isTagged = false;
            } else {
                TagTreePointer tagPointer = taggingHelper.useAutoTaggingPointerAndRememberItsPosition(this);
                if (taggingHelper.createTag(this, tagPointer)) {
                    tagPointer.getProperties().addAttributes(0, AccessibleAttributesApplier.getLayoutAttributes(this, tagPointer));
                }
            }
        }
        this.beginTransformationIfApplied(drawContext.getCanvas());
        this.applyDestinationsAndAnnotation(drawContext);
        boolean relativePosition = this.isRelativePosition();
        if (relativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.beginElementOpacityApplying(drawContext);
        float captionHeight = null != this.captionRenderer ? this.captionRenderer.getOccupiedArea().getBBox().getHeight() : 0.0f;
        boolean isBottomCaption = CaptionSide.BOTTOM.equals(0.0f != captionHeight ? this.captionRenderer.getProperty(119) : null);
        if (0.0f != captionHeight) {
            this.occupiedArea.getBBox().applyMargins(isBottomCaption ? 0.0f : captionHeight, 0.0f, isBottomCaption ? captionHeight : 0.0f, 0.0f, false);
        }
        this.drawBackground(drawContext);
        if (this.bordersHandler instanceof SeparatedTableBorders && !this.isHeaderRenderer() && !this.isFooterRenderer()) {
            this.drawBorder(drawContext);
        }
        this.drawChildren(drawContext);
        this.drawPositionedChildren(drawContext);
        if (0.0f != captionHeight) {
            this.occupiedArea.getBBox().applyMargins(isBottomCaption ? 0.0f : captionHeight, 0.0f, isBottomCaption ? captionHeight : 0.0f, 0.0f, true);
        }
        this.drawCaption(drawContext);
        this.endElementOpacityApplying(drawContext);
        if (relativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        this.flushed = true;
        this.endTransformationIfApplied(drawContext.getCanvas());
        if (isTagged) {
            if (this.isLastRendererForModelElement && ((Table)this.getModelElement()).isComplete()) {
                taggingHelper.finishTaggingHint(this);
            }
            taggingHelper.restoreAutoTaggingPointerPosition(this);
        }
    }

    @Override
    public void drawChildren(DrawContext drawContext) {
        if (this.headerRenderer != null) {
            this.headerRenderer.draw(drawContext);
        }
        for (IRenderer child : this.childRenderers) {
            child.draw(drawContext);
        }
        if (this.bordersHandler instanceof CollapsedTableBorders) {
            this.drawBorders(drawContext);
        }
        if (this.footerRenderer != null) {
            this.footerRenderer.draw(drawContext);
        }
    }

    protected void drawBackgrounds(DrawContext drawContext) {
        boolean shrinkBackgroundArea;
        boolean bl = shrinkBackgroundArea = this.bordersHandler instanceof CollapsedTableBorders && (this.isHeaderRenderer() || this.isFooterRenderer());
        if (shrinkBackgroundArea) {
            this.occupiedArea.getBBox().applyMargins(this.bordersHandler.getMaxTopWidth() / 2.0f, this.bordersHandler.getRightBorderMaxWidth() / 2.0f, this.bordersHandler.getMaxBottomWidth() / 2.0f, this.bordersHandler.getLeftBorderMaxWidth() / 2.0f, false);
        }
        super.drawBackground(drawContext);
        if (shrinkBackgroundArea) {
            this.occupiedArea.getBBox().applyMargins(this.bordersHandler.getMaxTopWidth() / 2.0f, this.bordersHandler.getRightBorderMaxWidth() / 2.0f, this.bordersHandler.getMaxBottomWidth() / 2.0f, this.bordersHandler.getLeftBorderMaxWidth() / 2.0f, true);
        }
        if (null != this.headerRenderer) {
            this.headerRenderer.drawBackgrounds(drawContext);
        }
        if (null != this.footerRenderer) {
            this.footerRenderer.drawBackgrounds(drawContext);
        }
    }

    protected void drawCaption(DrawContext drawContext) {
        if (null != this.captionRenderer && !this.isFooterRenderer() && !this.isHeaderRenderer()) {
            this.captionRenderer.draw(drawContext);
        }
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
        if (!this.isFooterRenderer() && !this.isHeaderRenderer()) {
            this.drawBackgrounds(drawContext);
        }
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(TableRenderer.class, this.getClass());
        TableRenderer nextTable = new TableRenderer();
        nextTable.modelElement = this.modelElement;
        return nextTable;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        super.move(dxRight, dyUp);
        if (this.headerRenderer != null) {
            this.headerRenderer.move(dxRight, dyUp);
        }
        if (this.footerRenderer != null) {
            this.footerRenderer.move(dxRight, dyUp);
        }
    }

    protected TableRenderer[] split(int row) {
        return this.split(row, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent) {
        return this.split(row, hasContent, false);
    }

    protected TableRenderer[] split(int row, boolean hasContent, boolean cellWithBigRowspanAdded) {
        TableRenderer splitRenderer = this.createSplitRenderer(new Table.RowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + row));
        splitRenderer.rows = this.rows.subList(0, row);
        splitRenderer.bordersHandler = this.bordersHandler;
        splitRenderer.heights = this.heights;
        splitRenderer.columnWidths = this.columnWidths;
        splitRenderer.countedColumnWidth = this.countedColumnWidth;
        splitRenderer.totalWidthForColumns = this.totalWidthForColumns;
        splitRenderer.occupiedArea = this.occupiedArea;
        TableRenderer overflowRenderer = this.createOverflowRenderer(new Table.RowRange(this.rowRange.getStartRow() + row, this.rowRange.getFinishRow()));
        if (0 == row && !hasContent && !cellWithBigRowspanAdded && 0 == this.rowRange.getStartRow()) {
            overflowRenderer.isOriginalNonSplitRenderer = this.isOriginalNonSplitRenderer;
        }
        overflowRenderer.rows = this.rows.subList(row, this.rows.size());
        overflowRenderer.bordersHandler = this.bordersHandler;
        return new TableRenderer[]{splitRenderer, overflowRenderer};
    }

    protected TableRenderer createSplitRenderer(Table.RowRange rowRange) {
        TableRenderer splitRenderer = (TableRenderer)this.getNextRenderer();
        splitRenderer.rowRange = rowRange;
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.childRenderers = this.childRenderers;
        splitRenderer.addAllProperties(this.getOwnProperties());
        splitRenderer.headerRenderer = this.headerRenderer;
        splitRenderer.footerRenderer = this.footerRenderer;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.topBorderMaxWidth = this.topBorderMaxWidth;
        splitRenderer.captionRenderer = this.captionRenderer;
        splitRenderer.isOriginalNonSplitRenderer = this.isOriginalNonSplitRenderer;
        return splitRenderer;
    }

    protected TableRenderer createOverflowRenderer(Table.RowRange rowRange) {
        TableRenderer overflowRenderer = (TableRenderer)this.getNextRenderer();
        overflowRenderer.setRowRange(rowRange);
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        overflowRenderer.isOriginalNonSplitRenderer = false;
        overflowRenderer.countedColumnWidth = this.countedColumnWidth;
        return overflowRenderer;
    }

    @Override
    protected Float retrieveWidth(float parentBoxWidth) {
        Float tableWidth = super.retrieveWidth(parentBoxWidth);
        Table tableModel = (Table)this.getModelElement();
        if (tableWidth == null || tableWidth.floatValue() == 0.0f) {
            float totalColumnWidthInPercent = 0.0f;
            for (int col = 0; col < tableModel.getNumberOfColumns(); ++col) {
                UnitValue columnWidth = tableModel.getColumnWidth(col);
                if (!columnWidth.isPercentValue()) continue;
                totalColumnWidthInPercent += columnWidth.getValue();
            }
            tableWidth = Float.valueOf(parentBoxWidth);
            if (totalColumnWidthInPercent > 0.0f) {
                tableWidth = Float.valueOf(parentBoxWidth * totalColumnWidthInPercent / 100.0f);
            }
        }
        return tableWidth;
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        UnitValue marginLefttUV;
        float[] columns;
        if (this.isOriginalNonSplitRenderer) {
            this.initializeTableLayoutBorders();
        }
        float rightMaxBorder = this.bordersHandler.getRightBorderMaxWidth();
        float leftMaxBorder = this.bordersHandler.getLeftBorderMaxWidth();
        TableWidths tableWidths = new TableWidths(this, MinMaxWidthUtils.getInfWidth(), true, rightMaxBorder, leftMaxBorder);
        float maxColTotalWidth = 0.0f;
        for (float column : columns = this.isOriginalNonSplitRenderer ? tableWidths.layout() : this.countedColumnWidth) {
            maxColTotalWidth += column;
        }
        float minWidth = this.isOriginalNonSplitRenderer ? tableWidths.getMinWidth() : maxColTotalWidth;
        UnitValue marginRightUV = this.getPropertyAsUnitValue(45);
        if (!marginRightUV.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{45}));
        }
        if (!(marginLefttUV = this.getPropertyAsUnitValue(44)).isPointValue()) {
            Logger logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
        }
        float additionalWidth = marginLefttUV.getValue() + marginRightUV.getValue() + rightMaxBorder / 2.0f + leftMaxBorder / 2.0f;
        return new MinMaxWidth(minWidth, maxColTotalWidth, additionalWidth);
    }

    @Override
    protected boolean allowLastYLineRecursiveExtraction() {
        return false;
    }

    private void initializeTableLayoutBorders() {
        boolean isSeparated = BorderCollapsePropertyValue.SEPARATE.equals(this.getProperty(114));
        this.bordersHandler = isSeparated ? new SeparatedTableBorders(this.rows, ((Table)this.getModelElement()).getNumberOfColumns(), this.getBorders()) : new CollapsedTableBorders(this.rows, ((Table)this.getModelElement()).getNumberOfColumns(), this.getBorders());
        this.bordersHandler.initializeBorders();
        this.bordersHandler.setTableBoundingBorders(this.getBorders());
        this.bordersHandler.setRowRange(this.rowRange.getStartRow(), this.rowRange.getFinishRow());
        this.initializeHeaderAndFooter(true);
        this.bordersHandler.updateBordersOnNewPage(this.isOriginalNonSplitRenderer, this.isFooterRenderer() || this.isHeaderRenderer(), this, this.headerRenderer, this.footerRenderer);
        this.correctRowRange();
    }

    private void correctRowRange() {
        if (this.rows.size() < this.rowRange.getFinishRow() - this.rowRange.getStartRow() + 1) {
            this.rowRange = new Table.RowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + this.rows.size() - 1);
        }
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            super.drawBorder(drawContext);
        }
    }

    protected void drawBorders(DrawContext drawContext) {
        this.drawBorders(drawContext, null != this.headerRenderer, null != this.footerRenderer);
    }

    private void drawBorders(DrawContext drawContext, boolean hasHeader, boolean hasFooter) {
        int i;
        boolean shouldDrawTopBorder;
        boolean isTagged;
        Logger logger;
        float height = this.occupiedArea.getBBox().getHeight();
        if (null != this.footerRenderer) {
            height -= this.footerRenderer.occupiedArea.getBBox().getHeight();
        }
        if (null != this.headerRenderer) {
            height -= this.headerRenderer.occupiedArea.getBBox().getHeight();
        }
        if (height < 1.0E-4f) {
            return;
        }
        float startX = this.getOccupiedArea().getBBox().getX() + this.bordersHandler.getLeftBorderMaxWidth() / 2.0f;
        float startY = this.getOccupiedArea().getBBox().getY() + this.getOccupiedArea().getBBox().getHeight();
        if (null != this.headerRenderer) {
            startY -= this.headerRenderer.occupiedArea.getBBox().getHeight();
            startY += this.topBorderMaxWidth / 2.0f;
        } else {
            startY -= this.topBorderMaxWidth / 2.0f;
        }
        if (this.hasProperty(46)) {
            UnitValue topMargin = this.getPropertyAsUnitValue(46);
            if (null != topMargin && !topMargin.isPointValue()) {
                logger = LoggerFactory.getLogger(TableRenderer.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
            }
            startY -= null == topMargin ? 0.0f : topMargin.getValue();
        }
        if (this.hasProperty(44)) {
            UnitValue leftMargin = this.getPropertyAsUnitValue(44);
            if (null != leftMargin && !leftMargin.isPointValue()) {
                logger = LoggerFactory.getLogger(TableRenderer.class);
                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
            }
            startX += null == leftMargin ? 0.0f : leftMargin.getValue();
        }
        if (this.childRenderers.size() == 0) {
            Border[] borders = this.bordersHandler.tableBoundingBorders;
            if (null != borders[0]) {
                if (null != borders[2] && 0 == this.heights.size()) {
                    this.heights.add(0, Float.valueOf(borders[0].getWidth() / 2.0f + borders[2].getWidth() / 2.0f));
                }
            } else if (null != borders[2]) {
                startY -= borders[2].getWidth() / 2.0f;
            }
            if (0 == this.heights.size()) {
                this.heights.add(Float.valueOf(0.0f));
            }
        }
        if (isTagged = drawContext.isTaggingEnabled()) {
            drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
        }
        boolean isTopTablePart = this.isTopTablePart();
        boolean isBottomTablePart = this.isBottomTablePart();
        boolean isComplete = this.getTable().isComplete();
        boolean isFooterRendererOfLargeTable = this.isFooterRendererOfLargeTable();
        this.bordersHandler.setRowRange(this.rowRange.getStartRow(), this.rowRange.getStartRow() + this.heights.size() - 1);
        if (this.bordersHandler instanceof CollapsedTableBorders) {
            if (hasFooter) {
                ((CollapsedTableBorders)this.bordersHandler).setBottomBorderCollapseWith(this.footerRenderer.bordersHandler.getFirstHorizontalBorder(), ((CollapsedTableBorders)this.footerRenderer.bordersHandler).getVerticalBordersCrossingTopHorizontalBorder());
            } else if (isBottomTablePart) {
                ((CollapsedTableBorders)this.bordersHandler).setBottomBorderCollapseWith(null, null);
            }
        }
        float y1 = startY;
        float[] heightsArray = new float[this.heights.size()];
        for (int j = 0; j < this.heights.size(); ++j) {
            heightsArray[j] = this.heights.get(j).floatValue();
        }
        float x1 = startX;
        for (int i2 = 0; i2 <= this.bordersHandler.getNumberOfColumns(); ++i2) {
            this.bordersHandler.drawVerticalBorder(drawContext.getCanvas(), new TableBorderDescriptor(i2, startY, x1, heightsArray));
            if (i2 >= this.countedColumnWidth.length) continue;
            x1 += this.countedColumnWidth[i2];
        }
        boolean bl = shouldDrawTopBorder = isFooterRendererOfLargeTable || isTopTablePart;
        if (!this.heights.isEmpty() && !shouldDrawTopBorder) {
            y1 -= this.heights.get(0).floatValue();
        }
        int n = i = shouldDrawTopBorder ? 0 : 1;
        while (i < this.heights.size()) {
            this.bordersHandler.drawHorizontalBorder(drawContext.getCanvas(), new TableBorderDescriptor(i, startX, y1, this.countedColumnWidth));
            y1 -= this.heights.get(i).floatValue();
            ++i;
        }
        if (!isBottomTablePart && isComplete || isBottomTablePart && (isComplete || !this.isLastRendererForModelElement && !this.isEmptyTableRenderer())) {
            this.bordersHandler.drawHorizontalBorder(drawContext.getCanvas(), new TableBorderDescriptor(this.heights.size(), startX, y1, this.countedColumnWidth));
        }
        if (isTagged) {
            drawContext.getCanvas().closeTag();
        }
    }

    private boolean isEmptyTableRenderer() {
        return this.rows.isEmpty() && this.heights.size() == 1 && this.heights.get(0).floatValue() == 0.0f;
    }

    private void applyFixedXOrYPosition(boolean isXPosition, Rectangle layoutBox) {
        if (this.isPositioned() && this.isFixedLayout()) {
            if (isXPosition) {
                float x = this.getPropertyAsFloat(34).floatValue();
                layoutBox.setX(x);
            } else {
                float y = this.getPropertyAsFloat(14).floatValue();
                this.move(0.0f, y - this.occupiedArea.getBBox().getY());
            }
        }
    }

    private void adjustFooterAndFixOccupiedArea(Rectangle layoutBox, float verticalBorderSpacing) {
        if (this.footerRenderer != null) {
            this.footerRenderer.move(0.0f, layoutBox.getHeight() + verticalBorderSpacing);
            float footerHeight = this.footerRenderer.getOccupiedArea().getBBox().getHeight() - verticalBorderSpacing;
            this.occupiedArea.getBBox().moveDown(footerHeight).increaseHeight(footerHeight);
        }
    }

    private void adjustCaptionAndFixOccupiedArea(Rectangle layoutBox, float verticalBorderSpacing) {
        if (this.captionRenderer != null) {
            float captionHeight = this.captionRenderer.getOccupiedArea().getBBox().getHeight();
            this.occupiedArea.getBBox().moveDown(captionHeight).increaseHeight(captionHeight);
            if (CaptionSide.BOTTOM.equals(this.captionRenderer.getProperty(119))) {
                this.captionRenderer.move(0.0f, layoutBox.getHeight() + verticalBorderSpacing);
            } else {
                this.occupiedArea.getBBox().moveUp(captionHeight);
            }
        }
    }

    private void correctLayoutedCellsOccupiedAreas(LayoutResult[] splits, int row, int[] targetOverflowRowIndex, Float blockMinHeight, Rectangle layoutBox, List<Boolean> rowsHasCellWithSetHeight, boolean isLastRenderer, boolean processBigRowspan, boolean skip) {
        float realBottomIndent;
        int finish = this.bordersHandler.getFinishRow();
        this.bordersHandler.setFinishRow(this.rowRange.getFinishRow());
        Border currentBorder = this.bordersHandler.getWidestHorizontalBorder(finish + 1);
        this.bordersHandler.setFinishRow(finish);
        if (skip) {
            this.bordersHandler.tableBoundingBorders[2] = this.getBorders()[2];
            this.bordersHandler.skipFooter(this.bordersHandler.tableBoundingBorders);
        }
        float currentBottomIndent = this.bordersHandler instanceof CollapsedTableBorders ? (null == currentBorder ? 0.0f : currentBorder.getWidth()) : 0.0f;
        float f = realBottomIndent = this.bordersHandler instanceof CollapsedTableBorders ? this.bordersHandler.getMaxBottomWidth() : 0.0f;
        if (0 != this.heights.size()) {
            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + (realBottomIndent - currentBottomIndent) / 2.0f));
            this.occupiedArea.getBBox().increaseHeight((realBottomIndent - currentBottomIndent) / 2.0f).moveDown((realBottomIndent - currentBottomIndent) / 2.0f);
            layoutBox.decreaseHeight((realBottomIndent - currentBottomIndent) / 2.0f);
            if (processBigRowspan) {
                CellRenderer[] currentRow = this.rows.get(this.heights.size());
                for (int col = 0; col < currentRow.length; ++col) {
                    CellRenderer cell;
                    CellRenderer cellRenderer = cell = null == splits[col] ? currentRow[col] : (CellRenderer)splits[col].getSplitRenderer();
                    if (cell == null) continue;
                    float height = 0.0f;
                    int rowspan = cell.getPropertyAsInteger(60);
                    int colspan = cell.getPropertyAsInteger(16);
                    for (int l = this.heights.size() - 1 - 1; l > targetOverflowRowIndex[col] - rowspan && l >= 0; --l) {
                        height += this.heights.get(l).floatValue();
                    }
                    float[] indents = this.bordersHandler.getCellBorderIndents(this.bordersHandler instanceof SeparatedTableBorders ? row : targetOverflowRowIndex[col], col, rowspan, colspan);
                    float cellHeightInLastRow = cell.getOccupiedArea().getBBox().getHeight() - height + indents[0] / 2.0f + indents[2] / 2.0f;
                    if (this.heights.get(this.heights.size() - 1).floatValue() < cellHeightInLastRow) {
                        if (this.bordersHandler instanceof SeparatedTableBorders) {
                            float differenceToConsider = cellHeightInLastRow - this.heights.get(this.heights.size() - 1).floatValue();
                            this.occupiedArea.getBBox().moveDown(differenceToConsider);
                            this.occupiedArea.getBBox().increaseHeight(differenceToConsider);
                        }
                        this.heights.set(this.heights.size() - 1, Float.valueOf(cellHeightInLastRow));
                        continue;
                    }
                    float shift = this.heights.get(this.heights.size() - 1).floatValue() - cellHeightInLastRow;
                    Rectangle bBox = cell.getOccupiedArea().getBBox();
                    bBox.moveDown(shift);
                    bBox.setHeight(height + this.heights.get(this.heights.size() - 1).floatValue());
                    cell.applyVerticalAlignment();
                }
            }
        }
        float additionalCellHeight = 0.0f;
        int numOfRowsWithFloatHeight = 0;
        if (isLastRenderer) {
            float additionalHeight = 0.0f;
            if (null != blockMinHeight && blockMinHeight.floatValue() > this.occupiedArea.getBBox().getHeight() + realBottomIndent / 2.0f) {
                additionalHeight = Math.min(layoutBox.getHeight() - realBottomIndent / 2.0f, blockMinHeight.floatValue() - this.occupiedArea.getBBox().getHeight() - realBottomIndent / 2.0f);
                for (int k = 0; k < rowsHasCellWithSetHeight.size(); ++k) {
                    if (!Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(k))) continue;
                    ++numOfRowsWithFloatHeight;
                }
            }
            additionalCellHeight = additionalHeight / (float)(0 == numOfRowsWithFloatHeight ? this.heights.size() : numOfRowsWithFloatHeight);
            for (int k = 0; k < this.heights.size(); ++k) {
                if (0 != numOfRowsWithFloatHeight && !Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(k))) continue;
                this.heights.set(k, Float.valueOf(this.heights.get(k).floatValue() + additionalCellHeight));
            }
        }
        float cumulativeShift = 0.0f;
        for (int k = 0; k < this.heights.size(); ++k) {
            this.correctRowCellsOccupiedAreas(splits, row, targetOverflowRowIndex, k, rowsHasCellWithSetHeight, cumulativeShift, additionalCellHeight);
            if (!isLastRenderer || 0 != numOfRowsWithFloatHeight && !Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(k))) continue;
            cumulativeShift += additionalCellHeight;
        }
        this.occupiedArea.getBBox().moveDown(cumulativeShift).increaseHeight(cumulativeShift);
        layoutBox.decreaseHeight(cumulativeShift);
    }

    private void correctRowCellsOccupiedAreas(LayoutResult[] splits, int row, int[] targetOverflowRowIndex, int currentRowIndex, List<Boolean> rowsHasCellWithSetHeight, float cumulativeShift, float additionalCellHeight) {
        CellRenderer[] currentRow = this.rows.get(currentRowIndex);
        for (int col = 0; col < currentRow.length; ++col) {
            CellRenderer cell;
            CellRenderer cellRenderer = cell = currentRowIndex < row || null == splits[col] ? currentRow[col] : (CellRenderer)splits[col].getSplitRenderer();
            if (cell == null) continue;
            float height = 0.0f;
            int colspan = cell.getPropertyAsInteger(16);
            int rowspan = cell.getPropertyAsInteger(60);
            float rowspanOffset = 0.0f;
            for (int l = (currentRowIndex < row ? currentRowIndex : this.heights.size() - 1) - 1; l > (currentRowIndex < row ? currentRowIndex : targetOverflowRowIndex[col]) - rowspan && l >= 0; --l) {
                height += this.heights.get(l).floatValue();
                if (!Boolean.FALSE.equals(rowsHasCellWithSetHeight.get(l))) continue;
                rowspanOffset += additionalCellHeight;
            }
            height += this.heights.get(currentRowIndex < row ? currentRowIndex : this.heights.size() - 1).floatValue();
            float[] indents = this.bordersHandler.getCellBorderIndents(currentRowIndex < row || this.bordersHandler instanceof SeparatedTableBorders ? currentRowIndex : targetOverflowRowIndex[col], col, rowspan, colspan);
            float shift = (height -= indents[0] / 2.0f + indents[2] / 2.0f) - cell.getOccupiedArea().getBBox().getHeight();
            Rectangle bBox = cell.getOccupiedArea().getBBox();
            bBox.moveDown(shift);
            try {
                cell.move(0.0f, -(cumulativeShift - rowspanOffset));
                bBox.setHeight(height);
                cell.applyVerticalAlignment();
                continue;
            }
            catch (NullPointerException e) {
                Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                logger.error(MessageFormatUtil.format((String)"Occupied area has not been initialized. {0}", (Object[])new Object[]{"Some of the cell's content might not end up placed correctly."}));
            }
        }
    }

    protected void extendLastRow(CellRenderer[] lastRow, Rectangle freeBox) {
        if (null != lastRow && 0 != this.heights.size()) {
            this.heights.set(this.heights.size() - 1, Float.valueOf(this.heights.get(this.heights.size() - 1).floatValue() + freeBox.getHeight()));
            this.occupiedArea.getBBox().moveDown(freeBox.getHeight()).increaseHeight(freeBox.getHeight());
            for (CellRenderer cell : lastRow) {
                if (null == cell) continue;
                cell.occupiedArea.getBBox().moveDown(freeBox.getHeight()).increaseHeight(freeBox.getHeight());
            }
            freeBox.moveUp(freeBox.getHeight()).setHeight(0.0f);
        }
    }

    private void setRowRange(Table.RowRange rowRange) {
        this.rowRange = rowRange;
        for (int row = rowRange.getStartRow(); row <= rowRange.getFinishRow(); ++row) {
            this.rows.add(new CellRenderer[((Table)this.modelElement).getNumberOfColumns()]);
        }
    }

    private TableRenderer initFooterOrHeaderRenderer(boolean footer, Border[] tableBorders) {
        Table table = (Table)this.getModelElement();
        boolean isSeparated = BorderCollapsePropertyValue.SEPARATE.equals(this.getProperty(114));
        Table footerOrHeader = footer ? table.getFooter() : table.getHeader();
        int innerBorder = footer ? 0 : 2;
        int outerBorder = footer ? 2 : 0;
        TableRenderer renderer = (TableRenderer)footerOrHeader.createRendererSubTree().setParent(this);
        this.ensureFooterOrHeaderHasTheSamePropertiesAsParentTableRenderer(renderer);
        boolean firstHeader = !footer && this.rowRange.getStartRow() == 0 && this.isOriginalNonSplitRenderer;
        LayoutTaggingHelper taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
        if (taggingHelper != null) {
            taggingHelper.addKidsHint(this, Collections.singletonList(renderer));
            LayoutTaggingHelper.addTreeHints(taggingHelper, renderer);
            if (!footer && !firstHeader) {
                taggingHelper.markArtifactHint(renderer);
            }
        }
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            if (table.isEmpty()) {
                if (!footer || null == this.headerRenderer) {
                    renderer.setBorders(tableBorders[innerBorder], innerBorder);
                }
                this.bordersHandler.tableBoundingBorders[innerBorder] = Border.NO_BORDER;
            }
            renderer.setBorders(tableBorders[1], 1);
            renderer.setBorders(tableBorders[3], 3);
            renderer.setBorders(tableBorders[outerBorder], outerBorder);
            this.bordersHandler.tableBoundingBorders[outerBorder] = Border.NO_BORDER;
        } else if (this.bordersHandler instanceof CollapsedTableBorders) {
            Border[] borders = renderer.getBorders();
            if (table.isEmpty()) {
                renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[innerBorder], tableBorders[innerBorder]), innerBorder);
                this.bordersHandler.tableBoundingBorders[innerBorder] = Border.NO_BORDER;
            }
            renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[1], tableBorders[1]), 1);
            renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[3], tableBorders[3]), 3);
            renderer.setBorders(CollapsedTableBorders.getCollapsedBorder(borders[outerBorder], tableBorders[outerBorder]), outerBorder);
            this.bordersHandler.tableBoundingBorders[outerBorder] = Border.NO_BORDER;
        }
        renderer.bordersHandler = isSeparated ? new SeparatedTableBorders(renderer.rows, ((Table)renderer.getModelElement()).getNumberOfColumns(), renderer.getBorders()) : new CollapsedTableBorders(renderer.rows, ((Table)renderer.getModelElement()).getNumberOfColumns(), renderer.getBorders());
        renderer.bordersHandler.initializeBorders();
        renderer.bordersHandler.setRowRange(renderer.rowRange.getStartRow(), renderer.rowRange.getFinishRow());
        renderer.bordersHandler.processAllBordersAndEmptyRows();
        renderer.correctRowRange();
        return renderer;
    }

    private void ensureFooterOrHeaderHasTheSamePropertiesAsParentTableRenderer(TableRenderer headerOrFooterRenderer) {
        headerOrFooterRenderer.setProperty(114, this.getProperty(114));
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            headerOrFooterRenderer.setProperty(115, this.getPropertyAsFloat(115));
            headerOrFooterRenderer.setProperty(116, this.getPropertyAsFloat(116));
            headerOrFooterRenderer.setProperty(9, Border.NO_BORDER);
            headerOrFooterRenderer.setProperty(11, Border.NO_BORDER);
            headerOrFooterRenderer.setProperty(13, Border.NO_BORDER);
            headerOrFooterRenderer.setProperty(12, Border.NO_BORDER);
            headerOrFooterRenderer.setProperty(10, Border.NO_BORDER);
        }
    }

    private TableRenderer prepareFooterOrHeaderRendererForLayout(TableRenderer renderer, float layoutBoxWidth) {
        renderer.countedColumnWidth = this.countedColumnWidth;
        renderer.bordersHandler.leftBorderMaxWidth = this.bordersHandler.getLeftBorderMaxWidth();
        renderer.bordersHandler.rightBorderMaxWidth = this.bordersHandler.getRightBorderMaxWidth();
        if (this.hasProperty(77)) {
            renderer.setProperty(77, UnitValue.createPointValue(layoutBoxWidth));
        }
        return this;
    }

    private boolean isHeaderRenderer() {
        return this.parent instanceof TableRenderer && ((TableRenderer)this.parent).headerRenderer == this;
    }

    private boolean isFooterRenderer() {
        return this.parent instanceof TableRenderer && ((TableRenderer)this.parent).footerRenderer == this;
    }

    private boolean isFooterRendererOfLargeTable() {
        return this.isFooterRenderer() && (!((TableRenderer)this.parent).getTable().isComplete() || 0 != ((TableRenderer)this.parent).getTable().getLastRowBottomBorder().size());
    }

    private boolean isTopTablePart() {
        return null == this.headerRenderer && (!this.isFooterRenderer() || 0 == ((TableRenderer)this.parent).rows.size() && null == ((TableRenderer)this.parent).headerRenderer);
    }

    private boolean isBottomTablePart() {
        return null == this.footerRenderer && (!this.isHeaderRenderer() || 0 == ((TableRenderer)this.parent).rows.size() && null == ((TableRenderer)this.parent).footerRenderer);
    }

    private void calculateColumnWidths(float availableWidth) {
        if (this.countedColumnWidth == null || this.totalWidthForColumns != availableWidth) {
            TableWidths tableWidths = new TableWidths(this, availableWidth, false, this.bordersHandler.rightBorderMaxWidth, this.bordersHandler.leftBorderMaxWidth);
            this.countedColumnWidth = tableWidths.layout();
        }
    }

    private float getTableWidth() {
        float sum = 0.0f;
        for (float column : this.countedColumnWidth) {
            sum += column;
        }
        if (this.bordersHandler instanceof SeparatedTableBorders) {
            sum += this.bordersHandler.getRightBorderMaxWidth() + this.bordersHandler.getLeftBorderMaxWidth();
            Float horizontalSpacing = this.getPropertyAsFloat(115);
            sum += null == horizontalSpacing ? 0.0f : horizontalSpacing.floatValue();
        } else {
            sum += this.bordersHandler.getRightBorderMaxWidth() / 2.0f + this.bordersHandler.getLeftBorderMaxWidth() / 2.0f;
        }
        return sum;
    }

    private void enlargeCellWithBigRowspan(CellRenderer[] currentRow, OverflowRowsWrapper overflowRows, int row, int col, int minRowspan, TableRenderer[] splitResult, int[] targetOverflowRowIndex) {
        int i;
        this.childRenderers.add(currentRow[col]);
        for (i = row; i < row + minRowspan && i + 1 < this.rows.size() && splitResult[1].rows.get(i + 1 - row)[col] != null; ++i) {
            overflowRows.setCell(i - row, col, splitResult[1].rows.get(i + 1 - row)[col]);
            overflowRows.setCell(i + 1 - row, col, null);
            this.rows.get((int)i)[col] = this.rows.get(i + 1)[col];
            this.rows.get((int)(i + 1))[col] = null;
        }
        if (i != row + minRowspan - 1 && null != this.rows.get(i)[col]) {
            CellRenderer overflowCell = (CellRenderer)((Cell)this.rows.get(i)[col].getModelElement()).getRenderer().setParent(this);
            overflowRows.setCell(i - row, col, null);
            overflowRows.setCell(targetOverflowRowIndex[col] - row, col, overflowCell);
            CellRenderer originalCell = this.rows.get(i)[col];
            this.rows.get((int)i)[col] = null;
            this.rows.get((int)targetOverflowRowIndex[col])[col] = originalCell;
            originalCell.isLastRendererForModelElement = false;
            overflowCell.setProperty(109, originalCell.getProperty(109));
        }
    }

    private void enlargeCell(int col, int row, int minRowspan, CellRenderer[] currentRow, OverflowRowsWrapper overflowRows, int[] targetOverflowRowIndex, TableRenderer[] splitResult) {
        LayoutArea cellOccupiedArea = currentRow[col].getOccupiedArea();
        if (1 == minRowspan) {
            CellRenderer overflowCell = (CellRenderer)((Cell)currentRow[col].getModelElement()).clone(true).getRenderer();
            overflowCell.setParent(this);
            overflowCell.deleteProperty(27);
            overflowCell.deleteProperty(85);
            overflowCell.deleteProperty(84);
            overflowRows.setCell(0, col, null);
            overflowRows.setCell(targetOverflowRowIndex[col] - row, col, overflowCell);
            this.childRenderers.add(currentRow[col]);
            CellRenderer originalCell = currentRow[col];
            currentRow[col] = null;
            this.rows.get((int)targetOverflowRowIndex[col])[col] = originalCell;
            originalCell.isLastRendererForModelElement = false;
            overflowCell.setProperty(109, originalCell.getProperty(109));
        } else {
            this.enlargeCellWithBigRowspan(currentRow, overflowRows, row, col, minRowspan, splitResult, targetOverflowRowIndex);
        }
        overflowRows.getCell((int)(targetOverflowRowIndex[col] - row), (int)col).occupiedArea = cellOccupiedArea;
    }

    void applyMarginsAndPaddingsAndCalculateColumnWidths(Rectangle layoutBox) {
        Logger logger;
        UnitValue[] paddings;
        Logger logger2;
        UnitValue[] margins = this.getMargins();
        if (!margins[1].isPointValue()) {
            logger2 = LoggerFactory.getLogger(TableRenderer.class);
            logger2.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{45}));
        }
        if (!margins[3].isPointValue()) {
            logger2 = LoggerFactory.getLogger(TableRenderer.class);
            logger2.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
        }
        if (!(paddings = this.getPaddings())[1].isPointValue()) {
            logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{49}));
        }
        if (!paddings[3].isPointValue()) {
            logger = LoggerFactory.getLogger(TableRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{48}));
        }
        this.calculateColumnWidths(layoutBox.getWidth() - margins[1].getValue() - margins[3].getValue() - paddings[1].getValue() - paddings[3].getValue());
    }

    private static class OverflowRowsWrapper {
        private TableRenderer overflowRenderer;
        private boolean isReplaced = false;

        public OverflowRowsWrapper(TableRenderer overflowRenderer) {
            this.overflowRenderer = overflowRenderer;
        }

        public CellRenderer getCell(int row, int col) {
            return this.overflowRenderer.rows.get(row)[col];
        }

        public CellRenderer setCell(int row, int col, CellRenderer newCell) {
            if (!this.isReplaced) {
                this.overflowRenderer.rows = new ArrayList<CellRenderer[]>(this.overflowRenderer.rows);
                this.isReplaced = true;
            }
            this.overflowRenderer.rows.set(row, (CellRenderer[])this.overflowRenderer.rows.get(row).clone());
            CellRenderer cellRenderer = newCell;
            this.overflowRenderer.rows.get((int)row)[col] = cellRenderer;
            return cellRenderer;
        }
    }

    private static class CellRendererInfo {
        public CellRenderer cellRenderer;
        public int column;
        public int finishRowInd;

        public CellRendererInfo(CellRenderer cellRenderer, int column, int finishRow) {
            this.cellRenderer = cellRenderer;
            this.column = column;
            this.finishRowInd = finishRow;
        }
    }
}

