/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ActionCheckUtil;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;

public final class AnnotationCheckUtil {
    private AnnotationCheckUtil() {
    }

    public static boolean isAnnotationVisible(PdfDictionary annotDict) {
        int flags;
        if (annotDict.getAsNumber(PdfName.F) != null && ((flags = annotDict.getAsNumber(PdfName.F).intValue()) & 2) != 0) {
            return false;
        }
        if (annotDict.getAsDictionary(PdfName.P) != null) {
            PdfArray pageBox;
            PdfDictionary page = annotDict.getAsDictionary(PdfName.P);
            PdfArray pdfArray = pageBox = page.getAsArray(PdfName.CropBox) == null ? page.getAsArray(PdfName.MediaBox) : page.getAsArray(PdfName.CropBox);
            if (pageBox != null && annotDict.getAsArray(PdfName.Rect) != null) {
                PdfArray annotBox = annotDict.getAsArray(PdfName.Rect);
                try {
                    if (pageBox.toRectangle().getIntersection(annotBox.toRectangle()) == null) {
                        return false;
                    }
                }
                catch (PdfException pdfException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public static class AnnotationHandler
    extends ContextAwareTagTreeIteratorHandler {
        public AnnotationHandler(PdfUAValidationContext context) {
            super(context);
        }

        public boolean accept(IStructureNode node) {
            return node != null;
        }

        public void processElement(IStructureNode elem) {
            PdfDictionary pageDict;
            if (!(elem instanceof PdfObjRef)) {
                return;
            }
            PdfObjRef objRef = (PdfObjRef)elem;
            PdfDictionary annotObj = objRef.getReferencedObject();
            if (annotObj == null) {
                return;
            }
            if (annotObj.getAsDictionary(PdfName.P) != null && !PdfName.S.equals((Object)(pageDict = annotObj.getAsDictionary(PdfName.P)).getAsName(PdfName.Tabs))) {
                throw new PdfUAConformanceException("A page with annotation(s) doesn't contains Tabs key with S value.");
            }
            PdfName subtype = annotObj.getAsName(PdfName.Subtype);
            if (!AnnotationCheckUtil.isAnnotationVisible(annotObj) || PdfName.Popup.equals((Object)subtype)) {
                return;
            }
            if (PdfName.PrinterMark.equals((Object)subtype)) {
                throw new PdfUAConformanceException("Annotations of subtype PrinterMark shall not be included in logical structure.");
            }
            if (PdfName.TrapNet.equals((Object)subtype)) {
                throw new PdfUAConformanceException("Annotations of subtype TrapNet shall not be permitted.");
            }
            if (!(PdfName.Widget.equals((Object)subtype) || annotObj.containsKey(PdfName.Contents) || annotObj.containsKey(PdfName.Alt))) {
                throw new PdfUAConformanceException(MessageFormatUtil.format((String)"Annotation of type {0} should have contents or alternate description.", (Object[])new Object[]{subtype.getValue()}));
            }
            if (PdfName.Link.equals((Object)subtype)) {
                PdfStructElem parentLink = this.context.getElementIfRoleMatches(PdfName.Link, objRef.getParent());
                if (parentLink == null) {
                    throw new PdfUAConformanceException("A link annotation is not nested within a <Link> tag.");
                }
                if (!annotObj.containsKey(PdfName.Contents)) {
                    throw new PdfUAConformanceException("Annotation of type Link shall contain an alternate description via their Contents key.");
                }
            }
            if (PdfName.Screen.equals((Object)subtype)) {
                PdfDictionary action = annotObj.getAsDictionary(PdfName.A);
                PdfDictionary additionalActions = annotObj.getAsDictionary(PdfName.AA);
                ActionCheckUtil.checkAction(action);
                AnnotationHandler.checkAAEntry(additionalActions);
            }
        }

        private static void checkAAEntry(PdfDictionary additionalActions) {
            if (additionalActions != null) {
                for (PdfObject val : additionalActions.values()) {
                    if (!(val instanceof PdfDictionary)) continue;
                    ActionCheckUtil.checkAction((PdfDictionary)val);
                }
            }
        }
    }
}

