/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1.report;

import com.itextpdf.signatures.validation.v1.report.CertificateReportItem;
import com.itextpdf.signatures.validation.v1.report.ReportItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ValidationReport {
    private final List<ReportItem> reportItems = new ArrayList<ReportItem>();

    public ValidationResult getValidationResult() {
        if (this.reportItems.stream().anyMatch(reportItem -> reportItem.getStatus() == ReportItem.ReportItemStatus.INVALID)) {
            return ValidationResult.INVALID;
        }
        if (this.reportItems.stream().anyMatch(reportItem -> reportItem.getStatus() == ReportItem.ReportItemStatus.INDETERMINATE)) {
            return ValidationResult.INDETERMINATE;
        }
        return ValidationResult.VALID;
    }

    public List<ReportItem> getFailures() {
        return this.reportItems.stream().filter(item -> item.getStatus() != ReportItem.ReportItemStatus.INFO).collect(Collectors.toList());
    }

    public List<CertificateReportItem> getCertificateFailures() {
        return this.getFailures().stream().filter(item -> item instanceof CertificateReportItem).map(item -> (CertificateReportItem)item).collect(Collectors.toList());
    }

    public List<ReportItem> getLogs() {
        return Collections.unmodifiableList(this.reportItems);
    }

    public List<CertificateReportItem> getCertificateLogs() {
        return this.reportItems.stream().filter(item -> item instanceof CertificateReportItem).map(item -> (CertificateReportItem)item).collect(Collectors.toList());
    }

    public void addReportItem(ReportItem item) {
        this.reportItems.add(item);
    }

    public String toString() {
        return "ValidationReport{reportItems=" + this.reportItems + '}';
    }

    public static enum ValidationResult {
        VALID,
        INVALID,
        INDETERMINATE;

    }
}

