/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.signatures.CertificateUtil;
import com.itextpdf.signatures.IIssuingCertificateRetriever;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuingCertificateRetriever
implements IIssuingCertificateRetriever {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private static final Logger LOGGER = LoggerFactory.getLogger(IssuingCertificateRetriever.class);
    private final TrustedCertificatesStore trustedCertificatesStore = new TrustedCertificatesStore();
    private final Map<String, List<Certificate>> knownCertificates = new HashMap<String, List<Certificate>>();

    @Override
    public Certificate[] retrieveMissingCertificates(Certificate[] chain) {
        ArrayList<Certificate> fullChain = new ArrayList<Certificate>();
        X509Certificate signingCertificate = (X509Certificate)chain[0];
        fullChain.add(signingCertificate);
        int i = 1;
        X509Certificate lastAddedCert = signingCertificate;
        while (!CertificateUtil.isSelfSigned(lastAddedCert)) {
            if (i < chain.length && CertificateUtil.isIssuerCertificate(lastAddedCert, (X509Certificate)chain[i])) {
                fullChain.add(chain[i]);
                ++i;
            } else {
                String url = CertificateUtil.getIssuerCertURL(lastAddedCert);
                Collection<Certificate> certificatesFromAIA = this.processCertificatesFromAIA(url);
                if (certificatesFromAIA == null || certificatesFromAIA.isEmpty()) {
                    Certificate issuer = IssuingCertificateRetriever.getIssuerFromCertificateSet(lastAddedCert, this.trustedCertificatesStore.getKnownCertificates(lastAddedCert.getIssuerX500Principal().getName()));
                    if (!(issuer != null && IssuingCertificateRetriever.isSignedBy(lastAddedCert, issuer) || (issuer = IssuingCertificateRetriever.getIssuerFromCertificateSet(lastAddedCert, (Collection<Certificate>)this.knownCertificates.get(lastAddedCert.getIssuerX500Principal().getName()))) != null)) {
                        while (i < chain.length) {
                            fullChain.add(chain[i]);
                            ++i;
                        }
                        return fullChain.toArray(new Certificate[0]);
                    }
                    fullChain.add(issuer);
                } else {
                    fullChain.addAll(certificatesFromAIA);
                }
            }
            lastAddedCert = (X509Certificate)fullChain.get(fullChain.size() - 1);
        }
        return fullChain.toArray(new Certificate[0]);
    }

    public List<X509Certificate[]> buildCertificateChains(X509Certificate certificate) {
        return this.buildCertificateChains(new X509Certificate[]{certificate});
    }

    public List<X509Certificate[]> buildCertificateChains(X509Certificate[] certificate) {
        List<List<X509Certificate>> allCertificateChains = this.buildCertificateChainsList(certificate);
        ArrayList<X509Certificate[]> result = new ArrayList<X509Certificate[]>(allCertificateChains.size() * 5);
        for (List<X509Certificate> chain : allCertificateChains) {
            Collections.reverse(chain);
            result.add(chain.toArray(new X509Certificate[0]));
        }
        return result;
    }

    private List<List<X509Certificate>> buildCertificateChainsList(X509Certificate[] certificates) {
        ArrayList<List<X509Certificate>> allChains = new ArrayList<List<X509Certificate>>(this.buildCertificateChainsList(certificates[certificates.length - 1]));
        for (List list : allChains) {
            for (int i = certificates.length - 2; i >= 0; --i) {
                list.add(certificates[i]);
            }
        }
        return allChains;
    }

    private List<List<X509Certificate>> buildCertificateChainsList(X509Certificate certificate) {
        if (CertificateUtil.isSelfSigned(certificate)) {
            ArrayList<List<X509Certificate>> singleChain = new ArrayList<List<X509Certificate>>();
            ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
            chain.add(certificate);
            singleChain.add(chain);
            return singleChain;
        }
        ArrayList<List<X509Certificate>> allChains = new ArrayList<List<X509Certificate>>();
        String url = CertificateUtil.getIssuerCertURL(certificate);
        Collection<Certificate> certificatesFromAIA = this.processCertificatesFromAIA(url);
        if (certificatesFromAIA != null && !certificatesFromAIA.isEmpty()) {
            List<List<X509Certificate>> issuerChains = this.buildCertificateChainsList(certificatesFromAIA.toArray(new X509Certificate[0]));
            for (List<X509Certificate> issuerChain : issuerChains) {
                issuerChain.add(certificate);
                allChains.add(issuerChain);
            }
        } else {
            Set<Certificate> possibleIssuers = this.trustedCertificatesStore.getKnownCertificates(certificate.getIssuerX500Principal().getName());
            if (this.knownCertificates.get(certificate.getIssuerX500Principal().getName()) != null) {
                possibleIssuers.addAll((Collection<Certificate>)this.knownCertificates.get(certificate.getIssuerX500Principal().getName()));
            }
            if (possibleIssuers.isEmpty()) {
                ArrayList<List<X509Certificate>> singleChain = new ArrayList<List<X509Certificate>>();
                ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
                chain.add(certificate);
                singleChain.add(chain);
                return singleChain;
            }
            for (Certificate possibleIssuer : possibleIssuers) {
                List<List<X509Certificate>> issuerChains = this.buildCertificateChainsList((X509Certificate)possibleIssuer);
                for (List<X509Certificate> issuerChain : issuerChains) {
                    issuerChain.add(certificate);
                    allChains.add(issuerChain);
                }
            }
        }
        return allChains;
    }

    public List<X509Certificate> retrieveIssuerCertificate(Certificate certificate) {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (X509Certificate[] certificateChain : this.buildCertificateChains((X509Certificate)certificate)) {
            if (certificateChain.length <= 1) continue;
            result.add(certificateChain[1]);
        }
        return result;
    }

    public Set<Certificate> retrieveOCSPResponderByNameCertificate(IBasicOCSPResp ocspResp) {
        String name = null;
        name = FACTORY.createX500Name(FACTORY.createASN1Sequence((IASN1Encodable)ocspResp.getResponderId().toASN1Primitive().getName().toASN1Primitive())).getName();
        Iterable<X509Certificate> certs = SignUtils.getCertsFromOcspResponse(ocspResp);
        for (X509Certificate cert : certs) {
            try {
                if (!name.equals(cert.getSubjectX500Principal().getName())) continue;
                return Collections.singleton(cert);
            }
            catch (Exception exception) {
            }
        }
        return this.trustedCertificatesStore.getKnownCertificates(name);
    }

    @Override
    public Certificate[] getCrlIssuerCertificates(CRL crl) {
        Certificate[][] result = this.getCrlIssuerCertificatesGeneric(crl, true);
        if (result.length == 0) {
            return new Certificate[0];
        }
        return result[0];
    }

    @Override
    public Certificate[][] getCrlIssuerCertificatesByName(CRL crl) {
        return this.getCrlIssuerCertificatesGeneric(crl, false);
    }

    private Certificate[][] getCrlIssuerCertificatesGeneric(CRL crl, boolean verify) {
        ArrayList<X509Certificate[]> matches = new ArrayList<X509Certificate[]>();
        String url = CertificateUtil.getIssuerCertURL(crl);
        List certificatesFromAIA = (List)this.processCertificatesFromAIA(url);
        if (certificatesFromAIA == null) {
            List<Certificate> localIssuers;
            Set<Certificate> issuers = this.trustedCertificatesStore.getKnownCertificates(((X509CRL)crl).getIssuerX500Principal().getName());
            if (issuers == null) {
                issuers = new HashSet<Certificate>();
            }
            if ((localIssuers = this.getCrlIssuersFromKnownCertificates((X509CRL)crl)) != null) {
                issuers.addAll(localIssuers);
            }
            if (issuers.isEmpty()) {
                return new Certificate[0][];
            }
            for (Certificate i : issuers) {
                if (verify && !IssuingCertificateRetriever.isSignedBy((X509CRL)crl, i)) continue;
                matches.addAll(this.buildCertificateChains((X509Certificate)i));
            }
            return (Certificate[][])matches.toArray((T[])new Certificate[0][]);
        }
        return (Certificate[][])this.buildCertificateChains(certificatesFromAIA.toArray(new X509Certificate[0])).toArray((T[])new Certificate[0][]);
    }

    @Override
    public void setTrustedCertificates(Collection<Certificate> certificates) {
        this.addTrustedCertificates(certificates);
    }

    public void addTrustedCertificates(Collection<Certificate> certificates) {
        this.trustedCertificatesStore.addGenerallyTrustedCertificates(certificates);
    }

    public void addKnownCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            String name = ((X509Certificate)certificate).getSubjectX500Principal().getName();
            List certs = this.knownCertificates.computeIfAbsent(name, k -> new ArrayList());
            certs.add(certificate);
        }
    }

    public TrustedCertificatesStore getTrustedCertificatesStore() {
        return this.trustedCertificatesStore;
    }

    public boolean isCertificateTrusted(Certificate certificate) {
        return this.trustedCertificatesStore.isCertificateGenerallyTrusted(certificate);
    }

    protected InputStream getIssuerCertByURI(String uri) throws IOException {
        return SignUtils.getHttpResponse(new URL(uri));
    }

    protected Collection<Certificate> parseCertificates(InputStream certsData) throws CertificateException {
        return SignUtils.readAllCerts(certsData, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Certificate> processCertificatesFromAIA(String url) {
        if (url == null) {
            return null;
        }
        try (InputStream missingCertsData = this.getIssuerCertByURI(url);){
            Collection<Certificate> collection = this.parseCertificates(missingCertsData);
            return collection;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to parse certificates coming from authority info access extension. Those won't be included into the certificate chain.");
            return null;
        }
    }

    private static boolean isSignedBy(X509Certificate certificate, Certificate issuer) {
        try {
            certificate.verify(issuer.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSignedBy(X509CRL crl, Certificate issuer) {
        try {
            crl.verify(issuer.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Certificate getIssuerFromCertificateSet(X509Certificate lastAddedCert, Collection<Certificate> certs) {
        if (certs != null) {
            for (Certificate cert : certs) {
                if (!IssuingCertificateRetriever.isSignedBy(lastAddedCert, cert)) continue;
                return cert;
            }
        }
        return null;
    }

    private List<Certificate> getCrlIssuersFromKnownCertificates(X509CRL crl) {
        return this.knownCertificates.get(crl.getIssuerX500Principal().getName());
    }
}

