/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.kernel.crypto.DigestAlgorithms;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.mac.IMacContainerLocator;
import com.itextpdf.kernel.pdf.PdfDeveloperExtension;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.PdfSignature;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.SignUtils;
import com.itextpdf.signatures.SignerProperties;
import com.itextpdf.signatures.cms.CMSContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.HashMap;

public class PdfTwoPhaseSigner {
    private final PdfReader reader;
    private final OutputStream outputStream;
    private IExternalDigest externalDigest;
    private StampingProperties stampingProperties = new StampingProperties().useAppendMode();
    private boolean closed;

    public PdfTwoPhaseSigner(PdfReader reader, OutputStream outputStream) {
        this.reader = reader;
        this.outputStream = outputStream;
    }

    public byte[] prepareDocumentForSignature(SignerProperties signerProperties, String digestAlgorithm, PdfName filter, PdfName subFilter, int estimatedSize, boolean includeDate) throws IOException, GeneralSecurityException {
        MessageDigest digest = this.externalDigest != null ? this.externalDigest.getMessageDigest(digestAlgorithm) : SignUtils.getMessageDigest(digestAlgorithm);
        return this.prepareDocumentForSignature(signerProperties, digest, filter, subFilter, estimatedSize, includeDate);
    }

    public static void addSignatureToPreparedDocument(PdfDocument document, String fieldName, OutputStream outs, CMSContainer cmsContainer) throws IOException, GeneralSecurityException {
        PdfSigner.SignatureApplier applier = new PdfSigner.SignatureApplier(document, fieldName, outs);
        applier.apply(a -> cmsContainer.serialize());
    }

    public static void addSignatureToPreparedDocument(PdfDocument document, String fieldName, OutputStream outs, byte[] signedContent) throws IOException, GeneralSecurityException {
        PdfSigner.SignatureApplier applier = new PdfSigner.SignatureApplier(document, fieldName, outs);
        applier.apply(a -> signedContent);
    }

    public PdfTwoPhaseSigner setExternalDigest(IExternalDigest externalDigest) {
        this.externalDigest = externalDigest;
        return this;
    }

    public PdfTwoPhaseSigner setStampingProperties(StampingProperties stampingProperties) {
        this.stampingProperties = stampingProperties;
        return this;
    }

    PdfSigner createPdfSigner(SignerProperties signerProperties) throws IOException {
        return new PdfSigner(this.reader, this.outputStream, null, this.stampingProperties, signerProperties);
    }

    private byte[] prepareDocumentForSignature(SignerProperties signerProperties, MessageDigest messageDigest, PdfName filter, PdfName subFilter, int estimatedSize, boolean includeDate) throws IOException {
        if (this.closed) {
            throw new PdfException("This instance of PdfSigner has been already closed.");
        }
        PdfSigner pdfSigner = this.createPdfSigner(signerProperties);
        PdfDocument document = pdfSigner.getDocument();
        if (((IMacContainerLocator)document.getDiContainer().getInstance(IMacContainerLocator.class)).isMacContainerLocated()) {
            throw new PdfException("It was not possible to embed MAC token into signature. Most likely signature container is empty.");
        }
        if (document.getPdfVersion().compareTo(PdfVersion.PDF_2_0) < 0) {
            document.getCatalog().addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        document.getCatalog().addDeveloperExtension(PdfDeveloperExtension.ISO_32002);
        document.getCatalog().addDeveloperExtension(PdfDeveloperExtension.ISO_32001);
        PdfSignature cryptoDictionary = pdfSigner.createSignatureDictionary(includeDate);
        cryptoDictionary.put(PdfName.Filter, (PdfObject)filter);
        cryptoDictionary.put(PdfName.SubFilter, (PdfObject)subFilter);
        pdfSigner.cryptoDictionary = cryptoDictionary;
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.Contents, estimatedSize * 2 + 2);
        pdfSigner.preClose(exc);
        InputStream data = pdfSigner.getRangeStream();
        byte[] digest = DigestAlgorithms.digest((InputStream)data, (MessageDigest)messageDigest);
        byte[] paddedSig = new byte[estimatedSize];
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.Contents, (PdfObject)new PdfString(paddedSig).setHexWriting(true));
        pdfSigner.close(dic2);
        pdfSigner.closed = true;
        this.closed = true;
        return digest;
    }
}

