/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GapShorthandResolver
implements IShorthandResolver {
    private final String gapShorthandProperty;
    private static final Logger LOGGER = LoggerFactory.getLogger(GapShorthandResolver.class);

    public GapShorthandResolver() {
        this("gap");
    }

    public GapShorthandResolver(String gapShorthandProperty) {
        this.gapShorthandProperty = gapShorthandProperty;
    }

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (CssTypesValidationUtils.isInitialOrInheritOrUnset(shorthandExpression = shorthandExpression.trim())) {
            return Arrays.asList(new CssDeclaration("row-gap", shorthandExpression), new CssDeclaration("column-gap", shorthandExpression));
        }
        if (CssTypesValidationUtils.containsInitialOrInheritOrUnset(shorthandExpression)) {
            return GapShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", this.gapShorthandProperty, shorthandExpression);
        }
        if (shorthandExpression.isEmpty()) {
            return GapShorthandResolver.handleExpressionError("{0} shorthand property cannot be empty.", this.gapShorthandProperty, shorthandExpression);
        }
        String[] gapProps = shorthandExpression.split(" ");
        if (gapProps.length == 1) {
            return this.resolveGapWithTwoProperties(gapProps[0], gapProps[0]);
        }
        if (gapProps.length == 2) {
            return this.resolveGapWithTwoProperties(gapProps[0], gapProps[1]);
        }
        return GapShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", this.gapShorthandProperty, shorthandExpression);
    }

    private List<CssDeclaration> resolveGapWithTwoProperties(String row, String column) {
        CssDeclaration rowGapDeclaration = new CssDeclaration("row-gap", row);
        if (!CssDeclarationValidationMaster.checkDeclaration(rowGapDeclaration)) {
            return GapShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "row-gap", row);
        }
        CssDeclaration columnGapDeclaration = new CssDeclaration("column-gap", column);
        if (!CssDeclarationValidationMaster.checkDeclaration(columnGapDeclaration)) {
            return GapShorthandResolver.handleExpressionError("Invalid css property declaration: {0}", "column-gap", column);
        }
        return Arrays.asList(rowGapDeclaration, columnGapDeclaration);
    }

    private static List<CssDeclaration> handleExpressionError(String logMessage, String attribute, String shorthandExpression) {
        LOGGER.warn(MessageFormatUtil.format((String)logMessage, (Object[])new Object[]{attribute, shorthandExpression}));
        return Collections.emptyList();
    }
}

