/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.svg.utils.SvgCssUtils;

public class SvgCoordinateUtils {
    public static String[] makeRelativeOperatorCoordinatesAbsolute(String[] relativeCoordinates, double[] currentCoordinates) {
        if (relativeCoordinates.length % currentCoordinates.length != 0) {
            throw new IllegalArgumentException("Array of current coordinates must have length that is divisible by the length of the array with current coordinates");
        }
        String[] absoluteOperators = new String[relativeCoordinates.length];
        int i = 0;
        while (i < relativeCoordinates.length) {
            int j = 0;
            while (j < currentCoordinates.length) {
                double relativeDouble = Double.parseDouble(relativeCoordinates[i]);
                absoluteOperators[i] = SvgCssUtils.convertDoubleToString(relativeDouble += currentCoordinates[j]);
                ++j;
                ++i;
            }
        }
        return absoluteOperators;
    }

    public static double calculateAngleBetweenTwoVectors(Vector vectorA, Vector vectorB) {
        return Math.acos((double)vectorA.dot(vectorB) / ((double)vectorA.length() * (double)vectorB.length()));
    }
}

