/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.WebColors;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.ClipPathSvgNodeRenderer;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractSvgNodeRenderer
implements ISvgNodeRenderer {
    protected Map<String, String> attributesAndStyles;
    boolean partOfClipPath;
    boolean doFill = false;
    boolean doStroke = false;
    private ISvgNodeRenderer parent;

    @Override
    public void setParent(ISvgNodeRenderer parent) {
        this.parent = parent;
    }

    @Override
    public ISvgNodeRenderer getParent() {
        return this.parent;
    }

    @Override
    public void setAttributesAndStyles(Map<String, String> attributesAndStyles) {
        this.attributesAndStyles = attributesAndStyles;
    }

    @Override
    public String getAttribute(String key) {
        return this.attributesAndStyles.get(key);
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.attributesAndStyles == null) {
            this.attributesAndStyles = new HashMap<String, String>();
        }
        this.attributesAndStyles.put(key, value);
    }

    @Override
    public Map<String, String> getAttributeMapCopy() {
        HashMap<String, String> copy = new HashMap<String, String>();
        if (this.attributesAndStyles == null) {
            return copy;
        }
        copy.putAll(this.attributesAndStyles);
        return copy;
    }

    @Override
    public final void draw(SvgDrawContext context) {
        PdfCanvas currentCanvas = context.getCurrentCanvas();
        if (this.attributesAndStyles != null) {
            AffineTransform transformation;
            String transformString = this.attributesAndStyles.get("transform");
            if (transformString != null && !transformString.isEmpty() && !(transformation = TransformUtils.parseTransform(transformString)).isIdentity()) {
                currentCanvas.concatMatrix(transformation);
            }
            if (this.attributesAndStyles.containsKey("id")) {
                context.addUsedId(this.attributesAndStyles.get("id"));
            }
        }
        if (!this.drawInClipPath(context)) {
            this.preDraw(context);
            this.doDraw(context);
            this.postDraw(context);
        }
        if (this.attributesAndStyles.containsKey("id")) {
            context.removeUsedId(this.attributesAndStyles.get("id"));
        }
    }

    protected boolean canElementFill() {
        return true;
    }

    public boolean canConstructViewPort() {
        return false;
    }

    protected void deepCopyAttributesAndStyles(ISvgNodeRenderer deepCopy) {
        HashMap<String, String> stylesDeepCopy = new HashMap<String, String>();
        if (this.attributesAndStyles != null) {
            stylesDeepCopy.putAll(this.attributesAndStyles);
            deepCopy.setAttributesAndStyles(stylesDeepCopy);
        }
    }

    protected abstract void doDraw(SvgDrawContext var1);

    static float getAlphaFromRGBA(String value) {
        try {
            return WebColors.getRGBAColor((String)value)[3];
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException exc) {
            return 1.0f;
        }
    }

    AffineTransform calculateViewPortTranslation(SvgDrawContext context) {
        Rectangle viewPort = context.getCurrentViewPort();
        AffineTransform transform = AffineTransform.getTranslateInstance((double)viewPort.getX(), (double)viewPort.getY());
        return transform;
    }

    void postDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            if (this.partOfClipPath) {
                if ("evenodd".equalsIgnoreCase(this.getAttribute("clip-rule"))) {
                    currentCanvas.eoClip();
                } else {
                    currentCanvas.clip();
                }
                currentCanvas.newPath();
            } else if (this.doFill && this.canElementFill()) {
                String fillRuleRawValue = this.getAttribute("fill-rule");
                if ("evenodd".equalsIgnoreCase(fillRuleRawValue)) {
                    if (this.doStroke) {
                        currentCanvas.eoFillStroke();
                    } else {
                        currentCanvas.eoFill();
                    }
                } else if (this.doStroke) {
                    currentCanvas.fillStroke();
                } else {
                    currentCanvas.fill();
                }
            } else if (this.doStroke) {
                currentCanvas.stroke();
            }
        }
    }

    void setPartOfClipPath(boolean value) {
        this.partOfClipPath = value;
    }

    void preDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null) {
            PdfCanvas currentCanvas = context.getCurrentCanvas();
            PdfExtGState opacityGraphicsState = new PdfExtGState();
            if (!this.partOfClipPath) {
                String strokeRawValue;
                String opacityValue;
                Color rgbColor;
                float generalOpacity = this.getOpacity();
                String fillRawValue = this.getAttribute("fill");
                boolean bl = this.doFill = !"none".equalsIgnoreCase(fillRawValue);
                if (this.doFill && this.canElementFill()) {
                    rgbColor = ColorConstants.BLACK;
                    float fillOpacity = generalOpacity;
                    opacityValue = this.getAttribute("fill-opacity");
                    if (opacityValue != null && !"none".equalsIgnoreCase(opacityValue)) {
                        fillOpacity *= Float.valueOf(opacityValue).floatValue();
                    }
                    if (fillRawValue != null) {
                        fillOpacity *= AbstractSvgNodeRenderer.getAlphaFromRGBA(fillRawValue);
                        rgbColor = WebColors.getRGBColor((String)fillRawValue);
                    }
                    if (!CssUtils.compareFloats((float)fillOpacity, (float)1.0f)) {
                        opacityGraphicsState.setFillOpacity(fillOpacity);
                    }
                    currentCanvas.setFillColor(rgbColor);
                }
                if (!"none".equalsIgnoreCase(strokeRawValue = this.getAttribute("stroke")) && strokeRawValue != null) {
                    rgbColor = WebColors.getRGBColor((String)strokeRawValue);
                    float strokeOpacity = generalOpacity;
                    opacityValue = this.getAttribute("stroke-opacity");
                    if (opacityValue != null && !"none".equalsIgnoreCase(opacityValue)) {
                        strokeOpacity *= Float.valueOf(opacityValue).floatValue();
                    }
                    if (!CssUtils.compareFloats((float)(strokeOpacity *= AbstractSvgNodeRenderer.getAlphaFromRGBA(strokeRawValue)), (float)1.0f)) {
                        opacityGraphicsState.setStrokeOpacity(strokeOpacity);
                    }
                    currentCanvas.setStrokeColor(rgbColor);
                    String strokeWidthRawValue = this.getAttribute("stroke-width");
                    float strokeWidth = 1.0f;
                    if (strokeWidthRawValue != null) {
                        strokeWidth = CssUtils.parseAbsoluteLength((String)strokeWidthRawValue);
                    }
                    currentCanvas.setLineWidth(strokeWidth);
                    this.doStroke = true;
                }
                if (!((PdfDictionary)opacityGraphicsState.getPdfObject()).isEmpty()) {
                    currentCanvas.setExtGState(opacityGraphicsState);
                }
            }
        }
    }

    private boolean drawInClipPath(SvgDrawContext context) {
        String clipPathName;
        ISvgNodeRenderer template;
        if (this.attributesAndStyles.containsKey("clip-path") && (template = context.getNamedObject(this.normalizeClipPathName(clipPathName = this.attributesAndStyles.get("clip-path")))) instanceof ClipPathSvgNodeRenderer) {
            ClipPathSvgNodeRenderer clipPath = (ClipPathSvgNodeRenderer)template.createDeepCopy();
            clipPath.setClippedRenderer(this);
            clipPath.draw(context);
            return !clipPath.getChildren().isEmpty();
        }
        return false;
    }

    private String normalizeClipPathName(String name) {
        return name.replace("url(#", "").replace(")", "").trim();
    }

    private float getOpacity() {
        float result = 1.0f;
        String opacityValue = this.getAttribute("opacity");
        if (opacityValue != null && !"none".equalsIgnoreCase(opacityValue)) {
            result = Float.valueOf(opacityValue).floatValue();
        }
        if (this.parent != null && this.parent instanceof AbstractSvgNodeRenderer) {
            result *= ((AbstractSvgNodeRenderer)this.parent).getOpacity();
        }
        return result;
    }
}

