/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.colors.gradients.GradientSpreadMethod;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgPaintServer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.StopSvgNodeRenderer;
import com.itextpdf.svg.utils.TransformUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class AbstractGradientSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer
implements ISvgPaintServer {
    @Override
    protected void doDraw(SvgDrawContext context) {
        throw new UnsupportedOperationException("The renderer cannot be drawn.");
    }

    protected boolean isObjectBoundingBoxUnits() {
        String gradientUnits = this.getAttribute("gradientUnits");
        if (gradientUnits == null) {
            this.getAttribute("gradientUnits".toLowerCase());
        }
        if ("userSpaceOnUse".equals(gradientUnits)) {
            return false;
        }
        if (gradientUnits != null && !"objectBoundingBox".equals(gradientUnits)) {
            LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format((String)"Could not recognize gradient units value {0}", (Object[])new Object[]{gradientUnits}));
        }
        return true;
    }

    protected AffineTransform getGradientTransform() {
        String gradientTransform = this.getAttribute("gradientTransform");
        if (gradientTransform == null) {
            gradientTransform = this.getAttribute("gradientTransform".toLowerCase());
        }
        if (gradientTransform != null && !gradientTransform.isEmpty()) {
            return TransformUtils.parseTransform(gradientTransform);
        }
        return null;
    }

    protected List<StopSvgNodeRenderer> getChildStopRenderers() {
        ArrayList<StopSvgNodeRenderer> stopRenderers = new ArrayList<StopSvgNodeRenderer>();
        for (ISvgNodeRenderer child : this.getChildren()) {
            if (!(child instanceof StopSvgNodeRenderer)) continue;
            stopRenderers.add((StopSvgNodeRenderer)child);
        }
        return stopRenderers;
    }

    protected GradientSpreadMethod parseSpreadMethod() {
        String spreadMethodValue = this.getAttribute("spreadMethod");
        if (spreadMethodValue == null) {
            spreadMethodValue = this.getAttribute("spreadMethod".toLowerCase());
        }
        if (spreadMethodValue == null) {
            return GradientSpreadMethod.PAD;
        }
        switch (spreadMethodValue) {
            case "pad": {
                return GradientSpreadMethod.PAD;
            }
            case "reflect": {
                return GradientSpreadMethod.REFLECT;
            }
            case "repeat": {
                return GradientSpreadMethod.REPEAT;
            }
        }
        LoggerFactory.getLogger(this.getClass()).warn(MessageFormatUtil.format((String)"Could not recognize gradient spread method value {0}", (Object[])new Object[]{spreadMethodValue}));
        return GradientSpreadMethod.PAD;
    }
}

