/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.JDBCMonProxy;
import com.jamonapi.proxy.MonProxy;
import com.jamonapi.proxy.MonProxyLabeler;
import com.jamonapi.proxy.MonProxyLabelerInt;
import com.jamonapi.proxy.Params;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MonProxyFactoryImp {
    private static final String EXCEPTION = "Exception";
    private final Class[] CLASS_ARRAY = new Class[0];
    private Params params = new Params();
    private MonProxyLabelerInt labelFactory = new MonProxyLabeler();

    public void setLabelFactory(MonProxyLabelerInt factory) {
        this.labelFactory = factory;
    }

    public MonProxyLabelerInt getLabelFactory() {
        return this.labelFactory;
    }

    public MonProxy getMonProxy(Proxy proxy) {
        return (MonProxy)Proxy.getInvocationHandler(proxy);
    }

    public Object monitor(Object object) {
        if (!this.isEnabled() || object == null) {
            return object;
        }
        return this.monitorNoCheck(object, this.getInterfaces(object.getClass()));
    }

    public Object monitor(Object object, Class[] interfaces) {
        if (!this.isEnabled() || object == null) {
            return object;
        }
        return this.monitorNoCheck(object, interfaces);
    }

    private Object monitorNoCheck(Object object, Class[] interfaces) {
        MonProxy monProxy = new MonProxy(object, this.params, (MonProxyLabelerInt)this.labelFactory.clone());
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), interfaces, (InvocationHandler)monProxy);
    }

    public Object monitor(Object object, Class iface) {
        return this.monitor(object, new Class[]{iface});
    }

    public Connection monitor(Connection conn) {
        return (Connection)this.monitorJDBC(conn);
    }

    public ResultSet monitor(ResultSet rs) {
        return (ResultSet)this.monitorJDBC(rs);
    }

    public Statement monitor(Statement statement) {
        return (Statement)this.monitorJDBC(statement);
    }

    public PreparedStatement monitor(PreparedStatement statement) {
        return (PreparedStatement)this.monitorJDBC(statement);
    }

    public CallableStatement monitor(CallableStatement statement) {
        return (CallableStatement)this.monitorJDBC(statement);
    }

    Object monitorJDBC(Object object) {
        if (!this.params.isEnabled || !this.params.isSQLSummaryEnabled && !this.params.isSQLDetailEnabled || object == null || object instanceof Proxy && Proxy.getInvocationHandler(object) instanceof JDBCMonProxy) {
            return object;
        }
        JDBCMonProxy monProxy = new JDBCMonProxy(object, this.params, (MonProxyLabelerInt)this.labelFactory.clone());
        return Proxy.newProxyInstance(object.getClass().getClassLoader(), this.getInterfaces(object.getClass()), (InvocationHandler)monProxy);
    }

    public Class[] getInterfaces(Class cls) {
        if (cls == null) {
            return null;
        }
        HashSet interfaceHeirarchy = new HashSet();
        Class[] objTree = this.getClassHeirarchy(cls);
        for (int i = 0; i < objTree.length; ++i) {
            this.getInterfaces(objTree[i], interfaceHeirarchy);
        }
        return this.toClassArray(interfaceHeirarchy);
    }

    private Class[] toClassArray(Collection coll) {
        if (coll == null || coll.size() == 0) {
            return null;
        }
        return coll.toArray(this.CLASS_ARRAY);
    }

    private Class[] getClassHeirarchy(Class cls) {
        if (cls == null) {
            return null;
        }
        ArrayList classes = new ArrayList();
        while (cls != null) {
            classes.add(cls);
            cls = cls.getSuperclass();
        }
        return this.toClassArray(classes);
    }

    private void getInterfaces(Class cls, Set heirarchy) {
        if (cls != null) {
            Class<?>[] heir = cls.getInterfaces();
            int len = heir == null ? 0 : heir.length;
            for (int i = 0; i < len; ++i) {
                heirarchy.add(heir[i]);
                this.getInterfaces(heir[i], heirarchy);
            }
        }
    }

    public int getExceptionBufferSize() {
        JAMonBufferListener jaMonBufferListener = this.getExceptionBufferListener();
        if (jaMonBufferListener == null) {
            return 0;
        }
        return jaMonBufferListener.getBufferList().getBufferSize();
    }

    public void setExceptionBufferSize(int exceptionBufferSize) {
        JAMonBufferListener jaMonBufferListener = this.getExceptionBufferListener();
        if (jaMonBufferListener == null) {
            return;
        }
        jaMonBufferListener.getBufferList().setBufferSize(exceptionBufferSize);
    }

    public void resetExceptionDetail() {
        JAMonBufferListener jaMonBufferListener = this.getExceptionBufferListener();
        if (jaMonBufferListener == null) {
            return;
        }
        jaMonBufferListener.getBufferList().reset();
    }

    public boolean isInterfaceEnabled() {
        return this.params.isInterfaceEnabled;
    }

    public void enableInterface(boolean enable) {
        this.params.isInterfaceEnabled = enable;
        if (enable) {
            this.enable(true);
        }
    }

    @Deprecated
    public boolean isExceptionSummaryEnabled() {
        return true;
    }

    @Deprecated
    public void enableExceptionSummary(boolean enable) {
    }

    @Deprecated
    public boolean isExceptionDetailEnabled() {
        return true;
    }

    @Deprecated
    public void enableExceptionDetail(boolean enable) {
    }

    public boolean isSQLSummaryEnabled() {
        return this.params.isSQLSummaryEnabled;
    }

    public void enableSQLSummary(boolean enable) {
        this.params.isSQLSummaryEnabled = enable;
        if (enable) {
            this.enable(true);
        }
    }

    public boolean isSQLDetailEnabled() {
        return this.params.isSQLDetailEnabled;
    }

    public void enableSQLDetail(boolean enable) {
        this.params.isSQLDetailEnabled = enable;
        if (enable) {
            this.params.sqlBuffer.enable();
        } else {
            this.params.sqlBuffer.disable();
        }
        if (enable) {
            this.enable(true);
        }
    }

    public boolean isResultSetEnabled() {
        return this.params.isResultSetEnabled;
    }

    public void enableResultSet(boolean enable) {
        this.params.isResultSetEnabled = enable;
        if (enable) {
            this.enableInterface(true);
            this.enable(true);
        }
    }

    public boolean isEnabled() {
        return this.params.isEnabled;
    }

    public void enableAll(boolean enable) {
        this.enable(enable);
        this.enableInterface(enable);
        this.enableSQLSummary(enable);
        this.enableSQLDetail(enable);
        this.enableResultSet(enable);
    }

    public boolean isAllEnabled() {
        return this.params.isEnabled && this.params.isSQLSummaryEnabled && this.params.isSQLDetailEnabled && this.params.isInterfaceEnabled && this.params.isResultSetEnabled;
    }

    public void enable(boolean enable) {
        this.params.isEnabled = enable;
    }

    Params getParams() {
        return this.params;
    }

    public String[] getExceptionDetailHeader() {
        JAMonBufferListener jaMonBufferListener = this.getExceptionBufferListener();
        if (jaMonBufferListener == null) {
            return null;
        }
        return jaMonBufferListener.getDetailData().getHeader();
    }

    private JAMonBufferListener getExceptionBufferListener() {
        JAMonListener bufferListener;
        Monitor mon;
        if (MonitorFactory.exists("com.jamonapi.Exceptions", EXCEPTION) && (mon = MonitorFactory.getMonitor("com.jamonapi.Exceptions", EXCEPTION)).hasListener("value", "FIFOBuffer") && (bufferListener = mon.getListenerType("value").getListener("FIFOBuffer")) instanceof JAMonBufferListener) {
            return (JAMonBufferListener)bufferListener;
        }
        return null;
    }

    public Object[][] getExceptionDetail() {
        JAMonBufferListener jaMonBufferListener = this.getExceptionBufferListener();
        if (jaMonBufferListener == null) {
            return null;
        }
        return jaMonBufferListener.getDetailData().getData();
    }

    public int getSQLBufferSize() {
        return this.params.sqlBuffer.getBufferSize();
    }

    public void setSQLBufferSize(int sqlBufferSize) {
        this.params.sqlBuffer.setBufferSize(sqlBufferSize);
    }

    public void resetSQLDetail() {
        this.params.sqlBuffer.reset();
    }

    public String[] getSQLDetailHeader() {
        return this.params.sqlBuffer.getHeader();
    }

    public Object[][] getSQLDetail() {
        return this.params.sqlBuffer.getData();
    }

    public List getMatchStrings() {
        return this.params.matchStrings;
    }

    public void setMatchStrings(List ms) {
        this.params.matchStrings = ms;
    }
}

