/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.filter.log;

import com.jayway.restassured.builder.ResponseBuilder;
import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.internal.RestAssuredResponseImpl;
import com.jayway.restassured.response.Cookies;
import com.jayway.restassured.response.Headers;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.FilterableResponseSpecification;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusCodeBasedLoggingFilter
implements Filter {
    private final PrintStream stream;
    private final Matcher<?> matcher;
    private final LogDetail logDetail;

    public StatusCodeBasedLoggingFilter(Matcher<Integer> matcher) {
        this(System.out, matcher);
    }

    public StatusCodeBasedLoggingFilter(PrintStream stream, Matcher<Integer> matcher) {
        this(LogDetail.ALL, stream, matcher);
    }

    public StatusCodeBasedLoggingFilter(LogDetail logDetail, PrintStream stream, Matcher<Integer> matcher) {
        Validate.notNull((Object)((Object)logDetail), (String)"Log details cannot be null");
        Validate.notNull((Object)stream, (String)"Print stream cannot be null");
        Validate.notNull(matcher, (String)"Matcher cannot be null");
        if (logDetail == LogDetail.PARAMS) {
            throw new IllegalArgumentException(String.format("%s is not a valid %s for a response.", new Object[]{LogDetail.PARAMS, LogDetail.class.getSimpleName()}));
        }
        this.logDetail = logDetail;
        this.stream = stream;
        this.matcher = matcher;
    }

    @Override
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        Response response = ctx.next(requestSpec, responseSpec);
        int statusCode = response.statusCode();
        if (this.matcher.matches((Object)statusCode)) {
            String responseAsString = this.log(response);
            response = this.cloneResponseIfNeeded(response, responseAsString);
        }
        return response;
    }

    private String log(Response response) {
        Cookies cookies;
        StringBuilder builder = new StringBuilder();
        String responseBody = null;
        if (this.logDetail == LogDetail.ALL || this.logDetail == LogDetail.STATUS) {
            builder.append(response.statusLine());
        }
        if (this.logDetail == LogDetail.ALL || this.logDetail == LogDetail.HEADERS) {
            Headers headers = response.headers();
            if (headers.exist()) {
                this.appendNewLineIfAll(this.logDetail, builder).append(headers.toString());
            }
        } else if (this.logDetail == LogDetail.COOKIES && (cookies = response.detailedCookies()).exist()) {
            this.appendNewLineIfAll(this.logDetail, builder).append(cookies.toString());
        }
        if (this.logDetail == LogDetail.ALL || this.logDetail == LogDetail.BODY) {
            responseBody = response.asString();
            if (this.logDetail == LogDetail.ALL && !StringUtils.isBlank((String)responseBody)) {
                builder.append("\n\n");
            }
            builder.append(responseBody);
        }
        this.stream.println(builder.toString());
        return responseBody;
    }

    private StringBuilder appendNewLineIfAll(LogDetail logDetail, StringBuilder builder) {
        if (logDetail == LogDetail.ALL) {
            builder.append("\n");
        }
        return builder;
    }

    private Response cloneResponseIfNeeded(Response response, String responseAsString) {
        if (responseAsString != null && response instanceof RestAssuredResponseImpl && !((RestAssuredResponseImpl)response).getHasExpectations()) {
            Response build = new ResponseBuilder().clone(response).setBody(responseAsString).build();
            ((RestAssuredResponseImpl)build).setHasExpectations(true);
            return build;
        }
        return response;
    }
}

