/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.parsing;

import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Parser {
    XML("application/xml", "text/xml", "application/xhtml+xml"),
    TEXT("text/plain", "*/*"),
    JSON("application/json", "application/javascript", "text/javascript"),
    HTML("text/html");

    private final String[] contentTypes;

    private Parser(String ... contentTypes) {
        this.contentTypes = contentTypes;
    }

    public String getContentType() {
        return this.contentTypes[0];
    }

    public static Parser fromContentType(String contentType) {
        Parser foundParser = ArrayUtils.contains((Object[])Parser.XML.contentTypes, (Object)(contentType = contentType.toLowerCase())) ? XML : (ArrayUtils.contains((Object[])Parser.JSON.contentTypes, (Object)contentType) ? JSON : (ArrayUtils.contains((Object[])Parser.TEXT.contentTypes, (Object)contentType) ? TEXT : (ArrayUtils.contains((Object[])Parser.HTML.contentTypes, (Object)contentType) ? HTML : null)));
        return foundParser;
    }
}

