/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.maven.plugin;

import com.jcabi.log.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="versionalize", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public final class VersionalizeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private transient MavenProject project;
    @Parameter(property="buildNumber")
    private transient String buildNumber;

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        File src = new File(this.project.getBuild().getSourceDirectory());
        if (!src.exists()) {
            Logger.info((Object)((Object)this), (String)"source directory '%s' is absent", (Object[])new Object[]{src});
            return;
        }
        File dest = new File(this.project.getBuild().getOutputDirectory());
        if (dest.mkdirs()) {
            Logger.info((Object)((Object)this), (String)"created directory %s", (Object[])new Object[]{dest});
        }
        Logger.info((Object)((Object)this), (String)"Versionalizing %s directory", (Object[])new Object[]{dest});
        try {
            this.versionalize(src, dest);
        }
        catch (IOException ex) {
            throw new MojoFailureException("failed to versionalize", (Throwable)ex);
        }
    }

    private String text(File dir) {
        StringBuilder text = new StringBuilder(0).append(String.format("Build Number: %s%n", this.buildNumber)).append(String.format("Project Version: %s%n", this.project.getVersion())).append(String.format("Build Date: %s%n%n", DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.format(new Date())));
        for (String name : VersionalizeMojo.files(dir, "*")) {
            File file = new File(dir, name);
            if (!file.isFile()) continue;
            text.append(name).append(": ").append(file.length()).append('\n');
        }
        return text.toString();
    }

    private void versionalize(File src, File dest) throws IOException {
        Collection dirs = FileUtils.listFilesAndDirs((File)src, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        String name = String.format("%s-%s-%s.txt", VersionalizeMojo.cleanup(this.project.getGroupId()), VersionalizeMojo.cleanup(this.project.getArtifactId()), VersionalizeMojo.cleanup(this.project.getPackaging()));
        for (File dir : dirs) {
            if (VersionalizeMojo.files(dir, "*.java").isEmpty()) continue;
            File ddir = new File(dest, StringUtils.substring((String)dir.getCanonicalPath(), (int)(src.getCanonicalPath().length() + 1)));
            File version = new File(ddir, name);
            if (version.getParentFile().mkdirs()) {
                Logger.info((Object)((Object)this), (String)"created dir %s", (Object[])new Object[]{version.getParentFile()});
            }
            Files.write(version.toPath(), this.text(ddir).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Logger.info((Object)((Object)this), (String)"File %s added", (Object[])new Object[]{version});
        }
    }

    private static String cleanup(String text) {
        return text.replaceAll("[^_a-z0-9\\-]", "-");
    }

    private static Collection<String> files(File dir, String mask) {
        WildcardFileFilter filter = new WildcardFileFilter(mask);
        File[] files = dir.listFiles((FileFilter)filter);
        ArrayList<String> names = new ArrayList<String>(files.length);
        for (File file : files) {
            names.add(file.getName());
        }
        return names;
    }
}

