/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class MemJavaFileObject
extends SimpleJavaFileObject {
    ByteArrayOutputStream baos;
    String name;

    MemJavaFileObject(String urlPrefix, String name, JavaFileObject.Kind kind) {
        super(URI.create(urlPrefix + MemJavaFileObject.encode(name) + kind.extension), kind);
        this.name = name;
    }

    private static String encode(String name) {
        return name.replace("%", "%37").replace(" ", "%20");
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException, IllegalStateException, UnsupportedOperationException {
        if (this.baos == null) {
            throw new FileNotFoundException(this.name);
        }
        return new String(this.baos.toByteArray());
    }

    @Override
    public InputStream openInputStream() throws IOException, IllegalStateException, UnsupportedOperationException {
        if (this.baos == null) {
            throw new FileNotFoundException(this.name);
        }
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    @Override
    public OutputStream openOutputStream() throws IOException, IllegalStateException, UnsupportedOperationException {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

